/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.code.generator;

import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.interfaces.IImageViewCode;

public class ImageViewGenerator
extends Generator
implements IImageViewCode {
    private static final String CONTENT_MODE = "content_mode";
    private static final String LAZY_LOAD = "lazy";

    public ImageViewGenerator() {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("view", "ImageView()");
    }

    @Override
    public void addImage(String src) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("src", "'" + src + "'");
    }

    @Override
    public void addContentMode(int mode) {
        if (this.codeMap == null) {
            return;
        }
        switch (mode) {
            case 0: {
                this.codeMap.remove(CONTENT_MODE);
                break;
            }
            case -1: {
                this.codeMap.put(CONTENT_MODE, "ContentMode.SCALE_TO_FILL");
                break;
            }
            case 1: {
                this.codeMap.put(CONTENT_MODE, "ContentMode.SCALE_ASPECT_FILL");
            }
        }
    }

    @Override
    public void addLazy(boolean lazy) {
        if (this.codeMap == null) {
            return;
        }
        if (lazy) {
            this.codeMap.remove(LAZY_LOAD);
        } else {
            this.codeMap.put(LAZY_LOAD, String.valueOf(lazy));
        }
    }
}

