/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.code.generator;

import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.utils.ColorUtils;
import com.immomo.mlservics.weight.other.Gravity;
import com.immomo.mmpaas.code.interfaces.ICode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Generator
implements ICode {
    private static final String MAX_WIDTH = "max_width";
    private static final String MAX_HEIGHT = "max_height";
    private static final String MIN_WIDTH = "min_width";
    private static final String MIN_HEIGHT = "min_height";
    private static final String MARGIN_LEFT = "margin_left";
    private static final String MARGIN_RIGHT = "margin_right";
    private static final String MARGIN_TOP = "margin_top";
    private static final String MARGIN_BOTTOM = "margin_bottom";
    private static final String PADDING_RIGHT = "padding_right";
    private static final String PADDING_LEFT = "padding_left";
    private static final String PADDING_BOTTOM = "padding_bottom";
    private static final String PADDING_TOP = "padding_top";
    private static final String BORDER_WIDTH = "border_width";
    private static final String ALPHA = "alpha";
    private static final String PRIORITY = "priority";
    private static final String MARGIN = "margin";
    private static final String CORNER_RADIUS_TOP_LEFT = "corner_radius_top_left";
    private static final String CORNER_RADIUS_TOP_RIGHT = "corner_radius_top_right";
    private static final String CORNER_RADIUS_BOTTOM_LEFT = "corner_radius_bottom_left";
    private static final String CORNER_RADIUS_BOTTOM_RIGHT = "corner_radius_bottom_right";
    private static final String CORNER_RADIUS = "corner_radius";
    private static final String CORNER_MASK_TOP_LEFT = "corner_mask_top_left";
    private static final String CORNER_MASK_TOP_RIGHT = "corner_mask_top_right";
    private static final String CORNER_MASK_BOTTOM_LEFT = "corner_mask_bottom_left";
    private static final String CORNER_MASK_BOTTOM_RIGHT = "corner_mask_bottom_right";
    private static final String CORNER_MASK = "corner_mask";
    private static final String CORNER_MASK_COLOR = "corner_mask_color";
    private static final String GONE = "gone";
    private static final String HIDDEN = "hidden";
    private static final String SHADOW_X = "shadow_x";
    private static final String SHADOW_Y = "shadow_y";
    private static final String SHADOW_RADIUS = "shadow_radius";
    private static final String SHADOW_ALPHA = "shadow_alpha";
    private static final String OVERLAY = "overlay";
    public LinkedHashMap codeMap = new LinkedHashMap();

    @Override
    public void addWidth(double width) {
        if (this.codeMap == null) {
            return;
        }
        if (width == -1.0) {
            this.codeMap.put("width", "MeasurementType.MATCH_PARENT");
        } else if (width == -2.0) {
            this.codeMap.put("width", "MeasurementType.WRAP_CONTENT");
        } else {
            this.codeMap.put("width", String.valueOf(width));
        }
    }

    @Override
    public void addHeight(double height) {
        if (this.codeMap == null) {
            return;
        }
        if (height == -1.0) {
            this.codeMap.put("height", "MeasurementType.MATCH_PARENT");
        } else if (height == -2.0) {
            this.codeMap.put("height", "MeasurementType.WRAP_CONTENT");
        } else {
            this.codeMap.put("height", String.valueOf(height));
        }
    }

    @Override
    public void addMaxWidth(double maxWidth) {
        if (this.codeMap == null) {
            return;
        }
        if (maxWidth == 0.0) {
            this.codeMap.remove(MAX_WIDTH);
        } else {
            this.codeMap.put(MAX_WIDTH, String.valueOf(maxWidth));
        }
    }

    @Override
    public void addMaxHeight(double maxHeight) {
        if (this.codeMap == null) {
            return;
        }
        if (maxHeight == 0.0) {
            this.codeMap.remove(MAX_HEIGHT);
        } else {
            this.codeMap.put(MAX_HEIGHT, String.valueOf(maxHeight));
        }
    }

    @Override
    public void addMinWidth(double minWidth) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put(MIN_WIDTH, String.valueOf(minWidth));
    }

    @Override
    public void addMinHeight(double minHeight) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put(MIN_HEIGHT, String.valueOf(minHeight));
    }

    @Override
    public void addMarginLeft(double marginLeft) {
        if (this.codeMap == null) {
            return;
        }
        this.separateMargin();
        if (marginLeft == 0.0) {
            this.codeMap.remove(MARGIN_LEFT);
        } else {
            this.codeMap.put(MARGIN_LEFT, String.valueOf(marginLeft));
        }
        this.comMargin();
    }

    @Override
    public void addMarginRight(double marginRight) {
        if (this.codeMap == null) {
            return;
        }
        this.separateMargin();
        if (marginRight == 0.0) {
            this.codeMap.remove(MARGIN_RIGHT);
        } else {
            this.codeMap.put(MARGIN_RIGHT, String.valueOf(marginRight));
        }
        this.comMargin();
    }

    @Override
    public void addMarginTop(double marginTop) {
        if (this.codeMap == null) {
            return;
        }
        this.separateMargin();
        if (marginTop == 0.0) {
            this.codeMap.remove(MARGIN_TOP);
        } else {
            this.codeMap.put(MARGIN_TOP, String.valueOf(marginTop));
        }
        this.comMargin();
    }

    @Override
    public void addMarginBottom(double marginBottom) {
        if (this.codeMap == null) {
            return;
        }
        this.separateMargin();
        if (marginBottom == 0.0) {
            this.codeMap.remove(MARGIN_BOTTOM);
        } else {
            this.codeMap.put(MARGIN_BOTTOM, String.valueOf(marginBottom));
        }
        this.comMargin();
    }

    private void comMargin() {
        String left;
        String top = this.codeMap.get(MARGIN_TOP) != null ? (String)this.codeMap.get(MARGIN_TOP) : "0";
        String bottom = this.codeMap.get(MARGIN_BOTTOM) != null ? (String)this.codeMap.get(MARGIN_BOTTOM) : "0";
        String right = this.codeMap.get(MARGIN_RIGHT) != null ? (String)this.codeMap.get(MARGIN_RIGHT) : "0";
        String string = left = this.codeMap.get(MARGIN_LEFT) != null ? (String)this.codeMap.get(MARGIN_LEFT) : "0";
        if (top.equals(bottom) && right.equals(left) && top.equals(right)) {
            this.codeMap.remove(MARGIN_TOP);
            this.codeMap.remove(MARGIN_BOTTOM);
            this.codeMap.remove(MARGIN_RIGHT);
            this.codeMap.remove(MARGIN_LEFT);
            this.codeMap.put(MARGIN, top);
        }
    }

    private void separateMargin() {
        if (this.codeMap.containsKey(MARGIN)) {
            String value = (String)this.codeMap.get(MARGIN);
            this.codeMap.put(MARGIN_TOP, value);
            this.codeMap.put(MARGIN_BOTTOM, value);
            this.codeMap.put(MARGIN_LEFT, value);
            this.codeMap.put(MARGIN_RIGHT, value);
            this.codeMap.remove(MARGIN);
        }
    }

    @Override
    public void addGravity(int gravity) {
        if (this.codeMap == null) {
            return;
        }
        ArrayList<String> gravityStr = new ArrayList<String>();
        int absoluteGravity = Gravity.getAbsoluteGravity(gravity, 0);
        int verticalGravity = gravity & 0x70;
        switch (absoluteGravity & 7) {
            case 1: {
                gravityStr.add("Gravity.CENTER_HORIZONTAL");
                break;
            }
            case 5: {
                gravityStr.add("Gravity.RIGHT");
                break;
            }
            case 3: {
                gravityStr.add("Gravity.LEFT");
            }
        }
        switch (verticalGravity) {
            case 80: {
                gravityStr.add("Gravity.BOTTOM");
                break;
            }
            case 16: {
                gravityStr.add("Gravity.CENTER_VERTICAL");
                break;
            }
            case 48: {
                gravityStr.add("Gravity.TOP");
            }
        }
        if (gravityStr.size() > 1) {
            this.codeMap.put("gravity", String.format("MBit:bor(%s,%s)", gravityStr.get(0), gravityStr.get(1)));
        } else {
            this.codeMap.put("gravity", gravityStr.get(0));
        }
    }

    @Override
    public void addPadding(double left, double top, double right, double bottom) {
        if (this.codeMap == null) {
            return;
        }
        if (left == top && right == bottom && left == right && left > 0.0) {
            this.codeMap.remove(PADDING_RIGHT);
            this.codeMap.remove(PADDING_LEFT);
            this.codeMap.remove(PADDING_BOTTOM);
            this.codeMap.remove(PADDING_TOP);
            this.codeMap.put("padding", String.valueOf(left));
        } else {
            if (left == 0.0) {
                this.codeMap.remove(PADDING_LEFT);
            } else {
                this.codeMap.put(PADDING_LEFT, String.valueOf(left));
            }
            if (right == 0.0) {
                this.codeMap.remove(PADDING_RIGHT);
            } else {
                this.codeMap.put(PADDING_RIGHT, String.valueOf(right));
            }
            if (top == 0.0) {
                this.codeMap.remove(PADDING_TOP);
            } else {
                this.codeMap.put(PADDING_TOP, String.valueOf(top));
            }
            if (bottom > 0.0) {
                this.codeMap.remove(PADDING_BOTTOM);
            } else {
                this.codeMap.put(PADDING_BOTTOM, String.valueOf(bottom));
            }
        }
    }

    @Override
    public void addBorderWidth(double width) {
        if (this.codeMap == null) {
            return;
        }
        if (width == 0.0) {
            this.codeMap.remove(BORDER_WIDTH);
        } else {
            this.codeMap.put(BORDER_WIDTH, String.valueOf(width));
        }
    }

    @Override
    public void addBorderColor(Color color) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("border_color", "'" + ColorUtils.hex(color) + "'");
    }

    @Override
    public void addVisibility(int visibility) {
        switch (visibility) {
            case 2: {
                this.codeMap.put(GONE, "true");
                break;
            }
            case 0: {
                this.codeMap.remove(GONE);
                this.codeMap.remove(HIDDEN);
                break;
            }
            case 1: {
                this.codeMap.put(HIDDEN, "true");
            }
        }
    }

    @Override
    public void addBgColor(Color color) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("background", "'" + ColorUtils.hex(color) + "'");
    }

    @Override
    public void addBgImage(String icon) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("background", "'" + icon + "'");
    }

    @Override
    public void addAlpha(float alpha) {
        if (this.codeMap == null) {
            return;
        }
        if (alpha == 1.0f) {
            this.codeMap.remove(ALPHA);
        } else {
            this.codeMap.put(ALPHA, String.valueOf(alpha));
        }
    }

    @Override
    public void addPriority(int priority) {
        if (this.codeMap == null) {
            return;
        }
        if (priority == 0) {
            this.codeMap.remove(PRIORITY);
        } else {
            this.codeMap.put(PRIORITY, String.valueOf(priority));
        }
    }

    @Override
    public void addWeight(int weight) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("weight", String.valueOf(weight));
    }

    @Override
    public void addCornerMask(double r, Color color, int rectCorner) {
        if (this.codeMap == null) {
            return;
        }
        if (color == null) {
            this.codeMap.remove(CORNER_MASK_COLOR);
        } else {
            this.codeMap.put(CORNER_MASK_COLOR, "'" + ColorUtils.hex(color) + "'");
        }
        this.removeCornerRadius();
        this.separateMaskRadius();
        switch (rectCorner) {
            case 15: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_MASK);
                    break;
                }
                this.codeMap.put(CORNER_MASK, r);
                break;
            }
            case 1: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_MASK_TOP_LEFT);
                    break;
                }
                this.codeMap.put(CORNER_MASK_TOP_LEFT, String.valueOf(r));
                break;
            }
            case 2: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_MASK_TOP_RIGHT);
                    break;
                }
                this.codeMap.put(CORNER_MASK_TOP_RIGHT, String.valueOf(r));
                break;
            }
            case 8: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_MASK_BOTTOM_RIGHT);
                    break;
                }
                this.codeMap.put(CORNER_MASK_BOTTOM_RIGHT, String.valueOf(r));
                break;
            }
            case 4: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_MASK_BOTTOM_LEFT);
                    break;
                }
                this.codeMap.put(CORNER_MASK_BOTTOM_LEFT, String.valueOf(r));
            }
        }
        this.comMaskRadius();
    }

    @Override
    public void addCornerMaskColor(Color color) {
        this.removeCornerRadius();
        if (color == null) {
            this.codeMap.remove(CORNER_MASK_COLOR);
        } else {
            this.codeMap.put(CORNER_MASK_COLOR, "'" + ColorUtils.hex(color) + "'");
        }
    }

    @Override
    public void addShadow(double x, double y, double radius, float alpha) {
        if (this.codeMap == null) {
            return;
        }
        if (x == 0.0) {
            this.codeMap.remove(SHADOW_X);
        } else {
            this.codeMap.put(SHADOW_X, String.valueOf(x));
        }
        if (y == 0.0) {
            this.codeMap.remove(SHADOW_Y);
        } else {
            this.codeMap.put(SHADOW_Y, String.valueOf(y));
        }
        if (radius == 0.0) {
            this.codeMap.remove(SHADOW_RADIUS);
        } else {
            this.codeMap.put(SHADOW_RADIUS, String.valueOf(radius));
        }
        if (alpha == 1.0f) {
            this.codeMap.remove(SHADOW_ALPHA);
        } else {
            this.codeMap.put(SHADOW_ALPHA, String.valueOf(alpha));
        }
    }

    @Override
    public void addOverlay(UDBaseView overlay) {
        if (this.codeMap == null) {
            return;
        }
    }

    private void separateMaskRadius() {
        if (this.codeMap.containsKey(CORNER_MASK)) {
            String value = (String)this.codeMap.get(CORNER_MASK);
            this.codeMap.put(CORNER_MASK_TOP_LEFT, value);
            this.codeMap.put(CORNER_MASK_TOP_RIGHT, value);
            this.codeMap.put(CORNER_MASK_BOTTOM_RIGHT, value);
            this.codeMap.put(CORNER_MASK_BOTTOM_LEFT, value);
            this.codeMap.remove(CORNER_MASK);
        }
    }

    private void removeMaskRadius() {
        this.codeMap.remove(CORNER_MASK_TOP_LEFT);
        this.codeMap.remove(CORNER_MASK_TOP_RIGHT);
        this.codeMap.remove(CORNER_MASK_BOTTOM_RIGHT);
        this.codeMap.remove(CORNER_MASK_BOTTOM_LEFT);
        this.codeMap.remove(CORNER_MASK);
    }

    private void comMaskRadius() {
        String bottom_left;
        if (this.codeMap == null) {
            return;
        }
        String top_left = this.codeMap.get(CORNER_MASK_TOP_LEFT) != null ? (String)this.codeMap.get(CORNER_MASK_TOP_LEFT) : "0";
        String top_right = this.codeMap.get(CORNER_MASK_TOP_RIGHT) != null ? (String)this.codeMap.get(CORNER_MASK_TOP_RIGHT) : "0";
        String bottom_right = this.codeMap.get(CORNER_MASK_BOTTOM_RIGHT) != null ? (String)this.codeMap.get(CORNER_MASK_BOTTOM_RIGHT) : "0";
        String string = bottom_left = this.codeMap.get(CORNER_MASK_BOTTOM_LEFT) != null ? (String)this.codeMap.get(CORNER_MASK_BOTTOM_LEFT) : "0";
        if (top_left.equals(top_right) && bottom_right.equals(bottom_left) && top_left.equals(bottom_right) && Double.parseDouble(top_left) > 0.0) {
            this.removeMaskRadius();
            this.codeMap.put(CORNER_MASK, top_left);
        }
    }

    @Override
    public void addCornerRadiusWithDirection(double r, int rectCorner) {
        if (this.codeMap == null) {
            return;
        }
        this.removeMaskRadius();
        this.codeMap.remove(CORNER_MASK_COLOR);
        this.separateCornerRadius();
        switch (rectCorner) {
            case 15: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_RADIUS);
                    break;
                }
                this.codeMap.put(CORNER_RADIUS, r);
                break;
            }
            case 1: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_RADIUS_TOP_LEFT);
                    break;
                }
                this.codeMap.put(CORNER_RADIUS_TOP_LEFT, String.valueOf(r));
                break;
            }
            case 2: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_RADIUS_TOP_RIGHT);
                    break;
                }
                this.codeMap.put(CORNER_RADIUS_TOP_RIGHT, String.valueOf(r));
                break;
            }
            case 8: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_RADIUS_BOTTOM_RIGHT);
                    break;
                }
                this.codeMap.put(CORNER_RADIUS_BOTTOM_RIGHT, String.valueOf(r));
                break;
            }
            case 4: {
                if (r == 0.0) {
                    this.codeMap.remove(CORNER_RADIUS_BOTTOM_LEFT);
                    break;
                }
                this.codeMap.put(CORNER_RADIUS_BOTTOM_LEFT, String.valueOf(r));
            }
        }
        this.comCornerRadius();
    }

    private void removeCornerRadius() {
        this.codeMap.remove(CORNER_RADIUS);
        this.codeMap.remove(CORNER_RADIUS_BOTTOM_LEFT);
        this.codeMap.remove(CORNER_RADIUS_BOTTOM_RIGHT);
        this.codeMap.remove(CORNER_RADIUS_TOP_RIGHT);
        this.codeMap.remove(CORNER_RADIUS_TOP_LEFT);
    }

    private void comCornerRadius() {
        String bottom_left;
        if (this.codeMap == null) {
            return;
        }
        String top_left = this.codeMap.get(CORNER_RADIUS_TOP_LEFT) != null ? (String)this.codeMap.get(CORNER_RADIUS_TOP_LEFT) : "0";
        String top_right = this.codeMap.get(CORNER_RADIUS_TOP_RIGHT) != null ? (String)this.codeMap.get(CORNER_RADIUS_TOP_RIGHT) : "0";
        String bottom_right = this.codeMap.get(CORNER_RADIUS_BOTTOM_RIGHT) != null ? (String)this.codeMap.get(CORNER_RADIUS_BOTTOM_RIGHT) : "0";
        String string = bottom_left = this.codeMap.get(CORNER_RADIUS_BOTTOM_LEFT) != null ? (String)this.codeMap.get(CORNER_RADIUS_BOTTOM_LEFT) : "0";
        if (top_left.equals(top_right) && bottom_right.equals(bottom_left) && top_left.equals(bottom_right) && Double.parseDouble(top_left) > 0.0) {
            this.removeCornerRadius();
            this.codeMap.put(CORNER_RADIUS, top_left);
        }
    }

    private void separateCornerRadius() {
        if (this.codeMap.containsKey(CORNER_RADIUS)) {
            String value = (String)this.codeMap.get(CORNER_RADIUS);
            this.codeMap.remove(CORNER_RADIUS);
            this.codeMap.put(CORNER_RADIUS_TOP_LEFT, value);
            this.codeMap.put(CORNER_RADIUS_TOP_RIGHT, value);
            this.codeMap.put(CORNER_RADIUS_BOTTOM_RIGHT, value);
            this.codeMap.put(CORNER_RADIUS_BOTTOM_LEFT, value);
        }
    }

    @Override
    public void addGradientColorWithDirection(Color s, Color e, int type2) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("gradient_color_start", "'" + ColorUtils.hex(s) + "'");
        this.codeMap.put("gradient_color_end", "'" + ColorUtils.hex(e) + "'");
        switch (type2) {
            case 3: {
                this.codeMap.put("gradient_color_direction", "GradientType.TOP_TO_BOTTOM");
                break;
            }
            case 1: {
                this.codeMap.put("gradient_color_direction", "GradientType.LEFT_TO_RIGHT");
                break;
            }
            case 2: {
                this.codeMap.put("gradient_color_direction", "GradientType.RIGHT_TO_LEFT");
                break;
            }
            case 4: {
                this.codeMap.put("gradient_color_direction", "GradientType.BOTTOM_TO_TOP");
            }
        }
    }
}

