/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.code.generator;

import com.immomo.mlservics.utils.ColorUtils;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.interfaces.IEditViewCode;
import java.awt.Color;

public class EditViewGenerator
extends Generator
implements IEditViewCode {
    private static final String SINGLE_LINE = "singleline";
    private static final String PLACE_HOLDER = "placeholder";
    private static final String PASSWORD_MODE = "password_mode";
    private static final String INPUT_MODE = "input_mode";
    private static final String CAN_EDIT = "can_edit";
    private static final String FONT_SIZE = "font_size";

    public EditViewGenerator() {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("view", "EditTextView()");
    }

    @Override
    public void addSingleLine(boolean singleLine) {
        if (this.codeMap == null) {
            return;
        }
        if (!singleLine) {
            this.codeMap.remove(SINGLE_LINE);
        } else {
            this.codeMap.put(SINGLE_LINE, String.valueOf(singleLine));
        }
    }

    @Override
    public void addPlaceholder(String placeholder) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put(PLACE_HOLDER, "'" + placeholder + "'");
    }

    @Override
    public void addPlaceholderColor(Color color) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("placeholder_color", "'" + ColorUtils.hex(color) + "'");
    }

    @Override
    public void addPasswordMode(Boolean isPassword) {
        if (this.codeMap == null) {
            return;
        }
        if (!isPassword.booleanValue()) {
            this.codeMap.remove(PASSWORD_MODE);
        } else {
            this.codeMap.put(PASSWORD_MODE, "'" + isPassword + "'");
        }
    }

    @Override
    public void addMaxBytes(int maxBytes) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("max_bytes", String.valueOf(maxBytes));
    }

    @Override
    public void addMaxLength(int maxLength) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("max_lengths", String.valueOf(maxLength));
    }

    @Override
    public void addText(String text) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("text", "'" + text + "'");
    }

    @Override
    public void addInputMode(int inputMode) {
        if (this.codeMap == null) {
            return;
        }
        switch (inputMode) {
            case 1: {
                this.codeMap.remove(INPUT_MODE);
                break;
            }
            case 2: {
                this.codeMap.put(INPUT_MODE, "EditTextViewInputMode.Number");
            }
        }
    }

    @Override
    public void addFontColor(Color color) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("text_color", "'" + ColorUtils.hex(color) + "'");
    }

    @Override
    public void addFontSize(int size) {
        if (this.codeMap == null) {
            return;
        }
        if (size == 16) {
            this.codeMap.remove(FONT_SIZE);
        } else {
            this.codeMap.put(FONT_SIZE, String.valueOf(size));
        }
    }

    @Override
    public void addEditEnable(boolean enable) {
        if (this.codeMap == null) {
            return;
        }
        if (enable) {
            this.codeMap.remove(CAN_EDIT);
        } else {
            this.codeMap.put(CAN_EDIT, String.valueOf(enable));
        }
    }

    @Override
    public void addCursorColor(Color cursorColor) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("cursor_color", "'" + ColorUtils.hex(cursorColor) + "'");
    }
}

