/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.code;

import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.code.bean.CodeBean;
import com.immomo.mmpaas.panel.message.Message;
import com.immomo.mmpaas.table.LuaParser;
import com.immomo.mmpaas.table.LuaTable;
import com.immomo.mmpaas.table.LuaValue;
import com.immomo.mmpaas.utils.FileUtil;
import com.immomo.mmpaas.utils.Log;
import com.immomo.mmpaas.utils.ThreadUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerator {
    private static volatile CodeGenerator mInstance;
    public static final String LINE_BREAK = "\n";
    public static final String TABLE_BREAK = "\t";
    private LuaTable mLuaTable;
    private ArrayList<CodeBean> codeBeanList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CodeGenerator getInstance() {
        if (mInstance != null) return mInstance;
        Class<CodeGenerator> clazz = CodeGenerator.class;
        synchronized (CodeGenerator.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(String path, Container container) {
        ThreadUtils.execute(() -> {
            try {
                this.mLuaTable = this.parseLuaTable(path);
                this.codeBeanList = new ArrayList();
                this.appendToTable(this.mLuaTable, 0, 0);
                this.transformViewMap(container);
            }
            catch (Exception e) {
                e.printStackTrace();
                Message.printError("\u4ee3\u7801\u9519\u8bef");
            }
        });
    }

    private void appendToTable(LuaTable value, int breadth, int depth) {
        CodeBean temCodeBean = new CodeBean();
        this.codeBeanList.add(temCodeBean);
        for (Map.Entry<LuaValue, LuaValue> entry : value.entrySet()) {
            LuaTable t;
            temCodeBean.depth = breadth;
            temCodeBean.breadth = depth;
            LuaValue k = entry.getKey();
            LuaValue v = entry.getValue();
            if (k.isNumber() && v.isTable()) {
                t = (LuaTable)v;
                this.appendToTable(t, breadth + 1, depth);
                continue;
            }
            if (k.isString() && v.isTable()) {
                t = (LuaTable)v;
                this.appendToTable(t, breadth, depth + 1);
                continue;
            }
            temCodeBean.parameters.put(k.getValue().toString(), v.getValue().toString());
        }
        if (temCodeBean.parameters.size() == 0) {
            this.codeBeanList.remove(temCodeBean);
        }
    }

    private void transformViewMap(Container container) {
        for (Component component : container.getComponents()) {
            if (!(component instanceof LuaWindow)) continue;
            this.transformMap((Container)component);
        }
    }

    private void transformMap(Container container) {
        if (this.codeBeanList == null || this.codeBeanList.size() == 0) {
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponents()[i];
            ((IView)((Object)component)).getViewWrapper().getGenerator().codeMap = this.codeBeanList.get((int)0).parameters;
            this.codeBeanList.remove(0);
            if (!(component instanceof ViewGroup)) continue;
            this.transformMap((Container)component);
        }
    }

    private LuaTable parseLuaTable(String path) {
        File file = new File(path);
        if (!file.isFile()) {
            Log.e(path + "is no file", new Object[0]);
            return new LuaTable();
        }
        byte[] data = FileUtil.readBytes(file);
        if (data == null || data.length == 0) {
            Log.e(path + "file is empty", new Object[0]);
            return new LuaTable();
        }
        String s = new String(data);
        return LuaParser.parse(s.toCharArray());
    }

    public void changeCodeFile(Container container, String file) {
        ThreadUtils.execute(() -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("return ");
            this.transformCode(container, stringBuilder, 0);
            FileUtil.save(file, stringBuilder.toString().getBytes());
        });
    }

    public void changeCodeFileByPlugin(Container container, VirtualFile virtualFile) {
        if (virtualFile == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("return ");
        this.transformCode(container, stringBuilder, 0);
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                document.setText((CharSequence)stringBuilder.toString());
            }
        });
    }

    private void transformCode(Container container, StringBuilder builder, int num) {
        if (container == null) {
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponents()[i];
            if (component instanceof ViewGroup) {
                builder.append(this.addTabCode("{", num));
                builder.append(this.addViewCode(((IView)((Object)component)).getViewWrapper().getGenerator().codeMap, ++num));
                if (((Container)component).getComponentCount() > 0) {
                    builder.append(this.addTabCode("subs = {", num));
                    this.transformCode((Container)component, builder, num + 1);
                    builder.append(this.addTabCode("}", num));
                }
                --num;
                if (i == container.getComponentCount() - 1) {
                    builder.append(this.addTabCode("}", num));
                    continue;
                }
                builder.append(this.addTabCode("},", num));
                continue;
            }
            if (!(component instanceof IView)) continue;
            builder.append(this.addTabCode("{", num));
            builder.append(this.addViewCode(((IView)((Object)component)).getViewWrapper().getGenerator().codeMap, num + 1));
            if (i == container.getComponentCount() - 1) {
                builder.append(this.addTabCode("}", num));
                continue;
            }
            builder.append(this.addTabCode("},", num));
        }
    }

    public String addViewCode(HashMap<String, String> map, int tabNum) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : map.keySet()) {
            for (int i = 0; i < tabNum; ++i) {
                stringBuilder.append(TABLE_BREAK);
            }
            stringBuilder.append(key).append(" = ").append(map.get(key)).append(",\n");
        }
        return stringBuilder.toString();
    }

    private String addTabCode(String content, int tabNum) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < tabNum; ++i) {
            stringBuilder.append(TABLE_BREAK);
        }
        stringBuilder.append(content).append(LINE_BREAK);
        return stringBuilder.toString();
    }
}

