/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.base.broadcast;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class BroadCastManager {
    private static volatile BroadCastManager manager;
    private final Map<String, List<ReceiverCacheBean>> receivers = new HashMap<String, List<ReceiverCacheBean>>();

    private BroadCastManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BroadCastManager getManager() {
        if (manager != null) return manager;
        Class<BroadCastManager> clazz = BroadCastManager.class;
        synchronized (BroadCastManager.class) {
            if (manager != null) return manager;
            manager = new BroadCastManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public synchronized void send(Context c, BroadCastMessage msg) {
        List<ReceiverCacheBean> r = this.receivers.get(msg.key);
        if (r == null || r.isEmpty()) {
            return;
        }
        ArrayList<ReceiverCacheBean> temp = new ArrayList<ReceiverCacheBean>(r);
        for (ReceiverCacheBean br : temp) {
            if (br.context != c && c != Application.getApplicationContext() || !br.receiver.onReceive(c, msg)) continue;
            return;
        }
    }

    public void sendAsync(Context c, BroadCastMessage msg) {
        SwingUtilities.invokeLater(() -> this.send(c, msg));
    }

    public synchronized void registerReceiver(Context c, String key, BroadCastReceiver receiver) {
        if (receiver == null) {
            return;
        }
        List list = this.receivers.computeIfAbsent(key, k -> new ArrayList());
        list.add(new ReceiverCacheBean(c, receiver));
    }

    public synchronized void unregisterReceiver(String key, BroadCastReceiver receiver) {
        if (receiver == null) {
            return;
        }
        List<ReceiverCacheBean> list = this.receivers.get(key);
        if (list == null) {
            return;
        }
        ReceiverCacheBean bean = this.getReceiverBean(list, receiver);
        if (bean != null) {
            list.remove(bean);
        }
        if (list.isEmpty()) {
            this.receivers.remove(key);
        }
    }

    private ReceiverCacheBean getReceiverBean(List<ReceiverCacheBean> list, BroadCastReceiver receiver) {
        for (ReceiverCacheBean bean : list) {
            if (bean.receiver != receiver) continue;
            return bean;
        }
        return null;
    }

    private static class ReceiverCacheBean {
        Context context;
        BroadCastReceiver receiver;

        public ReceiverCacheBean(Context context2, BroadCastReceiver receiver) {
            this.context = context2;
            this.receiver = receiver;
        }
    }
}

