/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas;

import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.IPanel;
import com.immomo.mmpaas.base.IPanelContainer;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.sun.istack.internal.NotNull;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class ContextImpl
implements Context,
IPanelContainer {
    private final Container root;
    private final BroadCastManager broadCastManager;
    @NotNull
    private Theme theme;
    private ArrayList<IPanel> panels;

    ContextImpl(Container root) {
        this.root = root;
        this.broadCastManager = BroadCastManager.getManager();
        this.theme = Theme.dark;
        this.panels = new ArrayList(1);
    }

    @Override
    public Container getRoot() {
        return this.root;
    }

    @Override
    public void setTheme(Theme theme) {
        if (theme == null || this.theme.equals(theme) || this.root == null) {
            return;
        }
        this.theme = theme;
        Runnable task = () -> {
            for (IPanel panel : this.panels) {
                this.updatePanelBackground(panel);
            }
            this.root.repaint();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    private void updatePanelBackground(IPanel panel) {
        if (panel instanceof IPanelContainer) {
            IPanelContainer container = (IPanelContainer)((Object)panel);
            for (IPanel c : container.getChildren()) {
                this.updatePanelBackground(c);
            }
        }
        panel.getComponent().setBackground(this.theme.panelBackground);
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int getWidth() {
        return this.root == null ? 0 : this.root.getWidth();
    }

    @Override
    public int getHeight() {
        return this.root == null ? 0 : this.root.getHeight();
    }

    @Override
    public void register(Class<? extends IPanel> clz) {
        if (this.root == null) {
            return;
        }
        Runnable task = () -> {
            try {
                Constructor con = clz.getConstructor(Context.class);
                IPanel panel = (IPanel)con.newInstance(this);
                this.panels.add(panel);
                JComponent component = panel.getComponent();
                ((Component)component).setPreferredSize(new Dimension(panel.getWidth(), panel.getHeight()));
                component.setLocation(panel.getX(), panel.getY());
                ((Component)component).setVisible(panel.visible());
                ((Component)component).setBackground(this.theme.panelBackground);
                this.updatePanelBackground(panel);
                this.root.add(component);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    @Override
    public void updatePanel(IPanel panel) {
        Runnable task = () -> {
            JComponent component = panel.getComponent();
            ((Component)component).setVisible(panel.visible());
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    @Override
    public void sendBroadCastMessage(BroadCastMessage msg) {
        this.broadCastManager.send(this, msg);
    }

    @Override
    public void sendBroadCastMessageAsync(BroadCastMessage msg) {
        this.broadCastManager.sendAsync(this, msg);
    }

    @Override
    public void registerReceiver(Context c, String key, BroadCastReceiver receiver) {
        this.broadCastManager.registerReceiver(c, key, receiver);
    }

    @Override
    public void unregisterReceiver(String key, BroadCastReceiver receiver) {
        this.broadCastManager.unregisterReceiver(key, receiver);
    }

    @Override
    public List<IPanel> getChildren() {
        return this.panels;
    }
}

