/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class RoundClipHelper {
    static final int LEN = 4;
    private static final float PERCENT = 0.08f;
    private static final float C_PERCENTER = 0.45f;
    private static final boolean USE_CURVE = true;

    public static void clip(Graphics g, float[] radius, int width, int height) {
        RoundClipHelper.assetNull(g);
        RoundClipHelper.assetNull(radius);
        RoundClipHelper.checkRadius(radius);
        Path2D.Float clipPath = new Path2D.Float();
        RoundClipHelper.initPath(clipPath, radius, width, height);
        clipPath.closePath();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).clip(clipPath);
        } else {
            g.setClip(clipPath);
        }
    }

    static void initPath(Path2D path, float[] radius, int width, int height) {
        float maxR = (float)Math.min(width, height) / 2.0f;
        for (int i = 0; i < 4; ++i) {
            float r = Math.min(radius[i], maxR);
            RoundClipHelper.addRoundCornerCurve(path, i, width, height, r);
        }
    }

    public static void clipByCurve(Graphics g, float[] radius, int width, int height) {
        RoundClipHelper.assetNull(g);
        RoundClipHelper.assetNull(radius);
        RoundClipHelper.checkRadius(radius);
        Path2D.Float clipPath = new Path2D.Float();
        float maxR = (float)Math.min(width, height) / 2.0f;
        for (int i = 0; i < 4; ++i) {
            float r = Math.min(radius[i], maxR);
            RoundClipHelper.addRoundCornerCurve(clipPath, i, width, height, r);
        }
        clipPath.closePath();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).clip(clipPath);
        } else {
            g.setClip(clipPath);
        }
    }

    private static void addRoundCorner(Path2D clipPath, int i, int width, int height, float r) {
        float x = RoundClipHelper.getX(i, width);
        float y = RoundClipHelper.getY(i, height);
        if (r <= 0.0f) {
            if (i == 0) {
                clipPath.moveTo(x, y);
            } else {
                clipPath.lineTo(x, y);
            }
            return;
        }
        float sx = RoundClipHelper.getStartX(i, width, r);
        float sy = RoundClipHelper.getStartY(i, height, r);
        if (i == 0) {
            clipPath.moveTo(sx, sy);
        } else {
            clipPath.lineTo(sx, sy);
        }
        float p = r * 0.08f;
        switch (i) {
            case 0: {
                x += p;
                y += p;
                break;
            }
            case 1: {
                x -= p;
                y += p;
                break;
            }
            case 2: {
                x -= p;
                y -= p;
                break;
            }
            default: {
                x += p;
                y -= p;
            }
        }
        clipPath.quadTo(x, y, RoundClipHelper.getEndX(i, width, r), RoundClipHelper.getEndY(i, height, r));
    }

    private static void addRoundCornerCurve(Path2D clipPath, int i, int width, int height, float r) {
        float x = RoundClipHelper.getX(i, width);
        float y = RoundClipHelper.getY(i, height);
        if (r <= 0.0f) {
            if (i == 0) {
                clipPath.moveTo(x, y);
            } else {
                clipPath.lineTo(x, y);
            }
            return;
        }
        float sx = RoundClipHelper.getStartX(i, width, r);
        float sy = RoundClipHelper.getStartY(i, height, r);
        if (i == 0) {
            clipPath.moveTo(sx, sy);
        } else {
            clipPath.lineTo(sx, sy);
        }
        float ex = RoundClipHelper.getEndX(i, width, r);
        float ey = RoundClipHelper.getEndY(i, height, r);
        RoundClipHelper.addArc(clipPath, i, x, y, ex, ey, r);
    }

    public static void addArc(Path2D path, int i, float x, float y, float ex, float ey, float r) {
        float y2;
        float x2;
        float y1;
        float x1;
        float p = r * 0.45f;
        switch (i) {
            case 0: {
                x1 = x;
                y1 = y + p;
                x2 = x + p;
                y2 = y;
                break;
            }
            case 1: {
                x1 = x - p;
                y1 = y;
                x2 = x;
                y2 = y + p;
                break;
            }
            case 2: {
                x1 = x;
                y1 = y - p;
                x2 = x - p;
                y2 = y;
                break;
            }
            default: {
                x1 = x + p;
                y1 = y;
                x2 = x;
                y2 = y - p;
            }
        }
        path.curveTo(x1, y1, x2, y2, ex, ey);
    }

    private static float getStartX(int index, int w, float r) {
        switch (index) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return (float)w - r;
            }
            case 2: {
                return w;
            }
        }
        return r;
    }

    private static float getStartY(int index, int h, float r) {
        switch (index) {
            case 0: {
                return r;
            }
            case 1: {
                return 0.0f;
            }
            case 2: {
                return (float)h - r;
            }
        }
        return h;
    }

    private static float getEndX(int index, float w, float r) {
        switch (index) {
            case 0: {
                return r;
            }
            case 1: {
                return w;
            }
            case 2: {
                return w - r;
            }
        }
        return 0.0f;
    }

    private static float getEndY(int index, float h, float r) {
        switch (index) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return r;
            }
            case 2: {
                return h;
            }
        }
        return h - r;
    }

    private static float getCenterX(int index, int w, float r) {
        switch (index) {
            case 0: 
            case 3: {
                return r;
            }
        }
        return (float)w - r;
    }

    private static float getCenterY(int index, int h, float r) {
        switch (index) {
            case 0: 
            case 1: {
                return r;
            }
        }
        return (float)h - r;
    }

    private static double getStartAngle(int index) {
        return 90 - index * 90;
    }

    private static float getX(int index, float w) {
        switch (index) {
            case 0: 
            case 3: {
                return 0.0f;
            }
        }
        return w;
    }

    private static float getY(int index, float h) {
        switch (index) {
            case 0: 
            case 1: {
                return 0.0f;
            }
        }
        return h;
    }

    private static void checkRadius(float[] radius) {
        if (radius.length != 4) {
            throw new IllegalArgumentException("radius must contain 4 number, for TOP-LEFT, TOP-RIGHT, BOTTOM-RIGHT, BOTTOM-LEFT radius");
        }
    }

    private static void assetNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }
}

