/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class NativeBlur {
    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h) {
        if (w == 0 || h == 0) {
            return null;
        }
        int[] pixels = new int[w * h];
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    public static native int[] blur(int[] var0, int var1, int var2, int var3);
}

