/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import com.immomo.mlservics.weight.other.MeasureSpec;

public class MeasureUtil {
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
                break;
            }
            default: {
                result = size;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public static int getMeasuredState(int measuredWidth, int measuredHeight) {
        return measuredWidth & 0xFF000000 | measuredHeight >> 16 & 0xFFFFFF00;
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int getRootMeasureSpec(int windowSize, int rootDimension) {
        int measureSpec;
        switch (rootDimension) {
            case -1: {
                measureSpec = MeasureSpec.makeMeasureSpec(windowSize, 0x40000000);
                break;
            }
            case -2: {
                measureSpec = MeasureSpec.makeMeasureSpec(windowSize, Integer.MIN_VALUE);
                break;
            }
            default: {
                measureSpec = MeasureSpec.makeMeasureSpec(rootDimension, 0x40000000);
            }
        }
        return measureSpec;
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specMode = MeasureSpec.getMode(spec);
        int specSize = MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (specMode) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
            }
        }
        return MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }
}

