/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class DrawImageHelper {
    private static final boolean DEBUG = false;

    public static boolean draw(Graphics g, Image image, int mode, int x, int y, int containerWidth, int containerHeight, ImageObserver observer) {
        int sy2;
        int sx2;
        int dy2;
        int dx2;
        int dy1;
        int dx1;
        int sx1;
        int sy1;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth < 0 || imageHeight < 0) {
            return false;
        }
        float imageScale = (float)imageWidth / (float)imageHeight;
        float containerScale = (float)containerWidth / (float)containerHeight;
        if (mode == -1) {
            sy1 = 0;
            sx1 = 0;
            dx1 = x;
            dy1 = y;
            dx2 = containerWidth;
            dy2 = containerHeight;
            sx2 = imageWidth;
            sy2 = imageHeight;
        } else if (mode == 0) {
            sy1 = 0;
            sx1 = 0;
            sx2 = imageWidth;
            sy2 = imageHeight;
            if (imageScale > containerScale) {
                dx1 = x;
                dx2 = containerWidth + x;
                float useHeight = (float)containerWidth / imageScale;
                dy1 = (int)((float)containerHeight - useHeight) / 2 + y;
                dy2 = (int)((float)containerHeight + useHeight) / 2 + y;
            } else {
                dy1 = y;
                dy2 = containerHeight + y;
                float useWidth = imageScale * (float)containerHeight;
                dx1 = (int)((float)containerWidth - useWidth) / 2 + x;
                dx2 = (int)((float)containerWidth + useWidth) / 2 + x;
            }
        } else {
            dx1 = x;
            dy1 = y;
            dx2 = containerWidth + x;
            dy2 = containerHeight + y;
            if (imageScale > containerScale) {
                sy1 = 0;
                sy2 = imageHeight;
                sx1 = imageWidth - containerWidth >> 1;
                sx2 = imageWidth + containerWidth >> 1;
            } else {
                sx1 = 0;
                sx2 = imageWidth;
                float rh = (float)imageWidth / containerScale;
                sy1 = (int)(((float)imageHeight - rh) / 2.0f);
                sy2 = (int)(((float)imageHeight + rh) / 2.0f);
            }
        }
        return g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }
}

