/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import com.immomo.mlservics.weight.utils.RoundClipHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class DrawBorderHelper {
    private static final float[] EMPTY_R = new float[4];
    private float[] radius;
    private Color color;
    private int size;

    public void setRadius(float[] radius) {
        this.radius = radius;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBorderWidth(int size) {
        this.size = size;
    }

    public void draw(Graphics g, Component c) {
        if (this.color != null) {
            DrawBorderHelper.draw(g, c.getWidth(), c.getHeight(), this.radius == null ? EMPTY_R : this.radius, this.color, this.size);
        }
    }

    public Color getBorderColor() {
        return this.color;
    }

    public int getBorderWidth() {
        return this.size;
    }

    public static void draw(Graphics g, int w, int h, float[] radius, Color color, int size) {
        DrawBorderHelper.assetNull(g);
        DrawBorderHelper.assetNull(radius);
        DrawBorderHelper.checkRadius(radius);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Path2D.Float clipPath = new Path2D.Float();
        RoundClipHelper.initPath(clipPath, radius, w, h);
        clipPath.closePath();
        g2d.setStroke(new BasicStroke(size));
        g2d.setColor(color);
        g2d.draw(clipPath);
    }

    private static void checkRadius(float[] radius) {
        if (radius.length != 4) {
            throw new IllegalArgumentException("radius must contain 4 number, for TOP-LEFT, TOP-RIGHT, BOTTOM-RIGHT, BOTTOM-LEFT radius");
        }
    }

    private static void assetNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }
}

