/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.utils;

import com.immomo.mlservics.weight.utils.NativeBlur;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BlurUtils {
    public static Image blurImage(Image i, int radius) {
        if (radius <= 0) {
            return i;
        }
        int w = i.getWidth(null);
        int h = i.getHeight(null);
        if (w <= 0 || h <= 0) {
            return null;
        }
        if (i instanceof BufferedImage) {
            BlurUtils.blurImage((BufferedImage)i, w, h, radius);
            return i;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        if (g.drawImage(i, 0, 0, null)) {
            BlurUtils.blurImage(image, w, h, radius);
            return image;
        }
        return null;
    }

    private static void blurImage(BufferedImage image, int w, int h, int radius) {
        int[] pixels = NativeBlur.getPixels(image, 0, 0, w, h);
        int[] blurPixels = NativeBlur.blur(pixels, w, h, radius);
        NativeBlur.setPixels(image, 0, 0, w, h, blurPixels);
    }
}

