/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.other;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MeasureSpec {
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;

    public static int makeMeasureSpec(int size, int mode) {
        return size & 0x3FFFFFFF | mode & 0xC0000000;
    }

    public static int makeSafeMeasureSpec(int size, int mode) {
        return MeasureSpec.makeMeasureSpec(size, mode);
    }

    public static int getMode(int measureSpec) {
        return measureSpec & 0xC0000000;
    }

    public static int getSize(int measureSpec) {
        return measureSpec & 0x3FFFFFFF;
    }

    static int adjust(int measureSpec, int delta) {
        int mode = MeasureSpec.getMode(measureSpec);
        int size = MeasureSpec.getSize(measureSpec);
        if (mode == 0) {
            return MeasureSpec.makeMeasureSpec(size, 0);
        }
        if ((size += delta) < 0) {
            size = 0;
        }
        return MeasureSpec.makeMeasureSpec(size, mode);
    }

    public static String toString(int measureSpec) {
        int mode = MeasureSpec.getMode(measureSpec);
        int size = MeasureSpec.getSize(measureSpec);
        StringBuilder sb = new StringBuilder("MeasureSpec: ");
        if (mode == 0) {
            sb.append("UNSPECIFIED ");
        } else if (mode == 0x40000000) {
            sb.append("EXACTLY ");
        } else if (mode == Integer.MIN_VALUE) {
            sb.append("AT_MOST ");
        } else {
            sb.append(mode).append(" ");
        }
        sb.append(size);
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasureSpecMode {
    }
}

