/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.newUI;

import com.immomo.mlservics.weight.FrameLayout;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.other.Gravity;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.generator.ZtackGenerator;
import com.immomo.mmpaas.code.interfaces.IZStackCode;
import java.awt.Component;

public class ZStack
extends FrameLayout {
    private int mGravity = 0x800033;

    public ZStack() {
        this.init();
    }

    private void init() {
    }

    @Override
    public String getLuaClassName() {
        return "ZStack";
    }

    @Override
    public Generator createGenerator() {
        return new ZtackGenerator();
    }

    @Override
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if (this.generator instanceof IZStackCode) {
                ((IZStackCode)((Object)this.generator)).addChildGravity(gravity);
            }
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @Override
    protected void onLayout() {
        this.layoutChildren(0, 0, this.getWidth(), this.getHeight(), false);
    }

    void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getComponentCount();
        int parentLeft = this.getPaddingLeft();
        int parentRight = right - left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            int childTop;
            Component childComponent = this.getComponent(i);
            IView child = (IView)((Object)childComponent);
            if (child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childLeft = 0;
            int gravity = lp.gravity;
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, 0);
            int verticalGravity = gravity & 0x70;
            int stackAbsoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, 0);
            int stackVerticalGravity = this.mGravity & 0x70;
            block0 : switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    if (!forceLeftGravity) {
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                }
                case 3: {
                    childLeft = parentLeft + lp.leftMargin;
                }
                default: {
                    switch (stackAbsoluteGravity & 7) {
                        case 1: {
                            childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                            break block0;
                        }
                        case 5: {
                            if (!forceLeftGravity) {
                                childLeft = parentRight - width - lp.rightMargin;
                                break block0;
                            }
                        }
                        case 3: {
                            childLeft = parentLeft + lp.leftMargin;
                        }
                    }
                }
            }
            block10 : switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    switch (stackVerticalGravity) {
                        case 48: {
                            childTop = parentTop + lp.topMargin;
                            break block10;
                        }
                        case 16: {
                            childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                            break block10;
                        }
                        case 80: {
                            childTop = parentBottom - height - lp.bottomMargin;
                            break block10;
                        }
                    }
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }
}

