/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.newUI;

import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.ISpacer;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.other.Gravity;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.MeasureUtil;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.generator.HVStackGenerator;
import com.immomo.mmpaas.code.interfaces.IHVStackCode;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;

public abstract class BaseRowColumn
extends ViewGroup {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation = 0;
    private Component[] children;
    private int childCount = 0;
    private int crossAxisAlignment = 1;
    private int mainAxisAlignment = 1;
    private int mUsedLenght;

    @Override
    public Generator createGenerator() {
        return new HVStackGenerator(this.mOrientation);
    }

    public int getCrossAxisAlignment() {
        return this.crossAxisAlignment;
    }

    public void setCrossAxisAlignment(int crossAxisAlignment) {
        this.crossAxisAlignment = crossAxisAlignment;
        if (this.generator instanceof IHVStackCode) {
            ((IHVStackCode)((Object)this.generator)).addcrossAxisAlignment(crossAxisAlignment);
        }
    }

    public int getMainAxisAlignment() {
        return this.mainAxisAlignment;
    }

    public void setMainAxisAlignment(int mainAxisAlignment) {
        this.mainAxisAlignment = mainAxisAlignment;
        if (this.generator instanceof IHVStackCode) {
            ((IHVStackCode)((Object)this.generator)).addMainAxisAlignment(mainAxisAlignment);
        }
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.reAddByPriority();
        widthMeasureSpec = this.getSpec(widthMeasureSpec, this.getMaxWidth());
        heightMeasureSpec = this.getSpec(heightMeasureSpec, this.getMaxHeight());
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int mh;
        this.mUsedLenght = 0;
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        int mPaddingTop = this.getPaddingTop();
        int mPaddingBottom = this.getPaddingBottom();
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int maxWidth = 0;
        int childState = 0;
        boolean matchWidth = false;
        int totalWeight = 0;
        int weightViewLen = 0;
        int nonWeightViewHeight = 0;
        int count = this.childCount;
        for (int i = 0; i < count; ++i) {
            IView child = (IView)((Object)this.getPriorityChildAt(i));
            if (child == null || child.getVisibility() == 2 || child instanceof ISpacer && ((ISpacer)((Object)child)).isVerExpand()) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, this.mUsedLenght);
            int childHeight = child.getMeasuredHeight();
            this.mUsedLenght = Math.max(this.mUsedLenght, childHeight + this.mUsedLenght + lp.topMargin + lp.bottomMargin);
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = MeasureUtil.combineMeasuredStates(childState, MeasureUtil.getMeasuredState(child.getMeasuredWidth(), child.getMeasuredHeight()));
            nonWeightViewHeight += lp.topMargin + lp.bottomMargin;
            if (lp.weight > 0 && lp.height < 0) {
                totalWeight += lp.weight;
                ++weightViewLen;
            } else {
                nonWeightViewHeight += childHeight;
            }
            matchWidth = matchWidth || widthMode != 0x40000000 && lp.width == -1;
        }
        this.mUsedLenght += mPaddingTop + mPaddingBottom;
        this.mUsedLenght = Math.max(this.mUsedLenght, this.getSuggestedMinimumHeight());
        int maxChildWidth = maxWidth;
        maxWidth += mPaddingLeft + mPaddingRight;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        int measuredHeight = MeasureUtil.resolveSizeAndState(this.mUsedLenght, heightMeasureSpec, 0);
        this.setMeasuredDimension(MeasureUtil.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), measuredHeight);
        if (weightViewLen > 0 && (mh = this.getMeasuredHeight() - nonWeightViewHeight - mPaddingTop - mPaddingBottom) > 0) {
            float piece = (float)mh / (float)totalWeight;
            for (int i = 0; i < count; ++i) {
                IView child = (IView)((Object)this.getPriorityChildAt(i));
                if (child == null || child.getVisibility() == 2) continue;
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.weight <= 0 || lp.height >= 0) continue;
                int h = (int)(piece * (float)lp.weight);
                h = Math.max(h, child.getMinHeight());
                h = Math.min(h, child.getMaxHeight());
                child.measure(MeasureUtil.getChildMeasureSpec(widthMeasureSpec, mPaddingLeft + mPaddingRight + lp.leftMargin + lp.rightMargin, lp.width), MeasureSpec.makeMeasureSpec(h, 0x40000000));
                maxChildWidth = Math.max(maxChildWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            }
            this.setMeasuredDimension(MeasureUtil.resolveSizeAndState(maxChildWidth += mPaddingLeft + mPaddingRight, widthMeasureSpec, 0), measuredHeight);
        }
        if (matchWidth) {
            this.forceUniformWidth(this.childCount, heightMeasureSpec);
        }
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            IView child = (IView)((Object)this.getPriorityChildAt(i));
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int mw;
        this.mUsedLenght = 0;
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int mPaddingTop = this.getPaddingTop();
        int mPaddingBottom = this.getPaddingBottom();
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int maxHeight = 0;
        int childState = 0;
        boolean matchHeight = false;
        int totalWeight = 0;
        int weightViewLen = 0;
        int nonWeightViewWidth = 0;
        int count = this.childCount;
        for (int i = 0; i < count; ++i) {
            IView child = (IView)((Object)this.getPriorityChildAt(i));
            if (child == null || child.getVisibility() == 2 || child instanceof ISpacer && ((ISpacer)((Object)child)).isHorExpand()) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            this.measureChildBeforeLayout(child, i, widthMeasureSpec, this.mUsedLenght, heightMeasureSpec, 0);
            int childWidth = child.getMeasuredWidth();
            this.mUsedLenght = Math.max(this.mUsedLenght, childWidth + this.mUsedLenght + lp.leftMargin + lp.rightMargin);
            int margin = lp.topMargin + lp.bottomMargin;
            int measuredHeight = child.getMeasuredHeight() + margin;
            maxHeight = Math.max(maxHeight, measuredHeight);
            childState = MeasureUtil.combineMeasuredStates(childState, MeasureUtil.combineMeasuredStates(childState, MeasureUtil.getMeasuredState(child.getMeasuredWidth(), child.getMeasuredHeight())));
            nonWeightViewWidth += lp.leftMargin + lp.rightMargin;
            if (lp.weight > 0 && lp.width < 0) {
                totalWeight += lp.weight;
                ++weightViewLen;
            } else {
                nonWeightViewWidth += childWidth;
            }
            matchHeight = matchHeight || heightMode != 0x40000000 && lp.height == -1;
        }
        this.mUsedLenght += mPaddingLeft + mPaddingRight;
        this.mUsedLenght = Math.max(this.mUsedLenght, this.getSuggestedMinimumWidth());
        int maxChildHeight = maxHeight;
        maxHeight += mPaddingTop + mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        int measuredWidth = MeasureUtil.resolveSizeAndState(this.mUsedLenght, widthMeasureSpec, 0);
        this.setMeasuredDimension(measuredWidth, MeasureUtil.resolveSizeAndState(maxHeight, heightMeasureSpec, childState));
        if (weightViewLen > 0 && (mw = this.getMeasuredWidth() - nonWeightViewWidth - mPaddingLeft - mPaddingRight) > 0) {
            float piece = (float)mw / (float)totalWeight;
            for (int i = 0; i < count; ++i) {
                IView child = (IView)((Object)this.getPriorityChildAt(i));
                if (child == null || child.getVisibility() == 2) continue;
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.weight <= 0 || lp.width >= 0) continue;
                int w = (int)(piece * (float)lp.weight);
                w = Math.max(w, child.getMinWidth());
                w = Math.min(w, child.getMaxWidth());
                child.measure(MeasureSpec.makeMeasureSpec(w, 0x40000000), MeasureUtil.getChildMeasureSpec(heightMeasureSpec, mPaddingTop + mPaddingBottom + lp.topMargin + lp.bottomMargin, lp.height));
                maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            this.setMeasuredDimension(measuredWidth, MeasureUtil.resolveSizeAndState(maxChildHeight += mPaddingTop + mPaddingBottom, heightMeasureSpec, 0));
        }
        if (matchHeight) {
            this.forceUniformHeight(this.childCount, widthMeasureSpec);
        }
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            IView child = (IView)((Object)this.getPriorityChildAt(i));
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    void measureChildBeforeLayout(IView child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private int getSpec(int src, int max2) {
        int mode = MeasureSpec.getMode(src);
        if (mode == 0x40000000) {
            return src;
        }
        int size = MeasureSpec.getSize(src);
        if (size > max2) {
            return MeasureSpec.makeMeasureSpec(max2, mode);
        }
        return src;
    }

    @Override
    protected void onLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mOrientation == 1) {
            this.layoutVertical(0, 0, width, height);
        } else {
            this.layoutHorizontal(0, 0, width, height);
        }
    }

    void layoutVertical(int left, int top, int right, int bottom) {
        int minorGravity;
        int childTop;
        int paddingLeft = this.getPaddingLeft();
        int mPaddingTop = this.getPaddingTop();
        int mPaddingRight = this.getPaddingRight();
        int usedHeight = mPaddingTop;
        boolean useSpace = false;
        int expandSpacerCount = 0;
        int width = right - left;
        int childRight = width - mPaddingRight;
        int childSpace = width - paddingLeft - mPaddingRight;
        int count = this.getComponentCount();
        switch (this.mainAxisAlignment) {
            case 3: {
                childTop = mPaddingTop + bottom - top - this.mUsedLenght;
                break;
            }
            case 2: {
                childTop = mPaddingTop + (bottom - top - this.mUsedLenght) / 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                childTop = mPaddingTop;
                useSpace = true;
                break;
            }
            default: {
                childTop = mPaddingTop;
            }
        }
        switch (this.crossAxisAlignment) {
            case 3: {
                minorGravity = 5;
                break;
            }
            case 2: {
                minorGravity = 1;
                break;
            }
            default: {
                minorGravity = 3;
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            IView child = (IView)((Object)this.getComponents()[i]);
            if (child instanceof ISpacer && ((ISpacer)((Object)child)).isVerExpand()) {
                ++expandSpacerCount;
                continue;
            }
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, 0);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            this.setChildFrame(child, childLeft, childTop += lp.topMargin, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
            usedHeight += lp.topMargin + childHeight + lp.bottomMargin;
        }
        if (!useSpace && expandSpacerCount == 0 || count <= 0) {
            return;
        }
        int measuredHeight = this.getMeasuredHeight();
        int totalSpace = measuredHeight - usedHeight;
        if (totalSpace > 0) {
            childTop = mPaddingTop;
            if (expandSpacerCount > 0) {
                this.layoutVerSpacer(childTop, totalSpace, expandSpacerCount, count);
            } else {
                this.layoutVerSpaceType(childTop, totalSpace, count);
            }
        }
    }

    private void layoutVerSpacer(int childTop, int totalSpace, int expandSpacerCount, int count) {
        int spacerHeight = totalSpace / expandSpacerCount;
        for (int i = 0; i < count; ++i) {
            Component childComponent = this.getComponents()[i];
            IView child = (IView)((Object)childComponent);
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            childTop += lp.topMargin;
            if (child instanceof ISpacer && ((ISpacer)((Object)child)).isVerExpand()) {
                childHeight = spacerHeight;
            }
            this.setChildFrame(child, childComponent.getX(), childTop, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    private void layoutVerSpaceType(int childTop, int totalSpace, int count) {
        int edgeSpace = 0;
        int betweenSpace = 0;
        switch (this.mainAxisAlignment) {
            case 4: {
                if (count <= 1) break;
                betweenSpace = totalSpace / (count - 1);
                break;
            }
            case 5: {
                if (count > 1) {
                    betweenSpace = totalSpace / count;
                    edgeSpace = betweenSpace / 2;
                    break;
                }
                edgeSpace = totalSpace / 2;
                break;
            }
            case 6: {
                edgeSpace = betweenSpace = totalSpace / (count + 1);
            }
        }
        for (int i = 0; i < count; ++i) {
            Component childComponent = this.getComponents()[i];
            IView child = (IView)((Object)childComponent);
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            childTop = i == 0 ? (childTop += lp.topMargin + edgeSpace) : (childTop += lp.topMargin + betweenSpace);
            this.setChildFrame(child, childComponent.getX(), childTop, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    void layoutHorizontal(int left, int top, int right, int bottom) {
        int minorGravity;
        int childLeft;
        int mPaddingLeft;
        int mPaddingBottom = this.getPaddingBottom();
        int paddingTop = this.getPaddingTop();
        int usedWidth = mPaddingLeft = this.getPaddingLeft();
        boolean useSpace = false;
        int expandSpacerCount = 0;
        int height = bottom - top;
        int childBottom = height - mPaddingBottom;
        int childSpace = height - paddingTop - mPaddingBottom;
        switch (this.mainAxisAlignment) {
            case 3: {
                childLeft = mPaddingLeft + right - left - this.mUsedLenght;
                break;
            }
            case 2: {
                childLeft = mPaddingLeft + (right - left - this.mUsedLenght) / 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                childLeft = mPaddingLeft;
                useSpace = true;
                break;
            }
            default: {
                childLeft = mPaddingLeft;
            }
        }
        switch (this.crossAxisAlignment) {
            case 3: {
                minorGravity = 80;
                break;
            }
            case 2: {
                minorGravity = 16;
                break;
            }
            default: {
                minorGravity = 48;
            }
        }
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int childTop;
            Component childComponent = this.getComponents()[i];
            IView child = (IView)((Object)childComponent);
            if (child instanceof ISpacer && ((ISpacer)((Object)child)).isHorExpand()) {
                ++expandSpacerCount;
                continue;
            }
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            this.setChildFrame(child, childLeft += lp.leftMargin, childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin;
            usedWidth += lp.leftMargin + childWidth + lp.rightMargin;
        }
        if (!useSpace && expandSpacerCount == 0 || count <= 0) {
            return;
        }
        int measuredWidth = this.getMeasuredWidth();
        int totalSpace = measuredWidth - usedWidth;
        if (totalSpace > 0) {
            childLeft = mPaddingLeft;
            if (expandSpacerCount > 0) {
                this.layoutHorSpacer(childLeft, totalSpace, expandSpacerCount, count);
            } else {
                this.layoutHorSpaceType(childLeft, totalSpace, count);
            }
        }
    }

    private void layoutHorSpacer(int childLeft, int totalSpace, int expandSpacerCount, int count) {
        int spacerWidth = totalSpace / expandSpacerCount;
        for (int i = 0; i < count; ++i) {
            Component childComponent = this.getComponents()[i];
            IView child = (IView)((Object)childComponent);
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            childLeft += lp.leftMargin;
            if (child instanceof ISpacer && ((ISpacer)((Object)child)).isHorExpand()) {
                childWidth = spacerWidth;
            }
            this.setChildFrame(child, childLeft, childComponent.getY(), childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    private void layoutHorSpaceType(int childLeft, int totalSpace, int count) {
        int edgeSpace = 0;
        int betweenSpace = 0;
        switch (this.mainAxisAlignment) {
            case 4: {
                if (count <= 1) break;
                betweenSpace = totalSpace / (count - 1);
                break;
            }
            case 5: {
                if (count > 1) {
                    betweenSpace = totalSpace / count;
                    edgeSpace = betweenSpace / 2;
                    break;
                }
                edgeSpace = totalSpace / 2;
                break;
            }
            case 6: {
                edgeSpace = betweenSpace = totalSpace / (count + 1);
            }
        }
        for (int i = 0; i < count; ++i) {
            Component childComponent = this.getComponents()[i];
            IView child = (IView)((Object)childComponent);
            if (child == null || child.getVisibility() == 2) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            childLeft = i == 0 ? (childLeft += lp.leftMargin + edgeSpace) : (childLeft += lp.leftMargin + betweenSpace);
            this.setChildFrame(child, childLeft, childComponent.getY(), childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    private void setChildFrame(IView child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public void reAddByPriority() {
        this.children = this.getComponents();
        this.childCount = this.getComponentCount();
        Arrays.sort(this.children, Comparator.comparingInt(o -> -((IView)((Object)o)).getLayoutParams().priority));
    }

    protected Component getPriorityChildAt(int index) {
        return this.childCount > index ? this.children[index] : null;
    }
}

