/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.collectionView;

import com.immomo.mlservics.Environment;
import com.immomo.mlservics.ud.UDSize;
import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.weight.other.Size;
import org.luaj.vm2.JavaUserdata;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

public class UDCollectionViewGridLayout
extends JavaUserdata {
    public static final String LUA_CLASS_NAME = "CollectionViewGridLayout";
    public static final String[] methods = new String[]{"lineSpacing", "itemSpacing", "spanCount", "layoutInset", "itemSize"};
    public static final int DEFAULT_SPAN_COUNT = 1;
    protected double lineSpacing = 0.0;
    protected double itemSpacing = 0.0;
    private final int[] paddingValues = new int[4];
    private UDSize itemSize;
    protected int orientation = 1;
    private int width;
    private int height;
    private int spanCount;

    @LuaApiUsed
    public UDCollectionViewGridLayout(long L, LuaValue[] v) {
        super(L, v);
    }

    @LuaApiUsed
    public LuaValue[] spanCount(LuaValue[] values) {
        if (values != null && values.length > 0) {
            this.spanCount = values[0].toInt();
            return null;
        }
        if (this.spanCount <= 0) {
            this.spanCount = 1;
        }
        return LuaValue.rNumber(this.spanCount);
    }

    public int getSpanCount() {
        if (this.spanCount > 0) {
            return this.spanCount;
        }
        this.initSpanCount();
        return this.spanCount;
    }

    private void initSpanCount() {
        if (this.orientation == 1) {
            this.spanCount = this.getSpanCountForWidth();
        }
        if (this.spanCount <= 0) {
            this.spanCount = 1;
            IllegalArgumentException e = new IllegalArgumentException("spanCount must > 0");
            if (!Environment.hook(e, this.getGlobals())) {
                throw e;
            }
        }
    }

    private int getSpanCountForWidth() {
        int w = (int)this.itemSize.getWidthPx();
        int screenW = this.width == 0 ? this.getScreenWidth() : this.width;
        int spanCount = (int)((double)screenW - this.itemSpacing) / w;
        return this.recalculateSpanCount(spanCount, w, screenW, (int)this.itemSpacing);
    }

    private int recalculateSpanCount(int spanCount, int itemWidth, int screenWidth, int itemSpacing) {
        if (itemSpacing == 0) {
            return spanCount;
        }
        while (spanCount * (itemWidth + itemSpacing) > screenWidth - itemSpacing) {
            --spanCount;
        }
        return spanCount;
    }

    private int getScreenWidth() {
        return 428;
    }

    @LuaApiUsed
    public LuaValue[] lineSpacing(LuaValue[] values) {
        if (values.length > 0) {
            this.lineSpacing = DimenUtil.dpiToPx(values[0].toDouble());
            return null;
        }
        return UDCollectionViewGridLayout.varargsOf(LuaNumber.valueOf(this.lineSpacing));
    }

    @LuaApiUsed
    public LuaValue[] itemSpacing(LuaValue[] values) {
        if (values.length > 0) {
            this.itemSpacing = DimenUtil.dpiToPx(values[0].toDouble());
            return null;
        }
        return UDCollectionViewGridLayout.varargsOf(LuaNumber.valueOf(this.itemSpacing));
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public double getItemSpacing() {
        return this.itemSpacing;
    }

    @LuaApiUsed
    public LuaValue[] layoutInset(LuaValue[] values) {
        this.paddingValues[0] = (int)values[1].toDouble();
        this.paddingValues[1] = (int)values[0].toDouble();
        this.paddingValues[2] = (int)values[3].toDouble();
        this.paddingValues[3] = (int)values[2].toDouble();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] itemSize(LuaValue[] values) {
        LuaValue value = values[0];
        if (value != null) {
            if (this.itemSize != null) {
                this.itemSize.onJavaRecycle();
            }
            this.itemSize = (UDSize)value.toUserdata();
            this.itemSize.onJavaRef();
            return null;
        }
        return UDCollectionViewGridLayout.varargsOf(this.itemSize);
    }

    public Size getItemSize() {
        return this.itemSize != null ? this.itemSize.getSize() : null;
    }

    public int getInsetLeft() {
        return this.paddingValues[0];
    }

    public int getInsetTop() {
        return this.paddingValues[1];
    }

    public int getInsetRight() {
        return this.paddingValues[2];
    }

    public int getInsetBottom() {
        return this.paddingValues[3];
    }
}

