/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.collectionView;

import com.immomo.mlservics.Environment;
import com.immomo.mlservics.ErrorUtils;
import com.immomo.mlservics.ud.UDSize;
import com.immomo.mlservics.ud.view.UDViewGroup;
import com.immomo.mlservics.ud.view.listview.IDGenerator;
import com.immomo.mlservics.utils.AssertUtils;
import com.immomo.mlservics.weight.View;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.collectionView.UDCollectionViewCell;
import com.immomo.mlservics.weight.collectionView.UDCollectionViewGridLayout;
import com.immomo.mlservics.weight.other.Size;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jf.util.SparseArray;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

public class UDCollectionViewAdapter
extends UDViewGroup {
    public static final String LUA_CLASS_NAME = "CollectionViewAdapter";
    public static final String[] methods = new String[]{"reuseId", "initCell", "fillCellData", "initCellByReuseId", "fillCellDataByReuseId", "sectionCount", "rowCount", "sizeForCell", "sizeForCellByReuseId"};
    private SparseArray<Size> sizeCache;
    private Map<String, LuaFunction> cellSizeDelegates;
    private LuaFunction cellSizeDelegate;
    private LuaFunction reuseIdDelegate;
    private LuaFunction initCellDelegate;
    private Map<String, LuaFunction> typeCellDelegate;
    private LuaFunction bindDataDelegate;
    private Map<String, LuaFunction> bindTypeDataDelegate;
    private LuaFunction sectionCountDelegate;
    private LuaFunction rowCountDelegate;
    private int count;
    private SparseArray<String> reuseIdCache;
    private int[] sections;
    private AtomicInteger allCount;
    private IDGenerator idGenerator = new IDGenerator();
    private UDCollectionViewGridLayout layout;

    protected UDCollectionViewAdapter(long L, LuaValue[] v) {
        super(L, v);
    }

    public final LuaValue[] initCell(LuaValue[] values) {
        this.initCellDelegate = values[0].toLuaFunction();
        return null;
    }

    public LuaValue[] fillCellData(LuaValue[] values) {
        this.bindDataDelegate = values[0].toLuaFunction();
        return null;
    }

    public LuaValue[] rowCount(LuaValue[] values) {
        this.rowCountDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] reuseId(LuaValue[] values) {
        this.reuseIdDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] initCellByReuseId(LuaValue[] values) {
        if (this.typeCellDelegate == null) {
            this.typeCellDelegate = new HashMap<String, LuaFunction>();
        }
        this.typeCellDelegate.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    @LuaApiUsed
    public LuaValue[] fillCellDataByReuseId(LuaValue[] values) {
        if (this.bindTypeDataDelegate == null) {
            this.bindTypeDataDelegate = new HashMap<String, LuaFunction>();
        }
        this.bindTypeDataDelegate.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    @LuaApiUsed
    public LuaValue[] sectionCount(LuaValue[] values) {
        this.sectionCountDelegate = values[0].toLuaFunction();
        return null;
    }

    public int getCellViewHeight() {
        return this.layout.getItemSize().getHeightPx();
    }

    @LuaApiUsed
    public LuaValue[] sizeForCell(LuaValue[] values) {
        this.cellSizeDelegate = values.length > 0 ? values[0].toLuaFunction() : null;
        return null;
    }

    @LuaApiUsed
    public LuaValue[] sizeForCellByReuseId(LuaValue[] values) {
        if (this.cellSizeDelegates == null) {
            this.cellSizeDelegates = new HashMap<String, LuaFunction>();
        }
        this.cellSizeDelegates.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    protected String getReuseId(int position) {
        String id;
        if (this.reuseIdCache != null && (id = (String)this.reuseIdCache.get(position)) != null) {
            return id;
        }
        if (this.reuseIdDelegate != null && !this.reuseIdDelegate.isNil()) {
            IllegalArgumentException e;
            int[] sr = this.getSectionAndRowIn(position);
            if (sr == null) {
                return null;
            }
            LuaValue[] lr = this.reuseIdDelegate.invoke(UDCollectionViewAdapter.varargsOf(UDCollectionViewAdapter.toLuaInt(sr[0]), UDCollectionViewAdapter.toLuaInt(sr[1])));
            LuaValue v = lr != null && lr.length > 0 ? lr[0] : UDCollectionViewAdapter.Nil();
            String result = AssertUtils.assertString(v, this.reuseIdDelegate, this.getGlobals()) ? v.toJavaString() : v.toString();
            if (StringUtils.isEmpty(result) && !Environment.hook(e = new IllegalArgumentException("reuseId  can`t be \u201d\u201c"), this.getGlobals())) {
                throw e;
            }
            if (this.reuseIdCache == null) {
                this.reuseIdCache = new SparseArray();
            }
            this.reuseIdCache.put(position, (Object)result);
            return result;
        }
        return null;
    }

    protected int[] getSectionAndRowIn(int pos) {
        if (this.sections == null) {
            return null;
        }
        int sc = this.sections.length;
        for (int i = 0; i < sc; i += 2) {
            int offset = pos - this.sections[i];
            if (offset < 0 || pos >= this.sections[i + 1]) continue;
            return new int[]{i >> 1, offset};
        }
        return null;
    }

    public int getViewType(int position) {
        String id = this.getReuseId(position);
        return this.idGenerator.getViewTypeForReuseId(id);
    }

    public String getReuseIdByType(int type2) {
        return this.idGenerator.getReuseIdByType(type2);
    }

    private void initSection() {
        if (this.allCount == null) {
            this.allCount = new AtomicInteger();
        }
        this.allCount.set(-1);
        this.sections = this.getSectionInfo(this.allCount);
    }

    private int[] getSectionInfo(AtomicInteger allCountOut) {
        if (this.rowCountDelegate == null || this.rowCountDelegate.isNil()) {
            return null;
        }
        int sectionCount = 0;
        if (this.sectionCountDelegate != null && this.sectionCountDelegate.isFunction()) {
            LuaValue sv = this.sectionCountDelegate.invoke(null)[0];
            if (AssertUtils.assertNumber(sv, this.sectionCountDelegate, this.getGlobals())) {
                sectionCount = sv.toInt();
            }
        } else {
            sectionCount = 1;
        }
        if (sectionCount <= 0) {
            IllegalArgumentException e;
            if (Application.DEBUG && !Environment.hook(e = new IllegalArgumentException("section count must bigger than 0, return " + sectionCount), this.getGlobals())) {
                throw e;
            }
            sectionCount = 1;
        }
        int resultCount = sectionCount << 1;
        int[] result = new int[resultCount];
        int allCount = 0;
        for (int i = 0; i < resultCount; i += 2) {
            LuaValue rc = this.rowCountDelegate.invoke(UDCollectionViewAdapter.varargsOf(UDCollectionViewAdapter.toLuaInt(i >> 1)))[0];
            result[i] = allCount;
            if (AssertUtils.assertNumber(rc, this.rowCountDelegate, this.getGlobals())) {
                allCount += rc.toInt();
            }
            result[i + 1] = allCount;
        }
        if (allCountOut != null) {
            allCountOut.set(allCount);
        }
        return result;
    }

    public void callInitCell(LuaValue cell, int viewType) {
        LuaFunction delegate = null;
        if (this.typeCellDelegate != null) {
            String id = this.getReuseIdByType(viewType);
            delegate = this.typeCellDelegate.get(id);
        }
        if (delegate == null) {
            delegate = this.initCellDelegate;
        }
        if (this.globals.isDestroyed()) {
            return;
        }
        if (!AssertUtils.assertFunction(delegate, "initCell callback must be a function", this.getGlobals())) {
            return;
        }
        delegate.invoke(UDCollectionViewAdapter.varargsOf(cell));
    }

    public void callFillDataCell(LuaValue cell, int position) {
        LuaFunction delegate = null;
        if (this.bindTypeDataDelegate != null) {
            delegate = this.bindTypeDataDelegate.get(this.getReuseId(position));
        }
        if (delegate == null) {
            delegate = this.bindDataDelegate;
        }
        if (delegate != null) {
            int[] sr = this.getSectionAndRowIn(position);
            delegate.invoke(UDCollectionViewAdapter.varargsOf(cell, UDCollectionViewAdapter.toLuaInt(sr[0]), UDCollectionViewAdapter.toLuaInt(sr[1])));
        }
    }

    public View getView(int pos) {
        UDCollectionViewCell collectionViewCell = new UDCollectionViewCell(this.getGlobals(), this);
        View itemView = (View)collectionViewCell.getView();
        this.initSection();
        int viewType = this.getViewType(pos);
        this.callInitCell(collectionViewCell.getCell(), viewType);
        this.initSize(itemView, viewType);
        this.callFillDataCell(collectionViewCell.getCell(), pos);
        return itemView;
    }

    private void initSize(View itemView, int type2) {
        itemView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
    }

    public int getCount() {
        this.count = this.rowCountDelegate.invoke(UDCollectionViewAdapter.varargsOf(UDCollectionViewAdapter.toLuaInt(1)))[0].toInt();
        return this.count;
    }

    protected static LuaValue toLuaInt(int i) {
        return LuaNumber.valueOf(i + 1);
    }

    public boolean hasSizeForCellDelegate() {
        if (this.cellSizeDelegate != null) {
            return true;
        }
        return this.cellSizeDelegates != null && this.cellSizeDelegates.size() > 0;
    }

    public Size getCellSize(int position) {
        int viewType = this.getViewType(position);
        String id = this.getReuseIdByType(viewType);
        return this.getCellSize(position, id);
    }

    public Size getCellSize(int position, String reuseId) {
        LuaValue a1;
        Size cellSize;
        if (this.sizeCache == null) {
            this.sizeCache = new SparseArray();
        }
        if ((cellSize = (Size)this.sizeCache.get(position)) != null) {
            return cellSize;
        }
        int[] sr = this.getSectionAndRowIn(position);
        if (sr == null) {
            return new Size(2.8E-45f, 2.8E-45f);
        }
        LuaValue s = UDCollectionViewAdapter.toLuaInt(sr[0]);
        LuaValue r = UDCollectionViewAdapter.toLuaInt(sr[1]);
        LuaFunction caller = null;
        if (this.cellSizeDelegates != null) {
            caller = this.cellSizeDelegates.get(reuseId);
            if (caller == null || !caller.isFunction()) {
                caller = this.cellSizeDelegate;
            }
        } else if (this.cellSizeDelegate != null) {
            caller = this.cellSizeDelegate;
        }
        if (caller == null || caller.isNil()) {
            if (!AssertUtils.assertNull(this.layout, "must set layout before!", this.getGlobals())) {
                return new Size(2.8E-45f, 2.8E-45f);
            }
            return this.layout.getItemSize();
        }
        LuaValue[] rets = caller.invoke(UDCollectionViewAdapter.varargsOf(s, r));
        LuaValue luaValue = a1 = rets == null || rets.length == 0 ? UDCollectionViewAdapter.Nil() : rets[0];
        if (AssertUtils.assertUserData(a1, UDSize.class, caller, this.getGlobals())) {
            UDSize udSize = (UDSize)a1;
            cellSize = udSize.getSize();
            this.sizeCache.put(position, (Object)cellSize);
            if (cellSize.getHeightPx() <= 0 || cellSize.getWidthPx() <= 0) {
                ErrorUtils.debugLuaError("size For Cell must be >0 and < View.getHeight()", this.getGlobals());
                if (cellSize.getHeightPx() < 0) {
                    cellSize.setHeight(0.0f);
                }
                if (cellSize.getWidthPx() < 0) {
                    cellSize.setWidth(0.0f);
                }
            }
            return cellSize;
        }
        return new Size(2.8E-45f, 2.8E-45f);
    }
}

