/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight.collectionView;

import com.immomo.mlservics.weight.View;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.collectionView.UDCollectionViewAdapter;
import com.immomo.mlservics.weight.collectionView.UDCollectionViewGridLayout;
import com.immomo.mlservics.weight.interfaces.ICollectionView;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.other.Size;
import java.awt.Component;
import java.awt.Dimension;

public class CollectionView
extends ViewGroup
implements ICollectionView,
IView {
    private UDCollectionViewAdapter adapter;
    private int mOrientation;
    private UDCollectionViewGridLayout gridLayout;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public CollectionView() {
        this.setOrientation(1);
    }

    public void setOrientation(int mOrientation) {
        this.mOrientation = mOrientation;
        this.requestLayout();
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void setAdapter(UDCollectionViewAdapter adapter) {
        this.adapter = adapter;
        this.bindData();
    }

    @Override
    public void setLayout(UDCollectionViewGridLayout gridLayout) {
        this.gridLayout = gridLayout;
        this.setPadding(gridLayout.getInsetLeft() + this.getPaddingLeft(), gridLayout.getInsetTop() + this.getPaddingLeft(), gridLayout.getInsetRight() + this.getPaddingLeft(), gridLayout.getInsetBottom() + this.getPaddingLeft());
    }

    @Override
    public String getLuaClassName() {
        return "TableView";
    }

    public void bindData() {
        for (int i = 0; i < this.adapter.getCount(); ++i) {
            View itemView = this.adapter.getView(i);
            this.add(itemView);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object child;
        if (this.adapter.hasSizeForCellDelegate()) {
            int width = MeasureSpec.getSize(widthMeasureSpec);
            int heightUsed = 0;
            int lineMaxHeight = 0;
            int childCount = this.getComponentCount();
            if (childCount <= 0) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            for (int i = 0; i < childCount; ++i) {
                Size cellSize = this.adapter.getCellSize(i);
                int itemWidth = cellSize.getWidthPx();
                int itemHeight = cellSize.getHeightPx();
                Component child2 = this.getComponent(i);
                IView childLayout = (IView)((Object)child2);
                int itemWidthSpec = MeasureSpec.makeMeasureSpec(itemWidth, 0x40000000);
                int itemHeightSpec = MeasureSpec.makeMeasureSpec(itemHeight, 0x40000000);
                childLayout.measure(itemWidthSpec, itemHeightSpec);
                if (i % this.gridLayout.getSpanCount() == 0) {
                    heightUsed += lineMaxHeight;
                    lineMaxHeight = 0;
                }
                lineMaxHeight = Math.max(lineMaxHeight, childLayout.getMeasuredHeight());
            }
            double totalLineSpacing = this.gridLayout.getLineSpacing() * (double)((childCount - 1) / this.gridLayout.getSpanCount());
            this.setMeasuredDimension(width, (int)((double)(heightUsed + lineMaxHeight + this.getPaddingTop() + this.getPaddingBottom()) + totalLineSpacing));
            return;
        }
        if (this.gridLayout.getItemSize() != null) {
            int width = MeasureSpec.getSize(widthMeasureSpec);
            int itemWidth = this.gridLayout.getItemSize().getWidthPx();
            int itemHeight = this.gridLayout.getItemSize().getHeightPx();
            int heightUsed = 0;
            int lineMaxHeight = 0;
            int childCount = this.getComponentCount();
            if (childCount <= 0) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            for (int i = 0; i < childCount; ++i) {
                Component child3 = this.getComponent(i);
                IView childLayout = (IView)((Object)child3);
                int itemWidthSpec = MeasureSpec.makeMeasureSpec(itemWidth, 0x40000000);
                int itemHeightSpec = MeasureSpec.makeMeasureSpec(itemHeight, 0x40000000);
                childLayout.measure(itemWidthSpec, itemHeightSpec);
                if (i % this.gridLayout.getSpanCount() == 0) {
                    heightUsed += lineMaxHeight;
                    lineMaxHeight = 0;
                }
                lineMaxHeight = Math.max(lineMaxHeight, childLayout.getMeasuredHeight());
            }
            double totalLineSpacing = this.gridLayout.getLineSpacing() * (double)((childCount - 1) / this.gridLayout.getSpanCount());
            this.setMeasuredDimension(width, (int)((double)(heightUsed + lineMaxHeight + this.getPaddingTop() + this.getPaddingBottom()) + totalLineSpacing));
            return;
        }
        int width = MeasureSpec.getSize(widthMeasureSpec);
        int itemWidth = (int)((double)(width - this.getPaddingLeft() - this.getPaddingRight()) - this.gridLayout.getItemSpacing() * (double)(this.gridLayout.getSpanCount() - 1)) / this.gridLayout.getSpanCount();
        int childCount = this.getComponentCount();
        if (childCount <= 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            child = this.getComponent(i);
            IView childLayout = (IView)child;
            int itemWidthSpec = MeasureSpec.makeMeasureSpec(itemWidth, 0x40000000);
            childLayout.measure(itemWidthSpec, heightMeasureSpec);
        }
        child = (IView)((Object)this.getComponent(0));
        int height = (int)((double)(child.getMeasuredHeight() * (childCount % this.gridLayout.getSpanCount() == 0 ? childCount / this.gridLayout.getSpanCount() : childCount / this.gridLayout.getSpanCount() + 1)) + this.gridLayout.getLineSpacing() * (double)((childCount - 1) / this.gridLayout.getSpanCount()));
        this.setMeasuredDimension(width, height += this.getPaddingTop() + this.getPaddingBottom());
    }

    @Override
    protected void onLayout() {
        this.layoutComponentsOnVertical(0, this.getComponentCount());
    }

    public void layoutComponentsOnVertical(int rowStart, int rowEnd) {
        int cl = this.getPaddingLeft();
        int ct = this.getPaddingTop();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component child = this.getComponents()[i];
            IView childLayout = (IView)((Object)child);
            if (childLayout.getVisibility() == 2) {
                child.setSize(new Dimension(0, 0));
                continue;
            }
            ViewGroup.LayoutParams childLayoutParams = ((IView)((Object)child)).getLayoutParams();
            int childWidth = childLayout.getMeasuredWidth();
            int childHeight = childLayout.getMeasuredHeight();
            childLayout.layout(cl + childLayoutParams.leftMargin, ct += childLayoutParams.topMargin, childWidth, childHeight);
            cl = (int)((double)cl + ((double)childWidth + this.gridLayout.getItemSpacing()));
            if ((i + 1) % this.gridLayout.getSpanCount() != 0) continue;
            cl = this.getPaddingLeft();
            ct = (int)((double)ct + ((double)childHeight + this.gridLayout.getLineSpacing()));
        }
    }

    private int getSpec(int src, int max2) {
        int mode = MeasureSpec.getMode(src);
        if (mode == 0x40000000) {
            return src;
        }
        int size = MeasureSpec.getSize(src);
        if (size > max2) {
            return MeasureSpec.makeMeasureSpec(max2, mode);
        }
        return src;
    }
}

