/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.constants.GradientType;
import com.immomo.mlservics.constants.GravityConstants;
import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.constants.Visibility;
import com.immomo.mlservics.weight.interfaces.IAlphaView;
import com.immomo.mlservics.weight.interfaces.IBaseView;
import com.immomo.mlservics.weight.interfaces.ILayoutView;
import com.immomo.mlservics.weight.interfaces.ViewParent;
import com.immomo.mlservics.weight.utils.DrawBorderHelper;
import com.immomo.mlservics.weight.utils.RoundClipHelper;
import com.immomo.mlservics.weight.utils.ShadowImageGenerator;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.ComponentDragHelper;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.target.DropTargetHandler;
import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import com.immomo.mmpaas.utils.ImageLoader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ViewWrapper
implements IBaseView,
ViewParent,
IAlphaView,
ILayoutView {
    public static final int DEFAULT_MAX = 0;
    public static final int DEFAULT_MARGIN = 0;
    public static final int DEFAULT_PADDING = 0;
    public static final int DEFAULT_BORDER_WIDTH = 0;
    public static final int DEFAULT_ALPHA = 1;
    private double originWidth;
    private double originHeight;
    private double originMaxWidth;
    private double originMaxHeight;
    private double originMinWidth;
    private double originMinHeight;
    private double originPaddingLeft;
    private double originPaddingRight;
    private double originPaddingBottom;
    private double originPaddingTop;
    private double originMarginLeft;
    private double originMarginRight;
    private double originMarginBottom;
    private double originMarginTop;
    private double originBorderWidth;
    private double originCornerRadius;
    private double originShadowX;
    private double originShadowY;
    private double originShadowRadius;
    private float originShadowAlpha;
    private double[] originMaskRadius = new double[4];
    private Path2D[] maskPath;
    public double[] originRadius;
    public float[] radius = new float[4];
    private JComponent mContainer;
    private ViewGroup.LayoutParams mLayoutParams;
    private Color mBorderColor;
    private int mBorderWidth = 0;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mPaddingTop;
    private int mPaddingBottom;
    private int mVisibility = 0;
    private int mMaxHeight = Integer.MAX_VALUE;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMinHeight;
    private int mMinWidth;
    public int mMeasuredWidth;
    public int mMeasuredHeight;
    private float mAlpha = 1.0f;
    private float paintAlpha = 1.0f;
    private String mImageName;
    private Color mBgColor;
    private Image mBackground;
    private Color startColor;
    private Color endColor;
    private int gradientType = 3;
    private int rectCorner = 15;
    private int maskCorner = 15;
    private Color maskColor;
    private boolean showShadow = false;
    private int shadowX;
    private int shadowY;
    private int shadowRadius;
    private Color shadowColor;
    private Image shadowImage;
    private float shadowAlpha;
    private DrawBorderHelper borderHelper;
    private Generator mGenerator;

    public Generator getGenerator() {
        return this.mGenerator;
    }

    public DrawBorderHelper getBorderHelper() {
        return this.borderHelper;
    }

    public ViewWrapper(JComponent jComponent, Generator generator2) {
        if (generator2 == null) {
            throw new RuntimeException("generator must no null");
        }
        ComponentDragHelper.setDragTarget(jComponent, new DropTargetHandler());
        this.mContainer = jComponent;
        this.borderHelper = new DrawBorderHelper();
        this.mContainer.setOpaque(false);
        this.mLayoutParams = new ViewGroup.LayoutParams(-2, -2);
        this.mGenerator = generator2;
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    @Override
    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    @Override
    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    @Override
    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    @Override
    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams mLayoutParams) {
        this.mLayoutParams = mLayoutParams;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00000\u5bbd\u5ea6", getterNames={"getOriginWidth"})
    public void setWidth(double width) {
        this.originWidth = width;
        this.mLayoutParams.width = DimenUtil.toDevicePx(width);
        this.mGenerator.addWidth(width);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00001\u9ad8\u5ea6", getterNames={"getOriginHeight"})
    public void setHeight(double height) {
        this.originHeight = height;
        this.mLayoutParams.height = DimenUtil.toDevicePx(height);
        this.mGenerator.addHeight(height);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00002\u6700\u5927\u5bbd\u5ea6", getterNames={"getOriginMaxWidth"})
    public void setMaxWidth(double maxWidth) {
        this.originMaxWidth = maxWidth;
        this.mMaxWidth = DimenUtil.dpiToPx(maxWidth);
        this.mGenerator.addMaxWidth(maxWidth);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00003\u6700\u5927\u9ad8\u5ea6", getterNames={"getOriginMaxHeight"})
    public void setMaxHeight(double maxHeight) {
        this.originMaxHeight = maxHeight;
        this.mMaxHeight = DimenUtil.dpiToPx(maxHeight);
        this.mGenerator.addMaxHeight(maxHeight);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00004\u6700\u5c0f\u5bbd\u5ea6", getterNames={"getOriginMinWidth"})
    public void setMinWidth(double minWidth) {
        this.originMinWidth = minWidth;
        this.mMinWidth = DimenUtil.dpiToPx(minWidth);
        this.mGenerator.addMinWidth(minWidth);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="00005\u6700\u5c0f\u9ad8\u5ea6", getterNames={"getOriginMinHeight"})
    public void setMinHeight(double minHeight) {
        this.originMinHeight = minHeight;
        this.mMinHeight = DimenUtil.dpiToPx(minHeight);
        this.mGenerator.addMinHeight(minHeight);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01000\u5de6", getterNames={"getOriginMarginLeft"}, groupName="\u5916\u8fb9\u8ddd", groupIndex=1)
    public void setMarginLeft(double left) {
        this.originMarginLeft = left;
        this.mLayoutParams.leftMargin = DimenUtil.dpiToPx(left);
        this.mGenerator.addMarginLeft(left);
        this.requestLayout();
    }

    private int getMarginLeft() {
        return this.mLayoutParams.leftMargin;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01000\u4e0a", getterNames={"getOriginMarginTop"}, groupName="\u5916\u8fb9\u8ddd", groupIndex=2)
    public void setMarginTop(double top) {
        this.originMarginTop = top;
        this.mLayoutParams.topMargin = DimenUtil.dpiToPx(top);
        this.mGenerator.addMarginTop(top);
        this.requestLayout();
    }

    private int getMarginTop() {
        return this.mLayoutParams.topMargin;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01000\u53f3", getterNames={"getOriginMarginRight"}, groupName="\u5916\u8fb9\u8ddd", groupIndex=3)
    public void setMarginRight(double right) {
        this.originMarginRight = right;
        this.mLayoutParams.rightMargin = DimenUtil.dpiToPx(right);
        this.mGenerator.addMarginRight(right);
        this.requestLayout();
    }

    private int getMarginRight() {
        return this.mLayoutParams.rightMargin;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01000\u4e0b", getterNames={"getOriginMarginBottom"}, groupName="\u5916\u8fb9\u8ddd", groupIndex=4)
    public void setMarginBottom(double bottom) {
        this.originMarginBottom = bottom;
        this.mLayoutParams.bottomMargin = DimenUtil.dpiToPx(bottom);
        this.mGenerator.addMarginBottom(bottom);
        this.requestLayout();
    }

    private int getMarginBottom() {
        return this.mLayoutParams.bottomMargin;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01002\u5438\u9644\u6548\u679c", getterNames={"getGravity(GravityConstants)"}, enumClass=GravityConstants.class)
    public void setGravity(int gravity) {
        this.mLayoutParams.gravity = gravity;
        this.mGenerator.addGravity(gravity);
        this.requestLayout();
    }

    private int getGravity() {
        return this.mLayoutParams.gravity;
    }

    @Override
    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    @Override
    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    @Override
    public int getMinHeight() {
        return this.mMinHeight;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02000\u56fe\u7247", getterNames={"getImageName"}, selectionId="\u80cc\u666f", needActionUpdater=true)
    public void setBgImage(String mImageName) {
        if (mImageName != null) {
            this.mBgColor = null;
            this.mImageName = mImageName;
            this.mBackground = ImageLoader.getInstance().loadProjectImage(mImageName);
            this.endColor = null;
            this.startColor = null;
            this.mGenerator.addBgImage(mImageName);
            this.requestLayout();
        }
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02001\u989c\u8272", getterNames={"getBgColor"}, selectionId="\u80cc\u666f")
    public void setBgColor(Color color) {
        if (color == null) {
            return;
        }
        this.mBgColor = color;
        this.mGenerator.addBgColor(color);
        this.mImageName = "";
        this.mBackground = null;
        this.reDraw();
    }

    public String getImageName() {
        return this.mImageName;
    }

    public Image getBackground() {
        return this.mBackground;
    }

    @Override
    public void setMeasureDimension(int measureWidth, int measureHeight) {
        if (this.mLayoutParams.width == -2) {
            this.mMeasuredWidth = Math.max(Math.min(measureWidth, this.mMaxWidth), this.mMinWidth);
            if (this.mBackground != null) {
                this.mMeasuredWidth = Math.max(this.mBackground.getWidth(null), this.mMeasuredWidth);
            }
        } else {
            this.mMeasuredWidth = measureWidth;
        }
        if (this.mLayoutParams.height == -2) {
            this.mMeasuredHeight = Math.max(Math.min(measureHeight, this.mMaxHeight), this.mMinHeight);
            if (this.mBackground != null) {
                this.mMeasuredHeight = Math.max(this.mBackground.getHeight(null), this.mMeasuredHeight);
            }
        } else {
            this.mMeasuredHeight = measureHeight;
        }
        this.mContainer.setSize(this.mMeasuredWidth, this.mMeasuredHeight);
    }

    @Override
    public int getMinWidth() {
        return this.mMinWidth;
    }

    @Override
    public void setPadding(double left, double top, double right, double bottom) {
        this.originPaddingBottom = bottom;
        this.originPaddingTop = top;
        this.originPaddingRight = right;
        this.originPaddingLeft = left;
        this.mPaddingLeft = DimenUtil.dpiToPx(left);
        this.mPaddingTop = DimenUtil.dpiToPx(top);
        this.mPaddingRight = DimenUtil.dpiToPx(right);
        this.mPaddingBottom = DimenUtil.dpiToPx(bottom);
        this.mContainer.setBorder(BorderFactory.createEmptyBorder(this.mPaddingTop, this.mPaddingLeft, this.mPaddingBottom, this.mPaddingRight));
        this.mGenerator.addPadding(left, top, right, bottom);
        this.requestLayout();
    }

    @MyAnnotation(ofView="9View", desc="01001\u5de6", getterNames={"getOriginPaddingLeft"}, groupName="\u5185\u8fb9\u8ddd", groupIndex=1)
    private void setPaddingLeft(double left) {
        this.setPadding(left, this.originPaddingTop, this.originPaddingRight, this.originPaddingBottom);
    }

    @MyAnnotation(ofView="9View", desc="01001\u4e0a", getterNames={"getOriginPaddingTop"}, groupName="\u5185\u8fb9\u8ddd", groupIndex=2)
    private void setPaddingTop(double top) {
        this.setPadding(this.originPaddingLeft, top, this.originPaddingRight, this.originPaddingBottom);
    }

    @MyAnnotation(ofView="9View", desc="01001\u53f3", getterNames={"getOriginPaddingRight"}, groupName="\u5185\u8fb9\u8ddd", groupIndex=3)
    private void setPaddingRight(double right) {
        this.setPadding(this.originPaddingLeft, this.originPaddingTop, right, this.originPaddingBottom);
    }

    @MyAnnotation(ofView="9View", desc="01001\u4e0b", getterNames={"getOriginPaddingBottom"}, groupName="\u5185\u8fb9\u8ddd", groupIndex=4)
    private void setPaddingBottom(double bottom) {
        this.setPadding(this.originPaddingLeft, this.originPaddingTop, this.originPaddingRight, bottom);
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01003\u7ea6\u675f\u4f18\u5148\u7ea7", getterNames={"getPriority"})
    public void setPriority(int priority) {
        this.mLayoutParams.priority = priority;
        this.mGenerator.addPriority(priority);
        this.requestLayout();
    }

    private int getPriority() {
        return this.mLayoutParams.priority;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="01004\u7ea6\u675f\u6743\u91cd", getterNames={"getWeight"})
    public void setWeight(int weight) {
        this.mLayoutParams.weight = weight;
        this.mGenerator.addWeight(weight);
        this.requestLayout();
    }

    private int getWeight() {
        return this.mLayoutParams.weight;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02008\u8fb9\u6846\u5bbd\u5ea6", getterNames={"getOriginBorderWidth"})
    public void setBorderWidth(double width) {
        this.originBorderWidth = width;
        this.mBorderWidth = DimenUtil.dpiToPx(width);
        this.mGenerator.addBorderWidth(width);
        this.borderHelper.setBorderWidth(this.mBorderWidth);
        this.reDraw();
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02009\u8fb9\u6846\u989c\u8272", getterNames={"getBorderColor"})
    public void setBorderColor(Color color) {
        this.mBorderColor = color;
        this.mGenerator.addBorderColor(color);
        this.borderHelper.setBorderColor(color);
        this.reDraw();
    }

    @Override
    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public Color getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02006\u663e\u793a", getterNames={"getVisibility(Visibility)"}, enumClass=Visibility.class)
    public void setVisibility(int visibility) {
        this.mVisibility = visibility;
        if (visibility == 1) {
            this.mContainer.setVisible(false);
        } else if (visibility == 0) {
            this.mContainer.setVisible(true);
        }
        this.requestLayout();
        this.mGenerator.addVisibility(visibility);
    }

    @Override
    public int getVisibility() {
        return this.mVisibility;
    }

    @Override
    public Color getBgColor() {
        return this.mBgColor;
    }

    @Override
    @MyAnnotation(ofView="9View", desc="02005\u900f\u660e\u5ea6", getterNames={"getAlpha"}, minLimit=0.0, maxLimit=1.0)
    public void setAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        } else if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        this.mAlpha = alpha;
        this.mGenerator.addAlpha(alpha);
        this.reDraw();
    }

    @Override
    public float getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void addCornerMask(double r, Color color, int rectCorner) {
        this.originRadius = new double[4];
        this.radius = new float[4];
        this.updateMaskRadius(r, rectCorner);
        this.maskColor = color;
        this.maskCorner |= rectCorner;
        this.updatePath();
        this.mGenerator.addCornerMask(r, color, rectCorner);
        this.reDraw();
    }

    private void updateMaskRadius(double r, int rectCorner) {
        if ((rectCorner & 0xF) == 15 || rectCorner == 0) {
            this.originMaskRadius[2] = this.originMaskRadius[3] = r;
            this.originMaskRadius[1] = this.originMaskRadius[3];
            this.originMaskRadius[0] = this.originMaskRadius[3];
        } else {
            if ((rectCorner & 1) == 1) {
                this.originMaskRadius[0] = r;
            }
            if ((rectCorner & 2) == 2) {
                this.originMaskRadius[1] = r;
            }
            if ((rectCorner & 4) == 4) {
                this.originMaskRadius[2] = r;
            }
            if ((rectCorner & 8) == 8) {
                this.originMaskRadius[3] = r;
            }
        }
    }

    @MyAnnotation(ofView="9View", desc="02003\u989c\u8272", getterNames={"getMaskColor"}, selectionId="\u5706\u89d2", groupName="\u7ed8\u5236\u5706\u89d2", groupIndex=1)
    public void setCornerColor(Color cornerColor) {
        this.originRadius = null;
        this.radius = null;
        this.maskColor = cornerColor != null ? cornerColor : null;
        this.updatePath();
        this.reDraw();
        this.mGenerator.addCornerMaskColor(this.maskColor);
    }

    @MyAnnotation(ofView="9View", desc="02003\u5de6\u4e0a", getterNames={"getTopLeftCornerMask"}, selectionId="\u5706\u89d2", groupName="\u7ed8\u5236\u5706\u89d2", groupIndex=2)
    public void setTopLeftCornerMask(double radius) {
        this.addCornerMask(radius, this.maskColor, 1);
    }

    @MyAnnotation(ofView="9View", desc="02003\u53f3\u4e0a", getterNames={"getTopRightCornerMask"}, selectionId="\u5706\u89d2", groupName="\u7ed8\u5236\u5706\u89d2", groupIndex=3)
    public void setTopRightCornerMask(double radius) {
        this.addCornerMask(radius, this.maskColor, 2);
    }

    @MyAnnotation(ofView="9View", desc="02003\u5de6\u4e0b", getterNames={"getBottomLeftCornerMask"}, selectionId="\u5706\u89d2", groupName="\u7ed8\u5236\u5706\u89d2", groupIndex=4)
    public void setBottomLeftCornerMask(double radius) {
        this.addCornerMask(radius, this.maskColor, 4);
    }

    @MyAnnotation(ofView="9View", desc="02003\u53f3\u4e0b", getterNames={"getBottomRightCornerMask"}, selectionId="\u5706\u89d2", groupName="\u7ed8\u5236\u5706\u89d2", groupIndex=5)
    public void setBottomRightCornerMask(double radius) {
        this.addCornerMask(radius, this.maskColor, 8);
    }

    private double getTopLeftCornerMask() {
        return this.originMaskRadius[0];
    }

    private double getTopRightCornerMask() {
        return this.originMaskRadius[1];
    }

    private double getBottomLeftCornerMask() {
        return this.originMaskRadius[2];
    }

    private double getBottomRightCornerMask() {
        return this.originMaskRadius[3];
    }

    public double getCornerRadiusWithRect(int rectCorner) {
        if ((rectCorner & 1) == 1) {
            return this.originRadius[0];
        }
        if ((rectCorner & 2) == 2) {
            return this.originRadius[1];
        }
        if ((rectCorner & 4) == 4) {
            return this.originRadius[3];
        }
        if ((rectCorner & 8) == 8) {
            return this.originRadius[2];
        }
        return this.originRadius[0];
    }

    public Color getMaskColor() {
        return this.maskColor;
    }

    public int getMaskCorner() {
        return this.maskCorner;
    }

    @Override
    public void setCornerRadiusWithDirection(double r, int rectCorner) {
        this.originCornerRadius = r;
        this.originMaskRadius = new double[4];
        this.maskColor = null;
        this.rectCorner = rectCorner;
        this.handleRadius(r, rectCorner);
        this.mGenerator.addCornerRadiusWithDirection(r, rectCorner);
        this.reDraw();
    }

    @MyAnnotation(ofView="9View", desc="02004\u5de6\u4e0a", getterNames={"getTopLeftCornerRadius"}, selectionId="\u5706\u89d2", groupName="\u5207\u5272\u5706\u89d2", groupIndex=1)
    public void setTopLeftCornerRadius(double r) {
        this.setCornerRadiusWithDirection(r, 1);
    }

    @MyAnnotation(ofView="9View", desc="02004\u53f3\u4e0a", getterNames={"getTopRightCornerRadius"}, selectionId="\u5706\u89d2", groupName="\u5207\u5272\u5706\u89d2", groupIndex=2)
    public void setTopRightCornerRadius(double r) {
        this.setCornerRadiusWithDirection(r, 2);
    }

    @MyAnnotation(ofView="9View", desc="02004\u5de6\u4e0b", getterNames={"getBottomLeftCornerRadius"}, selectionId="\u5706\u89d2", groupName="\u5207\u5272\u5706\u89d2", groupIndex=3)
    public void setBottomLeftCornerRadius(double r) {
        this.setCornerRadiusWithDirection(r, 4);
    }

    @MyAnnotation(ofView="9View", desc="02004\u53f3\u4e0b", getterNames={"getBottomRightCornerRadius"}, selectionId="\u5706\u89d2", groupName="\u5207\u5272\u5706\u89d2", groupIndex=4)
    public void setBottomRightCornerRadius(double r) {
        this.setCornerRadiusWithDirection(r, 8);
    }

    private double getTopLeftCornerRadius() {
        if (this.originRadius == null) {
            return 0.0;
        }
        return this.originRadius[0];
    }

    private double getTopRightCornerRadius() {
        if (this.originRadius == null) {
            return 0.0;
        }
        return this.originRadius[1];
    }

    private double getBottomLeftCornerRadius() {
        if (this.originRadius == null) {
            return 0.0;
        }
        return this.originRadius[3];
    }

    private double getBottomRightCornerRadius() {
        if (this.originRadius == null) {
            return 0.0;
        }
        return this.originRadius[2];
    }

    public void reSetCornerRadiusType() {
        this.originRadius = null;
    }

    private void handleRadius(double r, int rectCorner) {
        if (this.originRadius == null) {
            this.originRadius = new double[4];
        }
        if ((rectCorner & 0xF) == 15) {
            this.originRadius[2] = this.originRadius[3] = r;
            this.originRadius[1] = this.originRadius[3];
            this.originRadius[0] = this.originRadius[3];
        } else {
            if ((rectCorner & 1) == 1) {
                this.originRadius[0] = r;
            }
            if ((rectCorner & 2) == 2) {
                this.originRadius[1] = r;
            }
            if ((rectCorner & 4) == 4) {
                this.originRadius[3] = r;
            }
            if ((rectCorner & 8) == 8) {
                this.originRadius[2] = r;
            }
        }
        if (this.radius == null) {
            this.radius = new float[4];
        }
        this.radius[0] = DimenUtil.dpiToPx(this.originRadius[0]);
        this.radius[1] = DimenUtil.dpiToPx(this.originRadius[1]);
        this.radius[2] = DimenUtil.dpiToPx(this.originRadius[2]);
        this.radius[3] = DimenUtil.dpiToPx(this.originRadius[3]);
        this.borderHelper.setRadius(this.radius);
    }

    private int getRectCorner() {
        return this.rectCorner;
    }

    private double getOriginCornerRadius() {
        return this.originCornerRadius;
    }

    @Override
    public void setGradientColorWithDirection(Color s, Color e, int type2) {
        this.startColor = s;
        this.endColor = e;
        this.gradientType = type2;
        this.mGenerator.addGradientColorWithDirection(s, e, type2);
        this.reDraw();
    }

    @MyAnnotation(ofView="9View", desc="02002\u8d77\u59cb\u8272", getterNames={"getStartColor"}, groupName="\u6e10\u53d8", groupIndex=2)
    private void setGradientColorWithStartColor(Color startColor) {
        this.setGradientColorWithDirection(startColor, this.endColor, this.gradientType);
    }

    @MyAnnotation(ofView="9View", desc="02002\u7ec8\u6b62\u8272", getterNames={"getEndColor"}, groupName="\u6e10\u53d8", groupIndex=3)
    private void setGradientColorWithEndColor(Color endColor) {
        this.setGradientColorWithDirection(this.startColor, endColor, this.gradientType);
    }

    @MyAnnotation(ofView="9View", desc="02002\u7c7b\u578b   ", getterNames={"getGradientType(GradientType)"}, enumClass=GradientType.class, groupName="\u6e10\u53d8", groupIndex=1)
    private void setGradientColorWithGradientType(int gradientType) {
        this.setGradientColorWithDirection(this.startColor, this.endColor, gradientType);
    }

    private Color getStartColor() {
        return this.startColor;
    }

    private Color getEndColor() {
        return this.endColor;
    }

    private int getGradientType() {
        return this.gradientType;
    }

    @Override
    public void setShadow(double x, double y, double r, float alpha) {
        this.showShadow = true;
        this.originShadowX = x;
        this.originShadowY = y;
        this.originShadowRadius = r;
        this.originShadowAlpha = alpha;
        this.shadowX = DimenUtil.dpiToPx(x);
        this.shadowY = DimenUtil.dpiToPx(y);
        this.shadowRadius = DimenUtil.dpiToPx(r);
        this.shadowAlpha = alpha;
        this.shadowColor = new Color(0.0f, 0.0f, 0.0f, alpha);
        int w = this.mContainer.getWidth();
        int h = this.mContainer.getHeight();
        if (w > 0 && h > 0) {
            this.shadowImage = ShadowImageGenerator.generate(w + this.shadowRadius * 2, h + this.shadowRadius * 2, this.shadowRadius, this.shadowColor);
        }
        this.mGenerator.addShadow(x, y, r, alpha);
        this.requestLayout();
    }

    @Override
    public void overlay(UDBaseView overView) {
        this.mGenerator.addOverlay(overView);
    }

    private void setShadowWithX(double x) {
        this.setShadow(x, this.originShadowY, this.originShadowRadius, this.originShadowAlpha);
    }

    private void setShadowWithY(double y) {
        this.setShadow(this.originShadowX, y, this.originShadowRadius, this.originShadowAlpha);
    }

    private void setShadowWithRadius(double r) {
        this.setShadow(this.originShadowX, this.originShadowY, r, this.originShadowAlpha);
    }

    private void setShadowWithAlpha(float alpha) {
        this.setShadow(this.originShadowX, this.originShadowY, this.originShadowRadius, alpha);
    }

    private double getShadowX() {
        return this.shadowX;
    }

    private double getShadowY() {
        return this.shadowY;
    }

    private double getShadowRadius() {
        return this.shadowRadius;
    }

    private float getShadowAlpha() {
        return this.shadowAlpha;
    }

    @Override
    public void layout(int x, int y) {
        this.mContainer.setLocation(x, y);
    }

    public boolean canDrawBackground() {
        return this.mBgColor != null || this.mImageName != null && this.mImageName.length() > 0 || this.startColor != null && this.endColor != null || this.showShadow;
    }

    public boolean canClip() {
        return this.originRadius != null && (this.originRadius[0] != 0.0 || this.originRadius[1] != 0.0 || this.originRadius[2] != 0.0 || this.originRadius[3] != 0.0);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite cmp = AlphaComposite.getInstance(3, 1.0f);
        g2d.setComposite(cmp.derive(this.getPaintAlpha()));
        int w = this.mContainer.getWidth();
        int h = this.mContainer.getHeight();
        if (this.shadowImage != null) {
            g.drawImage(this.shadowImage, this.shadowX, this.shadowY, null);
        }
        if (this.mBackground != null) {
            g.drawImage(this.mBackground, 0, 0, w, h, this.mContainer);
        } else if (this.startColor != null && this.endColor != null) {
            float ex;
            float sx;
            float sy;
            float ey;
            switch (this.gradientType) {
                case 1: {
                    ey = 0.0f;
                    sy = 0.0f;
                    sx = 0.0f;
                    ex = w;
                    break;
                }
                case 2: {
                    sx = w;
                    ex = 0.0f;
                    ey = 0.0f;
                    sy = 0.0f;
                    break;
                }
                case 3: {
                    sy = 0.0f;
                    ex = 0.0f;
                    sx = 0.0f;
                    ey = h;
                    break;
                }
                default: {
                    ey = 0.0f;
                    ex = 0.0f;
                    sx = 0.0f;
                    sy = h;
                }
            }
            GradientPaint gradientPaint = new GradientPaint(sx, sy, this.startColor, ex, ey, this.endColor, false);
            g2d.setPaint(gradientPaint);
            g2d.fillRect(0, 0, w, h);
        } else if (this.mBgColor != null) {
            g.setColor(this.mBgColor);
            g.fillRect(0, 0, w, h);
        }
    }

    private void updatePath() {
        if (this.maskPath == null) {
            this.maskPath = new Path2D[4];
        }
        int l = this.originMaskRadius.length;
        for (int i = 0; i < l; ++i) {
            Path2D path = this.maskPath[i];
            if (path == null) {
                this.maskPath[i] = path = new Path2D.Float();
            } else {
                path.reset();
            }
            this.updatePath(path, i, (float)this.originMaskRadius[i]);
        }
    }

    private void updatePath(Path2D path, int pos, float r) {
        if (r > 0.0f) {
            float sy;
            float ex;
            float sx;
            float ey;
            float x;
            float y;
            switch (pos) {
                case 0: {
                    y = 0.0f;
                    x = 0.0f;
                    ey = 0.0f;
                    sx = 0.0f;
                    sy = ex = r;
                    break;
                }
                case 1: {
                    y = 0.0f;
                    sy = 0.0f;
                    sx = 0.0f;
                    ey = x = r;
                    ex = x;
                    break;
                }
                case 2: {
                    x = y = r;
                    ey = y;
                    sx = y;
                    ex = 0.0f;
                    sy = 0.0f;
                    break;
                }
                default: {
                    sy = y = r;
                    sx = y;
                    x = 0.0f;
                    ey = 0.0f;
                    ex = 0.0f;
                }
            }
            path.moveTo(sx, sy);
            RoundClipHelper.addArc(path, pos, x, y, ex, ey, r);
            path.lineTo(x, y);
            path.closePath();
        }
    }

    public void paintMask(Graphics g) {
        if (this.maskPath == null || this.maskColor == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.maskColor);
        int w = this.mContainer.getWidth();
        int h = this.mContainer.getHeight();
        int l = this.originMaskRadius.length;
        for (int i = 0; i < l; ++i) {
            int tx;
            int ty2;
            Path2D path2D = this.maskPath[i];
            double d = this.originMaskRadius[i];
            if (path2D == null) continue;
            switch (i) {
                case 0: {
                    ty2 = 0;
                    tx = 0;
                    break;
                }
                case 1: {
                    tx = (int)((double)w - d);
                    ty2 = 0;
                    break;
                }
                case 2: {
                    tx = (int)((double)w - d);
                    ty2 = (int)((double)h - d);
                    break;
                }
                default: {
                    ty2 = (int)((double)h - d);
                    tx = 0;
                }
            }
            g.translate(tx, ty2);
            g2d.fill(path2D);
            g.translate(-tx, -ty2);
        }
    }

    @Override
    public void requestLayout() {
        if (this.mContainer.getParent() != null && this.mContainer.getParent() instanceof ViewParent) {
            ((ViewParent)((Object)this.mContainer.getParent())).requestLayout();
        }
    }

    @Override
    public void reDraw() {
        this.mContainer.invalidate();
        this.mContainer.repaint();
        if (this.mContainer.getParent() != null) {
            BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHOTO_PANEL_CODE", null));
        }
    }

    private void notifyPropertyPanel() {
        if (this.mContainer.getParent() != null) {
            BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK", this.mContainer));
        }
    }

    public double getOriginWidth() {
        return this.originWidth;
    }

    public double getOriginHeight() {
        return this.originHeight;
    }

    public double getOriginMaxWidth() {
        return this.originMaxWidth;
    }

    public double getOriginMaxHeight() {
        return this.originMaxHeight;
    }

    public double getOriginMinWidth() {
        return this.originMinWidth;
    }

    public double getOriginMinHeight() {
        return this.originMinHeight;
    }

    public double getOriginPaddingLeft() {
        return this.originPaddingLeft;
    }

    public double getOriginPaddingRight() {
        return this.originPaddingRight;
    }

    public double getOriginPaddingBottom() {
        return this.originPaddingBottom;
    }

    public double getOriginPaddingTop() {
        return this.originPaddingTop;
    }

    public double getOriginMarginLeft() {
        return this.originMarginLeft;
    }

    public double getOriginMarginRight() {
        return this.originMarginRight;
    }

    public double getOriginMarginBottom() {
        return this.originMarginBottom;
    }

    public double getOriginMarginTop() {
        return this.originMarginTop;
    }

    public double getOriginBorderWidth() {
        return this.originBorderWidth;
    }

    public double getOriginShadowX() {
        return this.originShadowX;
    }

    public double getOriginShadowY() {
        return this.originShadowY;
    }

    public double getOriginShadowRadius() {
        return this.originShadowRadius;
    }

    public float getOriginShadowAlpha() {
        return this.originShadowAlpha;
    }

    @Override
    public void setPaintAlpha(float a) {
        this.paintAlpha = a = Math.min(Math.max(a, 0.0f), 1.0f);
    }

    @Override
    public float getPaintAlpha() {
        return this.paintAlpha * this.mAlpha;
    }
}

