/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.weight.ViewWrapper;
import com.immomo.mlservics.weight.interfaces.IAlphaView;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.interfaces.ViewParent;
import com.immomo.mlservics.weight.utils.MeasureUtil;
import com.immomo.mlservics.weight.utils.RoundClipHelper;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.code.generator.Generator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ViewGroup
extends JPanel
implements IView,
ViewParent,
IAlphaView {
    protected ViewWrapper mViewWrapper;
    private JComponent phonePanel;
    private boolean isRequestLayout = false;
    protected Generator generator;

    public ViewGroup() {
        this((JComponent)null);
    }

    public ViewGroup(JComponent phonePanel) {
        this.phonePanel = phonePanel;
        this.init();
    }

    private void init() {
        this.generator = this.createGenerator();
        this.mViewWrapper = new ViewWrapper(this, this.generator);
        this.setLayout(new GroupLayoutManager());
    }

    public Generator createGenerator() {
        return new Generator();
    }

    public void setPhonePanel(JComponent phonePanel) {
        this.phonePanel = phonePanel;
    }

    public Component add(IView view, int index) {
        if (index > this.getComponentCount()) {
            index = -1;
        }
        if (view instanceof Component) {
            Component component = (Component)((Object)view);
            super.remove(component);
            return super.add(component, index);
        }
        throw new RuntimeException(view.getClass().getName() + " must implements IView");
    }

    @Override
    public ViewWrapper getViewWrapper() {
        return this.mViewWrapper;
    }

    @Override
    public LayoutParams getLayoutParams() {
        return this.mViewWrapper.getLayoutParams();
    }

    @Override
    public int getPaddingLeft() {
        return this.mViewWrapper.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        return this.mViewWrapper.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.mViewWrapper.getPaddingBottom();
    }

    @Override
    public int getPaddingRight() {
        return this.mViewWrapper.getPaddingRight();
    }

    @Override
    public int getMaxWidth() {
        return this.mViewWrapper.getMaxWidth();
    }

    @Override
    public int getMaxHeight() {
        return this.mViewWrapper.getMaxHeight();
    }

    @Override
    public int getMinWidth() {
        return this.mViewWrapper.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        return this.mViewWrapper.getMinHeight();
    }

    @Override
    public void setLayoutParams(LayoutParams layoutParams) {
        this.mViewWrapper.setLayoutParams(layoutParams);
    }

    @Override
    public void setWidth(double width) {
        this.mViewWrapper.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        this.mViewWrapper.setHeight(height);
    }

    @Override
    public void setMaxWidth(double maxWidth) {
        this.mViewWrapper.setMaxWidth(maxWidth);
    }

    @Override
    public void setMaxHeight(double maxHeight) {
        this.mViewWrapper.setMaxHeight(maxHeight);
    }

    @Override
    public void setMinWidth(double minWidth) {
        this.mViewWrapper.setMinWidth(minWidth);
    }

    @Override
    public void setMinHeight(double minHeight) {
        this.mViewWrapper.setMinHeight(minHeight);
    }

    @Override
    public int getMeasuredWidth() {
        return this.mViewWrapper.mMeasuredWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.mViewWrapper.mMeasuredHeight;
    }

    @Override
    public void setMarginLeft(double left) {
        this.mViewWrapper.setMarginLeft(left);
    }

    @Override
    public void setMarginRight(double right) {
        this.mViewWrapper.setMarginRight(right);
    }

    @Override
    public void setMarginBottom(double bottom) {
        this.mViewWrapper.setMarginBottom(bottom);
    }

    @Override
    public void setMarginTop(double top) {
        this.mViewWrapper.setMarginTop(top);
    }

    @Override
    public void setGravity(int gravity) {
        this.mViewWrapper.setGravity(gravity);
    }

    @Override
    public void setPadding(double left, double top, double right, double bottom) {
        this.mViewWrapper.setPadding(left, top, right, bottom);
    }

    @Override
    public void setBgColor(Color color) {
        this.mViewWrapper.setBgColor(color);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container p = this.getParent();
        if (p instanceof IAlphaView) {
            this.setPaintAlpha(((IAlphaView)((Object)p)).getPaintAlpha());
        } else {
            this.setPaintAlpha(1.0f);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mViewWrapper.canClip()) {
            RoundClipHelper.clip(g, this.mViewWrapper.radius, this.getWidth(), this.getHeight());
        }
        if (this.mViewWrapper.canDrawBackground()) {
            this.mViewWrapper.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite cmp = AlphaComposite.getInstance(3, 1.0f);
            g2d.setComposite(cmp.derive(this.getPaintAlpha()));
            super.paintComponent(g);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.mViewWrapper.getBorderHelper().draw(g, this);
        this.mViewWrapper.paintMask(g);
    }

    @Override
    public void setPaintAlpha(float a) {
        this.mViewWrapper.setPaintAlpha(a);
        for (Component c : this.getComponents()) {
            if (!(c instanceof IAlphaView)) continue;
            ((IAlphaView)((Object)c)).setPaintAlpha(this.getPaintAlpha());
        }
    }

    @Override
    public float getPaintAlpha() {
        return this.mViewWrapper.getPaintAlpha();
    }

    protected final void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.mViewWrapper.setMeasureDimension(measuredWidth, measuredHeight);
    }

    @Override
    public void setBgImage(String icon) {
        this.mViewWrapper.setBgImage(icon);
    }

    @Override
    public void setAlpha(float alpha) {
        this.mViewWrapper.setAlpha(alpha);
        for (Component c : this.getComponents()) {
            if (!(c instanceof IAlphaView)) continue;
            ((IAlphaView)((Object)c)).setPaintAlpha(this.getPaintAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.mViewWrapper.getAlpha();
    }

    @Override
    public int getBorderWidth() {
        return this.mViewWrapper.getBorderWidth();
    }

    protected void measureChildWithMargins(IView child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = MeasureUtil.getChildMeasureSpec(parentWidthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = MeasureUtil.getChildMeasureSpec(parentHeightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected int getSuggestedMinimumHeight() {
        return this.mViewWrapper.getBackground() == null ? this.getMinHeight() : Math.max(this.getMinHeight(), this.mViewWrapper.getBackground().getHeight(null));
    }

    protected int getSuggestedMinimumWidth() {
        return this.mViewWrapper.getBackground() == null ? this.getMinWidth() : Math.max(this.getMinWidth(), this.mViewWrapper.getBackground().getWidth(null));
    }

    @Override
    public void setBorderWidth(double width) {
        this.mViewWrapper.setBorderWidth(width);
    }

    @Override
    public void setBorderColor(Color color) {
        this.mViewWrapper.setBorderColor(color);
    }

    @Override
    public void setPriority(int priority) {
        this.mViewWrapper.setPriority(priority);
    }

    @Override
    public void setWeight(int weight) {
        this.mViewWrapper.setWeight(weight);
    }

    @Override
    public void setVisibility(int visibility) {
        this.mViewWrapper.setVisibility(visibility);
    }

    @Override
    public Color getBorderColor() {
        return this.mViewWrapper.getBorderColor();
    }

    @Override
    public Color getBgColor() {
        return this.mViewWrapper.getBgColor();
    }

    @Override
    public void addCornerMask(double borderWidth, Color color, int rectCorner) {
        this.mViewWrapper.addCornerMask(borderWidth, color, rectCorner);
    }

    @Override
    public void reDraw() {
        this.mViewWrapper.reDraw();
    }

    @Override
    public void setCornerRadiusWithDirection(double r, int rectCorner) {
        this.mViewWrapper.setCornerRadiusWithDirection(r, rectCorner);
    }

    @Override
    public void setGradientColorWithDirection(Color s, Color e, int type2) {
        this.mViewWrapper.setGradientColorWithDirection(s, e, type2);
    }

    @Override
    public void setShadow(double x, double y, double r, float alpha) {
        this.mViewWrapper.setShadow(x, y, r, alpha);
    }

    @Override
    public void overlay(UDBaseView overView) {
        if (overView != null) {
            Object overlay = overView.getView();
            this.add((Component)overlay);
            this.mViewWrapper.overlay(overView);
        }
    }

    @Override
    public int getVisibility() {
        return this.mViewWrapper.getVisibility();
    }

    @Override
    public void requestLayout() {
        if (this.phonePanel != null) {
            this.isRequestLayout = false;
            this.repaint();
            this.revalidate();
            BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHOTO_PANEL_CODE", null));
            return;
        }
        this.mViewWrapper.requestLayout();
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        this.mViewWrapper.layout(x, y);
        this.onLayout();
    }

    @Override
    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        this.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected abstract void onMeasure(int var1, int var2);

    protected abstract void onLayout();

    public static class LayoutParams {
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        public int width;
        public int height;
        public int leftMargin = 0;
        public int topMargin = 0;
        public int rightMargin = 0;
        public int bottomMargin = 0;
        public int priority = 0;
        public int weight = 0;
        public int gravity = -1;

        public LayoutParams(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public class GroupLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ViewGroup.this.phonePanel != null) {
                if (ViewGroup.this.isRequestLayout) {
                    return;
                }
                IView target = (IView)((Object)parent);
                ViewGroup.this.measure(MeasureUtil.getRootMeasureSpec(ViewGroup.this.phonePanel.getWidth(), target.getLayoutParams().width), MeasureUtil.getRootMeasureSpec(ViewGroup.this.phonePanel.getHeight(), target.getLayoutParams().height));
                ViewGroup.this.onLayout();
                ViewGroup.this.isRequestLayout = true;
            }
        }
    }
}

