/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.weight.BaseImageView;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.ViewWrapper;
import com.immomo.mlservics.weight.interfaces.IAlphaView;
import com.immomo.mlservics.weight.interfaces.ISwitch;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.interfaces.ViewParent;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.BlurUtils;
import com.immomo.mlservics.weight.utils.DrawImageHelper;
import com.immomo.mlservics.weight.utils.RoundClipHelper;
import com.immomo.mmpaas.code.generator.SwitchCodeGenerator;
import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import com.immomo.mmpaas.utils.P;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.SwingUtilities;

public class Switch
extends BaseImageView
implements IView,
ISwitch,
ViewParent,
IAlphaView {
    private static final String switchOnImage = P.icons.switch_ON;
    private static final String switchOffImage = P.icons.switch_OFF;
    private boolean isOn = false;
    private Image blurImage;
    private int blurRadius = 0;
    private SwitchCodeGenerator switchCodeGenerator;
    private ViewWrapper mViewWrapper;
    private ImageObserver observer = (img, infoflags, x, y, width, height) -> {
        SwingUtilities.invokeLater(this::invalidate);
        return false;
    };

    public Switch() {
        this.switchCodeGenerator = new SwitchCodeGenerator();
        this.mViewWrapper = new ViewWrapper(this, this.switchCodeGenerator);
    }

    @Override
    @MyAnnotation(ofView="0Switch", desc="02000\u5f00\u5173\u72b6\u6001", getterNames={"isOn"})
    public void on(boolean a) {
        this.isOn = a;
        this.setImage(this.isOn ? switchOnImage : switchOffImage);
        this.switchCodeGenerator.on(a);
        this.reDraw();
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container p = this.getParent();
        if (p instanceof IAlphaView) {
            this.mViewWrapper.setPaintAlpha(((IAlphaView)((Object)p)).getPaintAlpha());
        } else {
            this.mViewWrapper.setPaintAlpha(1.0f);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Image image;
        if (this.mViewWrapper.canClip()) {
            RoundClipHelper.clip(g, this.mViewWrapper.radius, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite cmp = AlphaComposite.getInstance(3, 1.0f);
        g2d.setComposite(cmp.derive(this.getPaintAlpha()));
        Image image2 = image = this.blurImage != null ? this.blurImage : this.image;
        if (image != null) {
            int imageW = image.getWidth(null);
            int imageH = image.getHeight(null);
            if (imageW > 0 && imageH > 0) {
                DrawImageHelper.draw(g, image, this.contentMode, this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom(), this);
            }
        }
    }

    @Override
    public ViewWrapper getViewWrapper() {
        return this.mViewWrapper;
    }

    public void setBlurImage(int scale, boolean isPerfect) {
        if (this.blurRadius == scale) {
            return;
        }
        this.blurRadius = scale;
        this.blurImpl();
    }

    private void blurImpl() {
        if (this.image == null) {
            return;
        }
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        if (w <= 0 || h <= 0) {
            return;
        }
        this.blurImage = BlurUtils.blurImage(this.image, this.blurRadius);
    }

    @Override
    public void requestLayout() {
        this.mViewWrapper.requestLayout();
    }

    @Override
    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightLimit;
        int widthSpecMode = MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        int width = 0;
        int height = 0;
        int widthLimit = widthSpecMode == Integer.MIN_VALUE ? widthSize : Integer.MAX_VALUE;
        int n = heightLimit = heightSpecMode == Integer.MIN_VALUE ? heightSize : Integer.MAX_VALUE;
        if (widthSpecMode == 0x40000000) {
            width = widthSize;
        } else if (this.image != null) {
            int w = this.image.getWidth(this.observer);
            w = w < 0 ? 0 : w;
            width = Math.min(w, widthLimit);
        }
        if (heightSpecMode == 0x40000000) {
            height = heightSize;
        } else if (this.image != null) {
            int h = this.image.getHeight(this.observer);
            h = h < 0 ? 0 : h;
            height = Math.min(h, heightLimit);
        }
        this.mViewWrapper.setMeasureDimension(width, height);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mViewWrapper.setLayoutParams(layoutParams);
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mViewWrapper.getLayoutParams();
    }

    @Override
    public int getPaddingLeft() {
        return this.mViewWrapper.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        return this.mViewWrapper.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.mViewWrapper.getPaddingBottom();
    }

    @Override
    public int getPaddingRight() {
        return this.mViewWrapper.getPaddingRight();
    }

    @Override
    public int getMaxWidth() {
        return this.mViewWrapper.getMaxWidth();
    }

    @Override
    public int getMaxHeight() {
        return this.mViewWrapper.getMaxHeight();
    }

    @Override
    public int getMinWidth() {
        return this.mViewWrapper.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        return this.mViewWrapper.getMinHeight();
    }

    @Override
    public int getMeasuredWidth() {
        return this.mViewWrapper.mMeasuredWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.mViewWrapper.mMeasuredHeight;
    }

    @Override
    public int getVisibility() {
        return this.mViewWrapper.getVisibility();
    }

    @Override
    public void setWidth(double width) {
        this.mViewWrapper.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        this.mViewWrapper.setHeight(height);
    }

    @Override
    public void setMaxWidth(double maxWidth) {
        this.mViewWrapper.setMaxWidth(maxWidth);
    }

    @Override
    public void setMaxHeight(double maxHeight) {
        this.mViewWrapper.setMaxHeight(maxHeight);
    }

    @Override
    public void setMinWidth(double minWidth) {
        this.mViewWrapper.setMinWidth(minWidth);
    }

    @Override
    public void setMinHeight(double minHeight) {
        this.mViewWrapper.setMinHeight(minHeight);
    }

    @Override
    public void setMarginLeft(double left) {
        this.mViewWrapper.setMarginLeft(left);
    }

    @Override
    public void setMarginRight(double right) {
        this.mViewWrapper.setMarginRight(right);
    }

    @Override
    public void setMarginBottom(double bottom) {
        this.mViewWrapper.setMarginBottom(bottom);
    }

    @Override
    public void setMarginTop(double top) {
        this.mViewWrapper.setMarginTop(top);
    }

    @Override
    public void setPriority(int priority) {
        this.mViewWrapper.setPriority(priority);
    }

    @Override
    public void setWeight(int weight) {
        this.mViewWrapper.setWeight(weight);
    }

    @Override
    public void setGravity(int gravity) {
        this.mViewWrapper.setGravity(gravity);
    }

    @Override
    public void setPadding(double left, double top, double right, double bottom) {
        this.mViewWrapper.setPadding(left, top, right, bottom);
    }

    @Override
    public void setBorderWidth(double width) {
        this.mViewWrapper.setBorderWidth(width);
    }

    @Override
    public void setBorderColor(Color color) {
        this.mViewWrapper.setBorderColor(color);
    }

    @Override
    public void setVisibility(int visibility) {
        this.mViewWrapper.setVisibility(visibility);
    }

    @Override
    public void setBgColor(Color color) {
        this.mViewWrapper.setBgColor(color);
    }

    @Override
    public void setBgImage(String icon) {
        this.mViewWrapper.setBgImage(icon);
    }

    @Override
    public void setAlpha(float alpha) {
        this.mViewWrapper.setAlpha(alpha);
    }

    @Override
    public float getAlpha() {
        return this.mViewWrapper.getAlpha();
    }

    @Override
    public int getBorderWidth() {
        return this.mViewWrapper.getBorderWidth();
    }

    @Override
    public Color getBorderColor() {
        return this.mViewWrapper.getBorderColor();
    }

    @Override
    public Color getBgColor() {
        return this.mViewWrapper.getBgColor();
    }

    @Override
    public void addCornerMask(double borderWidth, Color color, int rectCorner) {
        this.mViewWrapper.addCornerMask(borderWidth, color, rectCorner);
    }

    @Override
    public void setCornerRadiusWithDirection(double r, int rectCorner) {
        this.mViewWrapper.setCornerRadiusWithDirection(r, rectCorner);
    }

    @Override
    public void setGradientColorWithDirection(Color s, Color e, int type2) {
        this.mViewWrapper.setGradientColorWithDirection(s, e, type2);
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        this.mViewWrapper.layout(x, y);
    }

    @Override
    public void reDraw() {
        this.mViewWrapper.reDraw();
    }

    @Override
    public void setShadow(double x, double y, double r, float alpha) {
        this.mViewWrapper.setShadow(x, y, r, alpha);
    }

    @Override
    public void overlay(UDBaseView overView) {
        if (overView != null) {
            Object overlay = overView.getView();
            this.add((Component)overlay);
            this.mViewWrapper.overlay(overView);
        }
    }

    @Override
    public String getLuaClassName() {
        return "Switch";
    }

    @Override
    public void setPaintAlpha(float a) {
        this.mViewWrapper.setPaintAlpha(a);
    }

    @Override
    public float getPaintAlpha() {
        return this.mViewWrapper.getPaintAlpha();
    }
}

