/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.constants.OrientationConstants;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.other.Gravity;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.MeasureUtil;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.generator.LinearLayoutGenerator;
import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;

public class LinearLayout
extends ViewGroup {
    public static final int DEFAULT_CHILD_VERTICAL_GRAVITY = 48;
    public static final int DEFAULT_HORIZONTAL_CHILD_GRAVITY = 3;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation;
    private Component[] children;
    private int childCount = 0;

    public LinearLayout() {
        this(0);
    }

    public LinearLayout(int orientation) {
        this.mOrientation = orientation;
        if (this.generator instanceof LinearLayoutGenerator) {
            ((LinearLayoutGenerator)this.generator).generatorLinearLayout(orientation);
        }
    }

    @Override
    public Generator createGenerator() {
        this.generator = new LinearLayoutGenerator();
        return this.generator;
    }

    @MyAnnotation(ofView="0LinearLayout", desc="01000\u6392\u5217\u65b9\u5f0f", getterNames={"getOrientation(OrientationConstants)"}, enumClass=OrientationConstants.class)
    public void setOrientation(int mOrientation) {
        this.mOrientation = mOrientation;
        if (this.generator instanceof LinearLayoutGenerator) {
            ((LinearLayoutGenerator)this.generator).generatorLinearLayout(mOrientation);
        }
        this.requestLayout();
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.reAddByPriority();
        widthMeasureSpec = this.getSpec(widthMeasureSpec, this.getMaxWidth());
        heightMeasureSpec = this.getSpec(heightMeasureSpec, this.getMaxHeight());
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int usedHeight = 0;
        int mPaddingTop = this.getPaddingTop();
        int mPaddingBottom = this.getPaddingBottom();
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int maxWidth = 0;
        int childState = 0;
        int totalWeight = 0;
        int weightViewLen = 0;
        int nonWeightViewHeight = 0;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = this.getPriorityChildAt(i);
            IView child = (IView)((Object)component);
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, usedHeight);
            int childHeight = child.getMeasuredHeight();
            usedHeight = Math.max(usedHeight, childHeight + usedHeight + lp.topMargin + lp.bottomMargin);
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = MeasureUtil.combineMeasuredStates(childState, MeasureUtil.getMeasuredState(child.getMeasuredWidth(), child.getMeasuredHeight()));
            nonWeightViewHeight += lp.topMargin + lp.bottomMargin;
            if (lp.weight > 0 && lp.height < 0) {
                totalWeight += lp.weight;
                ++weightViewLen;
                continue;
            }
            nonWeightViewHeight += childHeight;
        }
        usedHeight += mPaddingTop + mPaddingBottom;
        usedHeight = Math.max(usedHeight, this.getSuggestedMinimumHeight());
        int maxChildWidth = maxWidth;
        maxWidth += mPaddingLeft + mPaddingRight;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        int measuredHeight = MeasureUtil.resolveSizeAndState(usedHeight, heightMeasureSpec, 0);
        this.setMeasuredDimension(MeasureUtil.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), measuredHeight);
        if (weightViewLen <= 1) {
            return;
        }
        int mh = this.getMeasuredHeight() - nonWeightViewHeight - mPaddingTop - mPaddingBottom;
        if (mh <= 0) {
            return;
        }
        float piece = (float)mh / (float)totalWeight;
        for (int i = 0; i < count; ++i) {
            Component component = this.getPriorityChildAt(i);
            IView child = (IView)((Object)component);
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp.weight <= 0 || lp.height >= 0) continue;
            int h = (int)(piece * (float)lp.weight);
            h = Math.max(h, child.getMinHeight());
            h = Math.min(h, child.getMaxHeight());
            child.measure(MeasureUtil.getChildMeasureSpec(widthMeasureSpec, mPaddingLeft + mPaddingRight + lp.leftMargin + lp.rightMargin, lp.width), MeasureSpec.makeMeasureSpec(h, 0x40000000));
            maxChildWidth = Math.max(maxChildWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        }
        this.setMeasuredDimension(MeasureUtil.resolveSizeAndState(maxChildWidth += mPaddingLeft + mPaddingRight, widthMeasureSpec, 0), measuredHeight);
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int usedWidth = 0;
        int mPaddingTop = this.getPaddingTop();
        int mPaddingBottom = this.getPaddingBottom();
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int maxHeight = 0;
        int childState = 0;
        int totalWeight = 0;
        int weightViewLen = 0;
        int nonWeightViewWidth = 0;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = this.getPriorityChildAt(i);
            IView child = (IView)((Object)component);
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            this.measureChildBeforeLayout(child, i, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
            int childWidth = child.getMeasuredWidth();
            usedWidth = Math.max(usedWidth, childWidth + usedWidth + lp.leftMargin + lp.rightMargin);
            int margin = lp.topMargin + lp.bottomMargin;
            int measuredHeight = child.getMeasuredHeight() + margin;
            maxHeight = Math.max(maxHeight, measuredHeight);
            childState = MeasureUtil.combineMeasuredStates(childState, MeasureUtil.getMeasuredState(child.getMeasuredWidth(), child.getMeasuredHeight()));
            nonWeightViewWidth += lp.leftMargin + lp.rightMargin;
            if (lp.weight > 0 && lp.width < 0) {
                totalWeight += lp.weight;
                ++weightViewLen;
                continue;
            }
            nonWeightViewWidth += childWidth;
        }
        usedWidth += mPaddingLeft + mPaddingRight;
        usedWidth = Math.max(usedWidth, this.getSuggestedMinimumWidth());
        int maxChildHeight = maxHeight;
        maxHeight += mPaddingTop + mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        int measuredWidth = MeasureUtil.resolveSizeAndState(usedWidth, widthMeasureSpec, 0);
        this.setMeasuredDimension(measuredWidth, MeasureUtil.resolveSizeAndState(maxHeight, heightMeasureSpec, childState));
        if (weightViewLen <= 1) {
            return;
        }
        int mw = this.getMeasuredWidth() - nonWeightViewWidth - mPaddingLeft - mPaddingRight;
        if (mw <= 0) {
            return;
        }
        float piece = (float)mw / (float)totalWeight;
        for (int i = 0; i < count; ++i) {
            Component component = this.getPriorityChildAt(i);
            IView child = (IView)((Object)component);
            if (child == null || child.getVisibility() == 2) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp.weight <= 0 || lp.width >= 0) continue;
            int w = (int)(piece * (float)lp.weight);
            w = Math.max(w, child.getMinWidth());
            w = Math.min(w, child.getMaxWidth());
            child.measure(MeasureSpec.makeMeasureSpec(w, 0x40000000), MeasureUtil.getChildMeasureSpec(heightMeasureSpec, mPaddingTop + mPaddingBottom + lp.topMargin + lp.bottomMargin, lp.height));
            maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        }
        this.setMeasuredDimension(measuredWidth, MeasureUtil.resolveSizeAndState(maxChildHeight += mPaddingTop + mPaddingBottom, heightMeasureSpec, 0));
    }

    void measureChildBeforeLayout(IView child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private int getSpec(int src, int max2) {
        int mode = MeasureSpec.getMode(src);
        if (mode == 0x40000000) {
            return src;
        }
        int size = MeasureSpec.getSize(src);
        if (size > max2) {
            return MeasureSpec.makeMeasureSpec(max2, mode);
        }
        return src;
    }

    @Override
    protected void onLayout() {
        int maxWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int maxHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mOrientation == 0) {
            this.moveHorizontalComponents(this, maxWidth, maxHeight, 0, this.getComponentCount());
        } else {
            this.moveVerticalComponents(this, maxWidth, maxHeight, 0, this.getComponentCount());
        }
    }

    private void moveHorizontalComponents(Container container, int width, int height, int rowStart, int rowEnd) {
        IView target = (IView)((Object)container);
        int paddingTop = target.getPaddingTop();
        int x = target.getPaddingLeft();
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = container.getComponents()[i];
            IView childLayout = (IView)((Object)m);
            if (childLayout.getVisibility() != 2) {
                int cy;
                ViewGroup.LayoutParams childLayoutParams = ((IView)((Object)m)).getLayoutParams();
                if (childLayoutParams.gravity == -1) {
                    childLayoutParams.gravity = 48;
                }
                int childHeight = ((IView)((Object)m)).getMeasuredHeight();
                switch (childLayoutParams.gravity & 0x70) {
                    case 16: {
                        cy = height / 2 + childLayoutParams.topMargin - childHeight / 2 + paddingTop;
                        break;
                    }
                    case 80: {
                        cy = height - childLayout.getMeasuredHeight() - childLayoutParams.bottomMargin + paddingTop;
                        break;
                    }
                    default: {
                        cy = childLayoutParams.topMargin + paddingTop;
                    }
                }
                childLayout.layout(x += childLayoutParams.leftMargin, cy, childLayout.getMeasuredWidth(), childLayout.getMeasuredHeight());
                x += m.getWidth() + childLayoutParams.rightMargin;
                continue;
            }
            m.setSize(new Dimension(0, 0));
        }
    }

    public void moveVerticalComponents(Container container, int width, int height, int rowStart, int rowEnd) {
        IView target = (IView)((Object)container);
        int paddingLeft = target.getPaddingLeft();
        int y = target.getPaddingTop();
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = container.getComponents()[i];
            IView childLayout = (IView)((Object)m);
            int childWidth = childLayout.getMeasuredWidth();
            if (childLayout.getVisibility() != 2) {
                int cx;
                ViewGroup.LayoutParams childLayoutParams = ((IView)((Object)m)).getLayoutParams();
                if (childLayoutParams.gravity == -1) {
                    childLayoutParams.gravity = 3;
                }
                int absoluteGravity = Gravity.getAbsoluteGravity(childLayoutParams.gravity, 0);
                switch (absoluteGravity & 7) {
                    case 5: {
                        cx = width - childLayoutParams.rightMargin - childWidth + paddingLeft;
                        break;
                    }
                    case 1: {
                        cx = width / 2 + childLayoutParams.leftMargin - childWidth / 2 + paddingLeft;
                        break;
                    }
                    default: {
                        cx = childLayoutParams.leftMargin + paddingLeft;
                    }
                }
                childLayout.layout(cx, y += childLayoutParams.topMargin, childLayout.getMeasuredWidth(), childLayout.getMeasuredHeight());
                y += m.getHeight() + childLayoutParams.bottomMargin;
                continue;
            }
            m.setSize(new Dimension(0, 0));
        }
    }

    public void reAddByPriority() {
        this.children = this.getComponents();
        this.childCount = this.getComponentCount();
        Arrays.sort(this.children, Comparator.comparingInt(o -> -((IView)((Object)o)).getLayoutParams().priority));
    }

    protected Component getPriorityChildAt(int index) {
        return this.childCount > index ? this.children[index] : null;
    }

    @Override
    public String getLuaClassName() {
        return "LinearLayout";
    }

    @Override
    public Component add(Component comp) {
        return super.add(comp);
    }
}

