/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.constants.BreakMode;
import com.immomo.mlservics.constants.FontStyle;
import com.immomo.mlservics.constants.TextAlign;
import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.ViewWrapper;
import com.immomo.mlservics.weight.interfaces.IAlphaView;
import com.immomo.mlservics.weight.interfaces.ILabel;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.interfaces.ViewParent;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.RoundClipHelper;
import com.immomo.mmpaas.code.generator.LabelGenerator;
import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;

public class Label
extends JLabel
implements IView,
ILabel,
ViewParent,
IAlphaView {
    public static final int DEFAULT_FONT_SIZE = 16;
    public static final int DEFAULT_FONT_STYLE = 0;
    private static final String mFontName = "Default";
    public static final int DEFAULT_LINES = 0;
    public static final float DEFAULT_LINE_SPACE = 0.0f;
    public static final int DEFAULT_BREAK_MODE = 1;
    public static final int DEFAULT_TEXT_ALIGN = 19;
    private int mFontSize = 16;
    private int mFontStyle = 0;
    private int mLines = 0;
    private int contentLines = 0;
    public static final int MULTIPLE_LINES = 0;
    private float mLineSpacing = 0.0f;
    private int mBreakMode = 1;
    private int mTextAlign = 19;
    private ViewWrapper mViewWrapper;
    private String mContent = "";
    private LabelGenerator mLabelGenerator = new LabelGenerator();

    public Label() {
        this.mViewWrapper = new ViewWrapper(this, this.mLabelGenerator);
    }

    @Override
    public ViewWrapper getViewWrapper() {
        return this.mViewWrapper;
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    @Override
    public String getLuaClassName() {
        return "Label";
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mViewWrapper.setLayoutParams(layoutParams);
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mViewWrapper.getLayoutParams();
    }

    @Override
    public int getPaddingLeft() {
        return this.mViewWrapper.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        return this.mViewWrapper.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.mViewWrapper.getPaddingBottom();
    }

    @Override
    public int getPaddingRight() {
        return this.mViewWrapper.getPaddingRight();
    }

    @Override
    public int getMaxWidth() {
        return this.mViewWrapper.getMaxWidth();
    }

    @Override
    public int getMaxHeight() {
        return this.mViewWrapper.getMaxHeight();
    }

    @Override
    public int getMinWidth() {
        return this.mViewWrapper.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        return this.mViewWrapper.getMinHeight();
    }

    @Override
    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        char[] chars = this.mContent.toCharArray();
        int widthLimit = widthMode == Integer.MIN_VALUE ? widthSize + this.getPaddingLeft() + this.getPaddingRight() : Integer.MAX_VALUE;
        int heightLimit = heightMode == Integer.MIN_VALUE ? heightSize + this.getPaddingTop() + this.getPaddingBottom() : Integer.MAX_VALUE;
        int width = widthMode == 0x40000000 ? widthSize : fontMetrics.charsWidth(chars, 0, chars.length) + this.getPaddingLeft() + this.getPaddingRight();
        this.contentLines = this.getContentLines(width, widthLimit, chars, fontMetrics);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            int lines = this.getContentLines(width, widthLimit, chars, fontMetrics);
            int maxLines = this.mLines == 0 ? lines : Math.min(lines, this.mLines);
            height = (int)((float)(fontMetrics.getHeight() * maxLines) + this.mLineSpacing * (float)(maxLines - 1)) + this.getPaddingTop() + this.getPaddingBottom();
        }
        width = Math.min(width, widthLimit);
        height = Math.min(height, heightLimit);
        this.mViewWrapper.setMeasureDimension(width, height);
        if (this.mContent == null || this.mContent.equals("")) {
            return;
        }
        if (this.mContent.startsWith("<html>") && this.mContent.endsWith("</html>")) {
            super.setText(this.mContent);
            return;
        }
        String breakContent = this.handleBreakMode(this.mContent);
        String realContent = this.getContent(this, breakContent);
        super.setText(realContent);
    }

    private int getContentLines(int width, int widthLimit, char[] contents, FontMetrics fontMetrics) {
        float minWidth = Math.min(width, widthLimit);
        float epsilon = 1.0E-8f;
        int lines = Math.abs((double)minWidth - 0.0) < (double)epsilon ? this.mContent.length() : (int)Math.ceil((float)fontMetrics.charsWidth(contents, 0, contents.length) / minWidth);
        this.contentLines = lines;
        return lines;
    }

    private String handleBreakMode(String content) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String ellipsis = "...";
        float ellipsisWidth = fontMetrics.charsWidth(ellipsis.toCharArray(), 0, ellipsis.length());
        char[] chars = content.toCharArray();
        int lenIndex = chars.length - 1;
        if ((this.mLines > 1 || this.mLines == 0) && this.mBreakMode != 1) {
            return content;
        }
        if (fontMetrics.charsWidth(chars, 0, chars.length) < this.getWidth()) {
            return content;
        }
        int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        switch (this.mBreakMode) {
            case 3: {
                int lineEnd = this.getFirstLineEnd(content);
                if (lineEnd < chars.length && this.mLines == 1) {
                    float w;
                    int left;
                    float w2;
                    int right;
                    float ravail = ((float)width - ellipsisWidth) / 2.0f;
                    for (right = content.length() - 1; right > 0 && !((w2 = (float)fontMetrics.charsWidth(chars, right, content.length() - right)) > ravail); --right) {
                    }
                    float lavail = (float)width - ellipsisWidth - (float)fontMetrics.charsWidth(chars, right + 1, content.length() - right - 1);
                    for (left = 0; left < right && !((w = (float)fontMetrics.charsWidth(chars, 0, left)) > lavail); ++left) {
                    }
                    return content.substring(0, left - 1) + ellipsis + content.substring(right + 1);
                }
                return content;
            }
            case 2: {
                if (this.getFirstLineEnd(content) < chars.length && this.mLines == 1) {
                    float w;
                    int ellipsisStart;
                    for (ellipsisStart = content.length() - 1; ellipsisStart > 0 && !((w = (float)fontMetrics.charsWidth(chars, ellipsisStart, content.length() - ellipsisStart)) + ellipsisWidth > (float)width); --ellipsisStart) {
                    }
                    return ellipsis + content.substring(ellipsisStart + 1);
                }
                return content;
            }
            case 1: {
                float w;
                int ellipsisStart;
                int tailLineStart = this.getLastLineStart(content);
                if (fontMetrics.charsWidth(chars, tailLineStart, chars.length - tailLineStart) <= width) {
                    return content;
                }
                for (ellipsisStart = 0; ellipsisStart <= lenIndex && !((w = (float)fontMetrics.charsWidth(chars, tailLineStart, ellipsisStart)) + ellipsisWidth > (float)width); ++ellipsisStart) {
                }
                return content.substring(0, tailLineStart + ellipsisStart - 1) + ellipsis;
            }
        }
        return content;
    }

    private int getFirstLineEnd(String content) {
        int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int firstLineStart = 0;
        char[] chars = content.toCharArray();
        for (int start = 0; start < chars.length; ++start) {
            if (fontMetrics.charsWidth(chars, 0, start) <= width) continue;
            firstLineStart = start;
            break;
        }
        return firstLineStart;
    }

    private int getLastLineStart(String content) {
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        char[] chars = content.toCharArray();
        int start = 0;
        int len2 = 0;
        int lines = 0;
        if (fontMetrics.charsWidth(chars, 0, 1) > width) {
            start = chars.length - 1;
        }
        while (start + len2 < content.length()) {
            while (start + ++len2 <= content.length()) {
                if (fontMetrics.charsWidth(chars, start, len2) <= width) continue;
                ++lines;
                break;
            }
            if (this.toLimitLines(lines)) break;
            start = start + len2 - 1;
            len2 = 0;
        }
        return start;
    }

    private boolean toLimitLines(int lines) {
        int limitLines = this.mLines == 0 ? this.contentLines : Math.min(this.contentLines, this.mLines);
        return lines >= limitLines;
    }

    private String getContent(JLabel jLabel, String text) {
        char[] chars = text.toCharArray();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int width = this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft();
        if (fontMetrics.charsWidth(chars, 0, text.length()) <= width) {
            return text;
        }
        StringBuilder builder = new StringBuilder("<html>");
        int start = 0;
        int len2 = 0;
        int lines = 0;
        while (start + len2 < text.length()) {
            while (start + ++len2 <= text.length()) {
                if (fontMetrics.charsWidth(chars, start, len2) <= this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft()) continue;
                ++lines;
                break;
            }
            builder.append(chars, start, len2 - 1).append("<p style='margin-top:").append(this.mLineSpacing).append("'>");
            if (this.toLimitLines(lines)) break;
            start = start + len2 - 1;
            len2 = 0;
        }
        if (lines < this.mLines && start < text.length()) {
            builder.append(chars, start, text.length() - start);
        }
        builder.append("</html>");
        return builder.toString();
    }

    @Override
    public int getMeasuredWidth() {
        return this.mViewWrapper.mMeasuredWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.mViewWrapper.mMeasuredHeight;
    }

    @Override
    public int getVisibility() {
        return this.mViewWrapper.getVisibility();
    }

    @Override
    public void setVisibility(int visibility) {
        this.mViewWrapper.setVisibility(visibility);
    }

    @Override
    public void setWidth(double width) {
        this.mViewWrapper.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        this.mViewWrapper.setHeight(height);
    }

    @Override
    public void setMaxWidth(double maxWidth) {
        this.mViewWrapper.setMaxWidth(maxWidth);
    }

    @Override
    public void setMaxHeight(double maxHeight) {
        this.mViewWrapper.setMaxHeight(maxHeight);
    }

    @Override
    public void setMinWidth(double minWidth) {
        this.mViewWrapper.setMinWidth(minWidth);
    }

    @Override
    public void setMinHeight(double minHeight) {
        this.mViewWrapper.setMinHeight(minHeight);
    }

    @Override
    public void setMarginLeft(double left) {
        this.mViewWrapper.setMarginLeft(left);
    }

    @Override
    public void setMarginRight(double right) {
        this.mViewWrapper.setMarginRight(right);
    }

    @Override
    public void setMarginBottom(double bottom) {
        this.mViewWrapper.setMarginBottom(bottom);
    }

    @Override
    public void setMarginTop(double top) {
        this.mViewWrapper.setMarginTop(top);
    }

    @Override
    public void setGravity(int gravity) {
        this.mViewWrapper.setGravity(gravity);
    }

    @Override
    public void setPadding(double left, double top, double right, double bottom) {
        this.mViewWrapper.setPadding(left, top, right, bottom);
    }

    @Override
    public void setBgColor(Color color) {
        this.mViewWrapper.setBgColor(color);
    }

    @Override
    public void setPriority(int priority) {
        this.mViewWrapper.setPriority(priority);
    }

    @Override
    public void setWeight(int weight) {
        this.mViewWrapper.setWeight(weight);
    }

    @Override
    public void setAlpha(float alpha) {
        this.mViewWrapper.setAlpha(alpha);
    }

    @Override
    public float getAlpha() {
        return this.mViewWrapper.getAlpha();
    }

    @Override
    public int getBorderWidth() {
        return this.mViewWrapper.getBorderWidth();
    }

    @Override
    public Color getBorderColor() {
        return this.mViewWrapper.getBorderColor();
    }

    @Override
    public Color getBgColor() {
        return this.mViewWrapper.getBgColor();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container p = this.getParent();
        if (p instanceof IAlphaView) {
            this.mViewWrapper.setPaintAlpha(((IAlphaView)((Object)p)).getPaintAlpha());
        } else {
            this.mViewWrapper.setPaintAlpha(1.0f);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mViewWrapper.canClip()) {
            RoundClipHelper.clip(g, this.mViewWrapper.radius, this.getWidth(), this.getHeight());
        }
        if (this.mViewWrapper.canDrawBackground()) {
            this.mViewWrapper.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite cmp = AlphaComposite.getInstance(3, 1.0f);
            g2d.setComposite(cmp.derive(this.mViewWrapper.getPaintAlpha()));
        }
        super.paintComponent(g);
        this.mViewWrapper.getBorderHelper().draw(g, this);
        this.mViewWrapper.paintMask(g);
    }

    @Override
    public void setBgImage(String icon) {
        this.mViewWrapper.setBgImage(icon);
    }

    @Override
    public void setBorderWidth(double width) {
        this.mViewWrapper.setBorderWidth(width);
    }

    @Override
    public void setBorderColor(Color color) {
        this.mViewWrapper.setBorderColor(color);
    }

    @MyAnnotation(ofView="0Label", desc="02000\u6587\u672c", getterNames={"getLabelText"})
    public void setLabelText(String text) {
        this.mContent = text;
        this.mLabelGenerator.addText(text);
        this.requestLayout();
    }

    @Override
    public void reDraw() {
        this.mViewWrapper.reDraw();
    }

    public String getLabelText() {
        return this.mContent;
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02001\u5b57\u4f53\u5927\u5c0f", getterNames={"getFontSize"})
    public void setTextSize(int size) {
        this.mFontSize = size;
        super.setFont(new Font(mFontName, this.getFontStyle(this.mFontStyle), DimenUtil.spToPx(this.mFontSize)));
        this.mLabelGenerator.addTextSize(size);
        this.requestLayout();
    }

    public int getFontSize() {
        return this.mFontSize;
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02002\u6587\u5b57\u989c\u8272", getterNames={"getForeground"})
    public void setTextColor(Color color) {
        super.setForeground(color);
        this.mLabelGenerator.addTextColor(color);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02003\u5b57\u4f53\u6837\u5f0f", getterNames={"getTextFontStyle(FontStyle)"}, enumClass=FontStyle.class)
    public void setTextFontStyle(int fontStyle) {
        this.mFontStyle = fontStyle;
        super.setFont(new Font(mFontName, this.getFontStyle(this.mFontStyle), DimenUtil.spToPx(this.mFontSize)));
        this.mLabelGenerator.addTextFontStyle(fontStyle);
        this.requestLayout();
    }

    private int getFontStyle(int mFontStyle) {
        switch (mFontStyle) {
            case 2: {
                mFontStyle = 1;
                break;
            }
            case 1: {
                mFontStyle = 2;
                break;
            }
            case 3: {
                mFontStyle = 3;
                break;
            }
            default: {
                mFontStyle = 0;
            }
        }
        return mFontStyle;
    }

    public int getTextFontStyle() {
        return this.mFontStyle;
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02004\u5bf9\u9f50\u65b9\u5f0f", getterNames={"getTextAlign(TextAlign)"}, enumClass=TextAlign.class)
    public void setTextAlign(int textAlign) {
        this.mTextAlign = textAlign;
        switch (textAlign) {
            case 19: {
                super.setHorizontalAlignment(2);
                break;
            }
            case 21: {
                super.setHorizontalAlignment(4);
                break;
            }
            case 17: {
                super.setHorizontalAlignment(0);
            }
        }
        this.mLabelGenerator.addTextAlign(textAlign);
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02005\u6700\u5927\u884c\u6570", getterNames={"getLines"})
    public void setLines(int lines) {
        this.mLines = lines;
        this.mLabelGenerator.addLines(lines);
        this.requestLayout();
    }

    public int getLines() {
        if (this.mLines == 0) {
            return 0;
        }
        return this.mLines;
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02006\u884c\u95f4\u8ddd", getterNames={"getLineSpacing"})
    public void setLineSpacing(float spacing) {
        this.mLineSpacing = spacing;
        this.mLabelGenerator.addLineSpacing(spacing);
        this.requestLayout();
    }

    public float getLineSpacing() {
        return this.mLineSpacing;
    }

    @Override
    @MyAnnotation(ofView="0Label", desc="02007\u622a\u65ad\u6837\u5f0f", getterNames={"getBreakMode(BreakMode)"}, enumClass=BreakMode.class)
    public void setBreakMode(int breakMode) {
        this.mBreakMode = breakMode;
        this.mLabelGenerator.addBreakMode(breakMode);
        this.requestLayout();
    }

    public int getBreakMode() {
        return this.mBreakMode;
    }

    @Override
    public void addCornerMask(double borderWidth, Color color, int rectCorner) {
        this.mViewWrapper.addCornerMask(borderWidth, color, rectCorner);
    }

    @Override
    public void setCornerRadiusWithDirection(double r, int rectCorner) {
        this.mViewWrapper.setCornerRadiusWithDirection(r, rectCorner);
    }

    @Override
    public void setGradientColorWithDirection(Color s, Color e, int type2) {
        this.mViewWrapper.setGradientColorWithDirection(s, e, type2);
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        this.mViewWrapper.layout(x, y);
    }

    @Override
    public void setShadow(double x, double y, double r, float alpha) {
        this.mViewWrapper.setShadow(x, y, r, alpha);
    }

    @Override
    public void overlay(UDBaseView overView) {
        if (overView != null) {
            Object overlay = overView.getView();
            this.add((Component)overlay);
            this.mViewWrapper.overlay(overView);
        }
    }

    @Override
    public void requestLayout() {
        this.mViewWrapper.requestLayout();
    }

    @Override
    public void setPaintAlpha(float a) {
        this.mViewWrapper.setPaintAlpha(a);
    }

    @Override
    public float getPaintAlpha() {
        return this.mViewWrapper.getPaintAlpha();
    }
}

