/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.other.Gravity;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.MeasureUtil;
import com.immomo.mmpaas.utils.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;

public class FrameLayout
extends ViewGroup {
    public static final int DEFAULT_CHILD_GRAVITY = 3;
    private final ArrayList<Component> mMatchParentChildren = new ArrayList(1);
    boolean mMeasureAllChildren = false;

    @Override
    public Component getComponent(int n) {
        Component[] components = this.getComponents();
        return components[this.getComponents().length - n - 1];
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        int count = this.getComponentCount();
        boolean measureMatchParentChildren = MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            Component component = this.getComponents()[i];
            IView child = (IView)((Object)component);
            if (!this.mMeasureAllChildren && child.getVisibility() == 2) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = MeasureUtil.combineMeasuredStates(childState, MeasureUtil.getMeasuredState(child.getMeasuredWidth(), child.getMeasuredHeight()));
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(component);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(MeasureUtil.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), MeasureUtil.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                IView child = (IView)((Object)this.mMatchParentChildren.get(i));
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - child.getPaddingLeft() - child.getPaddingRight() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(width, 0x40000000);
                } else {
                    childWidthMeasureSpec = MeasureUtil.getChildMeasureSpec(widthMeasureSpec, child.getPaddingLeft() - child.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(height, 0x40000000);
                } else {
                    childHeightMeasureSpec = MeasureUtil.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin, lp.height);
                }
                Log.e("heightMeasureSpec:" + widthMeasureSpec + "widthMeasureSpec" + heightMeasureSpec, new Object[0]);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    protected void onLayout() {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int parentWidth = this.getMeasuredWidth() - paddingLeft - paddingRight;
        int parentHeight = this.getMeasuredHeight() - paddingBottom - paddingTop;
        for (Component childComponent : this.getComponents()) {
            IView child = (IView)((Object)childComponent);
            if (child.getVisibility() != 2) {
                if (child.getLayoutParams().gravity == -1) {
                    child.getLayoutParams().gravity = 3;
                }
                int x = 0;
                int y = 0;
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                int absoluteGravity = Gravity.getAbsoluteGravity(child.getLayoutParams().gravity, 0);
                int verticalGravity = child.getLayoutParams().gravity & 0x70;
                switch (absoluteGravity & 7) {
                    case 1: {
                        x = parentWidth / 2 + paddingLeft + child.getLayoutParams().leftMargin - childWidth / 2;
                        break;
                    }
                    case 5: {
                        x = parentWidth - child.getLayoutParams().rightMargin - childWidth + paddingLeft;
                        break;
                    }
                    default: {
                        x = child.getLayoutParams().leftMargin + paddingLeft;
                    }
                }
                switch (verticalGravity) {
                    case 80: {
                        y = parentHeight - childHeight - child.getLayoutParams().bottomMargin + paddingTop;
                        break;
                    }
                    case 16: {
                        y = parentHeight / 2 + child.getLayoutParams().topMargin - childHeight / 2 + paddingTop;
                        break;
                    }
                    default: {
                        y = child.getLayoutParams().topMargin + paddingTop;
                    }
                }
                child.layout(x, y, child.getMeasuredWidth(), child.getMeasuredHeight());
                continue;
            }
            Log.e("xxx", new Object[0]);
            childComponent.setSize(new Dimension(0, 0));
        }
    }

    @Override
    public String getLuaClassName() {
        return "View";
    }
}

