/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.constants.EditTextViewInputMode;
import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.ViewWrapper;
import com.immomo.mlservics.weight.interfaces.IAlphaView;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mlservics.weight.interfaces.ViewParent;
import com.immomo.mlservics.weight.other.MeasureSpec;
import com.immomo.mlservics.weight.utils.RoundClipHelper;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.code.generator.EditViewGenerator;
import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.UnsupportedEncodingException;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EditTextView
extends JTextArea
implements IView,
ViewParent,
IAlphaView {
    public static final boolean DEFAULT_IS_SINGLE = false;
    public static final boolean DEFAULT_PASSWORD_MODE = false;
    public static final int DEFAULT_INPUT_MODE = 1;
    public static final boolean DEFAULT_IS_EDITABLE = true;
    public static final int DEFAULT_FONT_SIZE = 16;
    public static final Color DEFAULT_FONT_COLOR = Theme.dark.darkTextColor;
    private boolean mIsSingleLine = false;
    private boolean mIsPasswordMode = false;
    private int inputMode = 1;
    private int maxLength = Integer.MAX_VALUE;
    private String mPlaceholder = "";
    private Color placeholderColor = DEFAULT_FONT_COLOR;
    private int mMaxBytes = Integer.MAX_VALUE;
    private ViewWrapper mViewWrapper;
    private EditViewGenerator generator;
    private static final String PASSWORD_FLAG = "*";
    private String editText = "";
    private Color editTextColor = this.getForeground();
    private int fontSize = 16;

    public EditTextView() {
        this.generator = new EditViewGenerator();
        this.mViewWrapper = new ViewWrapper(this, this.generator);
        this.setFontSize(16);
        this.updateDocument();
    }

    public int getTextSize() {
        return this.fontSize;
    }

    @Override
    public ViewWrapper getViewWrapper() {
        return this.mViewWrapper;
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        this.mViewWrapper.layout(x, y);
    }

    @MyAnnotation(ofView="0EditTextView", desc="02006\u5355\u884c\u6a21\u5f0f", getterNames={"getSingleLine"})
    public void setSingleLine(boolean isSingleLine) {
        this.mIsSingleLine = isSingleLine;
        this.generator.addSingleLine(isSingleLine);
        if (isSingleLine) {
            this.setRows(1);
        } else {
            this.setRows(Integer.MAX_VALUE);
        }
        this.requestLayout();
    }

    private boolean getSingleLine() {
        return this.getRows() == 1;
    }

    @Override
    public void setPriority(int priority) {
        this.mViewWrapper.setPriority(priority);
    }

    @Override
    public void setWeight(int weight) {
        this.mViewWrapper.setWeight(weight);
    }

    @MyAnnotation(ofView="0EditTextView", desc="02000\u5360\u4f4d\u6587\u5b57", getterNames={"getPlaceholder"})
    public void setPlaceholder(String placeholder) {
        this.nullCheck(placeholder);
        this.generator.addPlaceholder(placeholder);
        this.mPlaceholder = placeholder;
        this.updateContentMode();
        this.requestLayout();
    }

    @Override
    @MyAnnotation(ofView="0EditTextView", desc="02012\u5185\u5bb9", getterNames={"getText"})
    public void setText(String text) {
        this.generator.addText(text);
        this.nullCheck(text);
        this.setForeground(this.editTextColor);
        this.editText = text;
        this.updateContentMode();
        this.requestLayout();
    }

    private void updateContentMode() {
        if (this.editText.length() > 0) {
            this.setForeground(this.editTextColor);
            super.setText(this.editText);
            if (!this.mIsPasswordMode) {
                this.editText = super.getText();
            }
        } else {
            this.setForeground(this.placeholderColor);
            super.setText(this.mPlaceholder);
        }
    }

    @Override
    public String getText() {
        return this.editText;
    }

    @MyAnnotation(ofView="0EditTextView", desc="02010\u6587\u5b57\u989c\u8272", getterNames={"getTextColor"})
    public void setTextColor(Color color) {
        this.nullCheck(color);
        this.editTextColor = color;
        this.updateContentMode();
        this.generator.addFontColor(color);
        this.reDraw();
    }

    @MyAnnotation(ofView="0EditTextView", desc="02011\u6587\u5b57\u5927\u5c0f", getterNames={"getTextSize"})
    public void setFontSize(int size) {
        this.fontSize = size;
        Font originFont = this.getFont();
        Font newFont = new Font(originFont.getName(), originFont.getStyle(), DimenUtil.spToPx(size));
        this.setFont(newFont);
        this.generator.addFontSize(size);
        this.requestLayout();
    }

    public Color getTextColor() {
        return this.editTextColor;
    }

    private void updateDocument() {
        this.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
                int nextCharacterBytes;
                String nextCharacter;
                int i;
                if (s == null || offset < 0) {
                    return;
                }
                int totalBytes = 0;
                String finalString = "";
                for (i = 0; i < s.length() && !EditTextView.this.toStringEnd(nextCharacter = EditTextView.substring(s, i, i + 1), nextCharacterBytes = EditTextView.this.getBytes(nextCharacter)) && !EditTextView.this.outOfMaxBytes(nextCharacterBytes, totalBytes) && finalString.length() <= EditTextView.this.maxLength - 1; ++i) {
                    finalString = finalString + nextCharacter;
                    totalBytes += nextCharacterBytes;
                }
                if (EditTextView.this.mIsPasswordMode && EditTextView.this.editText.length() > 0) {
                    for (i = 0; i < finalString.length(); ++i) {
                        super.insertString(offset + i, EditTextView.PASSWORD_FLAG, attributeSet);
                    }
                    if (EditTextView.this.editText.equals(finalString)) {
                        EditTextView.this.editText = finalString;
                    }
                } else {
                    super.insertString(offset, finalString, attributeSet);
                }
            }
        });
    }

    public String getPlaceholder() {
        return this.mPlaceholder;
    }

    @MyAnnotation(ofView="0EditTextView", desc="02001\u5360\u4f4d\u6587\u5b57\u989c\u8272", getterNames={"getPlaceholderColor"})
    public void setPlaceholderColor(Color color) {
        this.nullCheck(color);
        this.generator.addPlaceholderColor(color);
        this.placeholderColor = color;
        this.updateContentMode();
        this.reDraw();
    }

    @Override
    public void reDraw() {
        this.mViewWrapper.reDraw();
    }

    public Color getPlaceholderColor() {
        return this.placeholderColor;
    }

    @MyAnnotation(ofView="0EditTextView", desc="02004\u5149\u6807\u989c\u8272", getterNames={"getCaretColor"})
    public void setCursorColor(Color color) {
        this.nullCheck(color);
        this.setCaretColor(color);
        this.generator.addCursorColor(color);
        this.reDraw();
    }

    @MyAnnotation(ofView="0EditTextView", desc="02005\u662f\u5426\u7f16\u8f91", getterNames={"isEditable"})
    public void setCanEdit(boolean canEdit) {
        this.nullCheck(canEdit);
        this.setEditable(canEdit);
        this.generator.addEditEnable(canEdit);
        this.reDraw();
    }

    @MyAnnotation(ofView="0EditTextView", desc="02007\u6700\u5927\u5b57\u7b26\u6570", getterNames={"getMaxLength"})
    public void setMaxLength(int length) {
        this.nullCheck(length);
        this.generator.addMaxLength(length);
        this.maxLength = length;
        this.updateContentMode();
        this.requestLayout();
    }

    public int getMaxLength() {
        return this.maxLength >= 0 ? this.maxLength : 0;
    }

    @MyAnnotation(ofView="0EditTextView", desc="02008\u6700\u5927\u5b57\u8282\u6570", getterNames={"getMaxBytes"})
    public void setMaxBytes(int maxBytes) {
        this.nullCheck(maxBytes);
        if (maxBytes < 0) {
            return;
        }
        this.generator.addMaxBytes(maxBytes);
        if (this.mMaxBytes == maxBytes) {
            return;
        }
        this.mMaxBytes = maxBytes;
        this.updateContentMode();
        this.requestLayout();
    }

    private boolean toStringEnd(String nextCharacter, int nextCharacterBytes) {
        return nextCharacter.equals("") || nextCharacterBytes == 0;
    }

    private boolean outOfMaxBytes(int nextCharacterBytes, int totalBytes) {
        return totalBytes + nextCharacterBytes > this.mMaxBytes;
    }

    private int getBytes(String string) {
        try {
            return string.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String substring(String source, int start, int end) {
        String result;
        try {
            result = source.substring(source.offsetByCodePoints(0, start), source.offsetByCodePoints(0, end));
        }
        catch (Exception e) {
            result = "";
        }
        return result;
    }

    public int getMaxBytes() {
        return this.mMaxBytes >= 0 ? this.mMaxBytes : 0;
    }

    @MyAnnotation(ofView="0EditTextView", desc="02002\u8f93\u5165\u6a21\u5f0f", getterNames={"getInputMode(EditTextViewInputMode)"}, enumClass=EditTextViewInputMode.class)
    public void setInputMode(int mode) {
        this.inputMode = mode;
        this.generator.addInputMode(mode);
        this.requestLayout();
    }

    public int getInputMode() {
        return this.inputMode;
    }

    @Override
    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int mLines = Integer.MAX_VALUE;
        if (this.mIsSingleLine) {
            mLines = 1;
        }
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        String str = this.getText() != null && !this.getText().equals("") ? this.getText() : this.mPlaceholder;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        char[] chars = str.toCharArray();
        float widthLimit = widthMode == Integer.MIN_VALUE ? (float)widthSize : 2.1474836E9f;
        int width = widthMode == 0x40000000 ? widthSize : Math.min(fontMetrics.charsWidth(chars, 0, chars.length), (int)widthLimit) + this.getPaddingLeft() + this.getPaddingRight();
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            int lines = (int)Math.ceil((float)fontMetrics.charsWidth(chars, 0, chars.length) / widthLimit);
            int maxLines = Math.min(lines, mLines);
            height = fontMetrics.getHeight() * maxLines + this.getPaddingTop() + this.getPaddingBottom();
        }
        this.mViewWrapper.setMeasureDimension(width, height);
    }

    @MyAnnotation(ofView="0EditTextView", desc="02003\u5bc6\u7801\u6a21\u5f0f", getterNames={"getPasswordMode"})
    public void setPasswordMode(boolean isPasswordMode) {
        this.mIsPasswordMode = isPasswordMode;
        this.generator.addPasswordMode(isPasswordMode);
        this.updateContentMode();
        this.requestLayout();
    }

    public boolean getPasswordMode() {
        return this.mIsPasswordMode;
    }

    private void nullCheck(Object obj) {
        if (obj != null) {
            return;
        }
        throw new IllegalArgumentException("Parameter should not be null!");
    }

    private boolean isNoContent() {
        return this.getText() != null && this.getText().length() == 0;
    }

    @Override
    public String getLuaClassName() {
        return "EditTextView";
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mViewWrapper.setLayoutParams(layoutParams);
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mViewWrapper.getLayoutParams();
    }

    @Override
    public int getPaddingLeft() {
        return this.mViewWrapper.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        return this.mViewWrapper.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.mViewWrapper.getPaddingBottom();
    }

    @Override
    public int getPaddingRight() {
        return this.mViewWrapper.getPaddingRight();
    }

    @Override
    public int getMaxWidth() {
        return this.mViewWrapper.getMaxWidth();
    }

    @Override
    public int getMaxHeight() {
        return this.mViewWrapper.getMaxHeight();
    }

    @Override
    public int getMinWidth() {
        return this.mViewWrapper.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        return this.mViewWrapper.getMinHeight();
    }

    @Override
    public int getMeasuredWidth() {
        return this.mViewWrapper.mMeasuredWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.mViewWrapper.mMeasuredHeight;
    }

    @Override
    public int getVisibility() {
        return this.mViewWrapper.getVisibility();
    }

    @Override
    public void setWidth(double width) {
        this.mViewWrapper.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        this.mViewWrapper.setHeight(height);
    }

    @Override
    public void setMaxWidth(double maxWidth) {
        this.mViewWrapper.setMaxWidth(maxWidth);
    }

    @Override
    public void setMaxHeight(double maxHeight) {
        this.mViewWrapper.setMaxHeight(maxHeight);
    }

    @Override
    public void setMinWidth(double minWidth) {
        this.mViewWrapper.setMinWidth(minWidth);
    }

    @Override
    public void setMinHeight(double minHeight) {
        this.mViewWrapper.setMinHeight(minHeight);
    }

    @Override
    public void setMarginLeft(double left) {
        this.mViewWrapper.setMarginLeft(left);
    }

    @Override
    public void setMarginRight(double right) {
        this.mViewWrapper.setMarginRight(right);
    }

    @Override
    public void setMarginBottom(double bottom) {
        this.mViewWrapper.setMarginBottom(bottom);
    }

    @Override
    public void setMarginTop(double top) {
        this.mViewWrapper.setMarginTop(top);
    }

    @Override
    public void setGravity(int gravity) {
        this.mViewWrapper.setGravity(gravity);
    }

    @Override
    public void setPadding(double left, double top, double right, double bottom) {
        this.mViewWrapper.setPadding(left, top, right, bottom);
    }

    @Override
    public void setBorderWidth(double width) {
        this.mViewWrapper.setBorderWidth(width);
    }

    @Override
    public void setBorderColor(Color color) {
        this.mViewWrapper.setBorderColor(color);
    }

    @Override
    public void setVisibility(int visibility) {
        this.mViewWrapper.setVisibility(visibility);
    }

    @Override
    public void setBgColor(Color color) {
        this.mViewWrapper.setBgColor(color);
    }

    @Override
    public void setBgImage(String icon) {
        this.mViewWrapper.setBgImage(icon);
    }

    @Override
    public void setAlpha(float alpha) {
        this.mViewWrapper.setAlpha(alpha);
    }

    @Override
    public float getAlpha() {
        return this.mViewWrapper.getAlpha();
    }

    @Override
    public int getBorderWidth() {
        return this.mViewWrapper.getBorderWidth();
    }

    @Override
    public Color getBorderColor() {
        return this.mViewWrapper.getBorderColor();
    }

    @Override
    public Color getBgColor() {
        return this.mViewWrapper.getBgColor();
    }

    @Override
    public void addCornerMask(double borderWidth, Color color, int rectCorner) {
        this.mViewWrapper.addCornerMask(borderWidth, color, rectCorner);
    }

    @Override
    public void setCornerRadiusWithDirection(double r, int rectCorner) {
        this.mViewWrapper.setCornerRadiusWithDirection(r, rectCorner);
    }

    @Override
    public void setGradientColorWithDirection(Color s, Color e, int type2) {
        this.mViewWrapper.setGradientColorWithDirection(s, e, type2);
    }

    @Override
    public void setShadow(double x, double y, double r, float alpha) {
        this.mViewWrapper.setShadow(x, y, r, alpha);
    }

    @Override
    public void overlay(UDBaseView overView) {
        if (overView != null) {
            Object overlay = overView.getView();
            this.add((Component)overlay);
            this.mViewWrapper.overlay(overView);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container p = this.getParent();
        if (p instanceof IAlphaView) {
            this.mViewWrapper.setPaintAlpha(((IAlphaView)((Object)p)).getPaintAlpha());
        } else {
            this.mViewWrapper.setPaintAlpha(1.0f);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mViewWrapper.canClip()) {
            RoundClipHelper.clip(g, this.mViewWrapper.radius, this.getWidth(), this.getHeight());
        }
        if (this.mViewWrapper.canDrawBackground()) {
            this.mViewWrapper.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite cmp = AlphaComposite.getInstance(3, 1.0f);
            g2d.setComposite(cmp.derive(this.getPaintAlpha()));
        }
        super.paintComponent(g);
        this.mViewWrapper.getBorderHelper().draw(g, this);
        this.mViewWrapper.paintMask(g);
    }

    @Override
    public void requestLayout() {
        this.mViewWrapper.requestLayout();
    }

    @Override
    public void setPaintAlpha(float a) {
        this.mViewWrapper.setPaintAlpha(a);
    }

    @Override
    public float getPaintAlpha() {
        return this.mViewWrapper.getPaintAlpha();
    }
}

