/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.weight;

import com.immomo.mlservics.weight.utils.DrawImageHelper;
import com.immomo.mmpaas.utils.ImageLoader;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;

public class BaseImageView
extends JComponent
implements ImageLoader.OnImageLoadListener {
    public static final int DEFAULT_CONTENT_MODE = 0;
    protected Image image;
    protected String imageUrl = "";
    protected int contentMode = 0;

    @Override
    public void onLoad(String url, Image image) {
        if (this.imageUrl.equals(url)) {
            this.image = image;
            this.revalidate();
            this.repaint();
        }
    }

    public void setImage(String name) {
        this.imageUrl = name;
        this.image = ImageLoader.getInstance().loadProjectImage(name);
        if (this.image == null) {
            ImageLoader.getInstance().loadOnlineImage(name, this);
        } else {
            this.repaint();
        }
    }

    public void setContentMode(int mode) {
        if (this.contentMode == mode) {
            return;
        }
        this.contentMode = mode;
        this.repaint();
    }

    public String getImage() {
        return this.imageUrl;
    }

    public int getContentMode() {
        return this.contentMode;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            int imageW = this.image.getWidth(null);
            int imageH = this.image.getHeight(null);
            if (imageW <= 0 || imageH <= 0) {
                return;
            }
            DrawImageHelper.draw(g, this.image, this.contentMode, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    protected void super_paint(Graphics g) {
        super.paintComponent(g);
    }
}

