/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.utils;

import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.GlobalConfigManager;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.panel.devicetoolbar.bean.ScaleMessage;
import com.immomo.mmpaas.panel.devicetoolbar.bean.VirtualDevice;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;

public class RoomScalManager {
    private static final boolean logOpen = false;
    private boolean isMatchParent = true;
    private float sizeScale = 1.0f;
    private float dpiScale = 1.0f;
    private int containerWidth = 428;
    private int containerHeight = 730;
    private static final int minMarginHor = 30;
    private static final int minMarginVer = 50;
    private final Rectangle rect;
    private MouseAdapter mouseWheelListener = new MouseAdapter(){
        private int temp = 0;

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown() || e.isAltDown()) {
                float sizeScale = RoomScalManager.this.getSizeScale();
                int rotation = e.getWheelRotation();
                this.temp += rotation;
                if (Math.abs(this.temp) < 5 || rotation == 0) {
                    return;
                }
                this.temp = 0;
                if (rotation < 0) {
                    sizeScale += 0.15f;
                } else if (sizeScale - 0.15f > 0.0f) {
                    sizeScale -= 0.15f;
                }
                BroadCastManager.getManager().send(Application.getApplicationContext(), BroadCastMessage.obtain("BC_RESET_SCALE_UPDATE", new ScaleMessage(sizeScale, 3)));
            }
        }
    };

    public RoomScalManager() {
        this.rect = new Rectangle();
    }

    public float getSizeScale() {
        return this.sizeScale;
    }

    public RoomScalManager setSizeScale(float value) {
        this.sizeScale = value;
        return this;
    }

    public float getDpiScale() {
        return this.dpiScale;
    }

    public RoomScalManager setDpiScale(float dpiScale) {
        this.dpiScale = dpiScale;
        return this;
    }

    public MouseAdapter getMouseWheelListener() {
        return this.mouseWheelListener;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void setMatchParent(boolean matchParent) {
        this.isMatchParent = matchParent;
    }

    public boolean isMatchParent() {
        return this.isMatchParent;
    }

    public void build() {
        float scale = this.dpiScale * this.sizeScale;
        DimenUtil.init(scale, scale);
        DimenUtil.setSizeScale(this.sizeScale);
        BroadCastManager.getManager().send(Application.getApplicationContext(), BroadCastMessage.obtain("BC_SCALE_PHONE_UPDATE", Float.valueOf(this.sizeScale)));
    }

    public void processLuaContainerBounds(Dimension phoneSize, JComponent luaContainer) {
        VirtualDevice device = GlobalConfigManager.getInstance().getPreViewConfigBean().getDevice();
        int w = this.containerWidth;
        int h = this.containerHeight;
        if (device != null) {
            float dpi = device.getdpi();
            w = device.getWidth();
            h = device.getHeight();
            float deviceRatio = (float)w / (float)h;
            float scale = Math.round(dpi / 160.0f);
            this.containerWidth = phoneSize.width - 60;
            this.containerHeight = phoneSize.height - 100;
            this.containerWidth = this.containerWidth < 0 ? 0 : this.containerWidth;
            int n = this.containerHeight = this.containerHeight < 0 ? 0 : this.containerHeight;
            if (deviceRatio > (float)this.containerWidth / (float)this.containerHeight) {
                if (this.checkUseDragScale(false, device, luaContainer)) {
                    this.scaleDragVer(w, h, scale, deviceRatio, phoneSize);
                } else {
                    this.scaleSize(w, h, scale, phoneSize);
                }
            } else if (this.checkUseDragScale(true, device, luaContainer)) {
                this.scaleDragHor(w, h, scale, deviceRatio, phoneSize);
            } else {
                this.scaleSize(w, h, scale, phoneSize);
            }
            return;
        }
        this.rect.setSize(w, h);
    }

    private boolean checkUseDragScale(boolean isHor, VirtualDevice device, JComponent luaContainer) {
        if (luaContainer != null) {
            boolean result;
            Dimension oldSize = luaContainer.getSize();
            if (isHor) {
                boolean result2;
                boolean bl = result2 = oldSize.height < this.containerHeight || (float)device.getHeight() * this.sizeScale < (float)this.containerHeight;
                if (result2) {
                    this.isMatchParent = true;
                } else {
                    result2 = this.isMatchParent;
                }
                return result2;
            }
            boolean bl = result = oldSize.width < this.containerWidth || (float)device.getWidth() * this.sizeScale < (float)this.containerWidth;
            if (result) {
                this.isMatchParent = true;
            } else {
                result = this.isMatchParent;
            }
            return result;
        }
        return true;
    }

    private void scaleDragHor(int w, int h, float scale, float deviceRatio, Dimension phoneSize) {
        int finalHeight = this.containerHeight;
        int virtualWidth = Math.round((float)finalHeight * deviceRatio);
        float virtualDeviceRatio = (float)finalHeight / (float)h;
        this.setDpiScale(scale).setSizeScale(virtualDeviceRatio).build();
        this.rect.setSize(virtualWidth, finalHeight);
        this.rect.setLocation(Math.round(((float)phoneSize.getWidth() - (float)virtualWidth) / 2.0f), Math.round((float)(phoneSize.getHeight() - (double)finalHeight) / 2.0f));
    }

    private void scaleDragVer(int w, int h, float scale, float deviceRatio, Dimension phoneSize) {
        int finalWidth = this.containerWidth;
        int virtualHeight = Math.round((float)finalWidth / deviceRatio);
        float virtualDeviceRatio = (float)finalWidth / (float)w;
        this.setDpiScale(scale).setSizeScale(virtualDeviceRatio).build();
        this.rect.setSize(finalWidth, virtualHeight);
        this.rect.setLocation(Math.round(((float)phoneSize.getWidth() - (float)finalWidth) / 2.0f), Math.round((float)(phoneSize.getHeight() - (double)virtualHeight) / 2.0f));
    }

    private void scaleSize(int w, int h, float scale, Dimension phoneSize) {
        this.setDpiScale(scale).build();
        int realW = (int)((float)w * this.sizeScale);
        int realH = (int)((float)h * this.sizeScale);
        this.rect.setSize(realW, realH);
        float locX = (float)phoneSize.getWidth() - (float)realW;
        float locY = (float)phoneSize.getHeight() - (float)realH;
        if (locX < 0.0f) {
            locX = 30.0f;
        }
        if (locY < 0.0f) {
            locY = 50.0f;
        }
        this.rect.setLocation(Math.round(locX / 2.0f), Math.round(locY / 2.0f));
    }

    private void log(String format2, Object ... params) {
    }
}

