/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.utils;

public class DimenUtil {
    public static float mScale = 1.0f;
    public static float mSpScale = 1.0f;
    public static float sizeScale = 1.0f;
    public static float WRAP_CONTENT;
    public static float MATCH_PARENT;

    public static void init(float sScale, float spScale) {
        mScale = sScale;
        mSpScale = spScale;
        WRAP_CONTENT = -2.0f * sScale + 0.5f;
        MATCH_PARENT = -1.0f * sScale + 0.5f;
    }

    public static int dpiToPx(float dpi) {
        return (int)((double)(dpi * mScale) + 0.5);
    }

    public static int dpiToPx(double dpi) {
        return (int)(dpi * (double)mScale + 0.5);
    }

    public static float dpiToPxF(double dpi) {
        return (float)(dpi * (double)mScale + 0.5);
    }

    public static float pxToDpi(float px) {
        return px / mScale;
    }

    public static int pxToDp(int px) {
        return (int)((double)((float)px / mScale) + 0.5);
    }

    public static int spToPx(float spValue) {
        return (int)((double)(spValue * mScale) + 0.5);
    }

    public static float pxToSp(float pxValue) {
        return (int)((double)(pxValue / mSpScale) + 0.5);
    }

    public static void setSizeScale(float sizeScale) {
        DimenUtil.sizeScale = sizeScale;
    }

    public static float getSizeScale() {
        return sizeScale;
    }

    public static int toDevicePx(double dpi) {
        float px = DimenUtil.dpiToPxF(dpi);
        if (px == WRAP_CONTENT) {
            return -2;
        }
        if (px == MATCH_PARENT) {
            return -1;
        }
        return (int)px;
    }
}

