/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.utils;

import java.awt.Color;

public class ColorUtils {
    public static String hex(Color color) {
        if (color == null) {
            return "";
        }
        int a = color.getAlpha();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (a < 255) {
            return String.format("#%s%s%s%s", ColorUtils.toHexString(a), ColorUtils.toHexString(r), ColorUtils.toHexString(g), ColorUtils.toHexString(b));
        }
        return String.format("#%s%s%s", ColorUtils.toHexString(r), ColorUtils.toHexString(g), ColorUtils.toHexString(b));
    }

    public static Color parseColor(String hexString) {
        if (!hexString.startsWith("#")) {
            return null;
        }
        boolean isValid = false;
        int a = 255;
        int r = 255;
        int g = 255;
        int b = 255;
        switch (hexString.length()) {
            case 4: {
                r = Integer.valueOf(hexString.substring(1, 2), 16);
                g = Integer.valueOf(hexString.substring(2, 3), 16);
                b = Integer.valueOf(hexString.substring(3, 4), 16);
                isValid = true;
                break;
            }
            case 5: {
                a = Integer.valueOf(hexString.substring(1, 2), 16);
                r = Integer.valueOf(hexString.substring(2, 3), 16);
                g = Integer.valueOf(hexString.substring(3, 4), 16);
                b = Integer.valueOf(hexString.substring(4, 5), 16);
                isValid = true;
                break;
            }
            case 7: {
                r = Integer.valueOf(hexString.substring(1, 3), 16);
                g = Integer.valueOf(hexString.substring(3, 5), 16);
                b = Integer.valueOf(hexString.substring(5, 7), 16);
                isValid = true;
                break;
            }
            case 9: {
                a = Integer.valueOf(hexString.substring(1, 3), 16);
                r = Integer.valueOf(hexString.substring(3, 5), 16);
                g = Integer.valueOf(hexString.substring(5, 7), 16);
                b = Integer.valueOf(hexString.substring(7, 9), 16);
                isValid = true;
            }
        }
        if (isValid) {
            return new Color(r, g, b, a);
        }
        return null;
    }

    private static String toHexString(int value) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() == 1) {
            hexString = String.format("0%s", hexString);
        }
        return hexString;
    }
}

