/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.utils;

import com.immomo.mlservics.Environment;
import com.immomo.mmpaas.panel.message.Message;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;

public class AssertUtils {
    public static void assetTrue(boolean b) {
        if (!b) {
            throw new IllegalStateException();
        }
    }

    public static void assertNullForce(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public static boolean assertNull(Object obj, String msg, Globals globals) {
        if (obj == null) {
            NullPointerException exception = new NullPointerException(msg);
            if (!Environment.hook(exception, globals)) {
                throw exception;
            }
            return false;
        }
        return true;
    }

    public static boolean assertNil(LuaValue a, LuaFunction caller, Globals globals) {
        if (a == null || a.isNil()) {
            ReturnError error2 = new ReturnError(" return nil in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertNumber(LuaValue v, LuaFunction caller, Globals globals) {
        if (v == null || !v.isNumber()) {
            ReturnError error2 = new ReturnError(" return type invalid! need number instead of " + v + " in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertString(LuaValue v, LuaFunction caller, Globals globals) {
        if (v == null || !v.isString()) {
            ReturnError error2 = new ReturnError(" return type invalid! need string instead of " + v + " in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertBoolean(LuaValue v, LuaFunction caller, Globals globals) {
        if (v == null || !v.isBoolean()) {
            ReturnError error2 = new ReturnError(" return type invalid! need boolean instead of " + v + " in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertUserData(LuaValue v, Class<? extends LuaUserdata> need, LuaFunction caller, Globals globals) {
        if (v == null || !need.isInstance(v)) {
            ReturnError error2 = new ReturnError(" return type invalid! need " + AssertUtils.getUDName(need) + " instead of " + v + " in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertUserData(LuaValue v, Class<? extends LuaUserdata> need, String caller, Globals globals) {
        if (v == null || !need.isInstance(v)) {
            ReturnError error2 = new ReturnError(" setter type invalid! need " + AssertUtils.getUDName(need) + " instead of " + v + " in caller " + caller);
            AssertUtils.throwError(error2, globals);
            return false;
        }
        return true;
    }

    public static boolean assertFunction(LuaValue v, String msg, Globals globals) {
        if (v == null || !v.isFunction()) {
            ReturnError error2 = new ReturnError(msg);
            if (!Environment.hook(error2, globals)) {
                throw error2;
            }
            return false;
        }
        return true;
    }

    private static String getUDName(Class<? extends LuaUserdata> clz) {
        return clz.getSimpleName();
    }

    private static void throwError(ReturnError error2, Globals globals) {
        if (!Environment.hook(error2, globals)) {
            Message.printError(error2.getMessage());
            throw error2;
        }
    }

    public static final class ReturnError
    extends RuntimeException {
        public ReturnError(Throwable cause) {
            super(cause);
        }

        public ReturnError(String message2) {
            super(message2);
        }
    }
}

