/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.ud.view;

import com.immomo.mlservics.Environment;
import com.immomo.mlservics.ud.view.Size;
import com.immomo.mlservics.ud.view.UDCell;
import com.immomo.mlservics.ud.view.listview.IDGenerator;
import com.immomo.mlservics.utils.AssertUtils;
import com.immomo.mlservics.weight.View;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mmpaas.Application;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jf.util.SparseArray;
import org.luaj.vm2.JavaUserdata;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

public class UDListViewAdapter
extends JavaUserdata {
    public static final String LUA_CLASS_NAME = "TableViewAdapter";
    public static final String[] methods = new String[]{"initCell", "fillCellData", "rowCount", "reuseId", "initCellByReuseId", "fillCellDataByReuseId", "sectionCount", "heightForCell", "heightForCellByReuseId"};
    private LuaFunction reuseIdDelegate;
    private LuaFunction initCellDelegate;
    private Map<String, LuaFunction> typeCellDelegate;
    private LuaFunction bindDataDelegate;
    private Map<String, LuaFunction> bindTypeDataDelegate;
    private LuaFunction sectionCountDelegate;
    private LuaFunction rowCountDelegate;
    private int count;
    private SparseArray<String> reuseIdCache;
    private int[] sections;
    private AtomicInteger allCount;
    private IDGenerator idGenerator = new IDGenerator();
    protected LuaFunction heightForCell;
    protected Map<String, LuaFunction> heightDelegates;

    protected UDListViewAdapter(long L, LuaValue[] v) {
        super(L, v);
    }

    @LuaApiUsed
    public final LuaValue[] initCell(LuaValue[] values) {
        this.initCellDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] fillCellData(LuaValue[] values) {
        this.bindDataDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] rowCount(LuaValue[] values) {
        this.rowCountDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] reuseId(LuaValue[] values) {
        this.reuseIdDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] initCellByReuseId(LuaValue[] values) {
        if (this.typeCellDelegate == null) {
            this.typeCellDelegate = new HashMap<String, LuaFunction>();
        }
        this.typeCellDelegate.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    @LuaApiUsed
    public LuaValue[] fillCellDataByReuseId(LuaValue[] values) {
        if (this.bindTypeDataDelegate == null) {
            this.bindTypeDataDelegate = new HashMap<String, LuaFunction>();
        }
        this.bindTypeDataDelegate.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    @LuaApiUsed
    public LuaValue[] sectionCount(LuaValue[] values) {
        this.sectionCountDelegate = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] heightForCell(LuaValue[] values) {
        this.heightForCell = values[0].toLuaFunction();
        return null;
    }

    @LuaApiUsed
    public LuaValue[] heightForCellByReuseId(LuaValue[] values) {
        if (this.heightDelegates == null) {
            this.heightDelegates = new HashMap<String, LuaFunction>();
        }
        this.heightDelegates.put(values[0].toJavaString(), values[1].toLuaFunction());
        return null;
    }

    public boolean hasCellSize() {
        return this.heightForCell != null || this.heightDelegates != null;
    }

    public Size getCellSize(int pos) {
        LuaFunction caller;
        int[] sr = this.getSectionAndRowIn(pos);
        LuaValue s = UDListViewAdapter.toLuaInt(sr[0]);
        LuaValue r = UDListViewAdapter.toLuaInt(sr[1]);
        if (this.heightDelegates != null) {
            String id = this.getReuseIdByType(this.getViewType(pos));
            caller = this.heightDelegates.get(id);
        } else {
            caller = this.heightForCell;
        }
        LuaValue[] rets = caller.invoke(UDListViewAdapter.varargsOf(s, r));
        if (rets == null || rets.length == 0) {
            return new Size(Float.MIN_VALUE, 2.8E-45f);
        }
        LuaValue ret2 = rets[0];
        if (!AssertUtils.assertNumber(ret2, caller, this.getGlobals())) {
            return new Size(Float.MIN_VALUE, 2.8E-45f);
        }
        int height = ret2.toInt();
        height = height < 0 ? 0 : height;
        Size cellSize = new Size(Float.MIN_VALUE, height);
        return cellSize;
    }

    public void setLayoutParams(View view, Size size) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        int w = size.getWidthPx();
        int h = size.getHeightPx();
        boolean changed = false;
        if (params == null) {
            params = new ViewGroup.LayoutParams(w, h);
            changed = true;
        } else if (params.width != w || params.height != h) {
            params.width = w;
            params.height = h;
            changed = true;
        }
        if (changed) {
            view.setLayoutParams(params);
        }
    }

    protected String getReuseId(int position) {
        String id;
        if (this.reuseIdCache != null && (id = (String)this.reuseIdCache.get(position)) != null) {
            return id;
        }
        if (this.reuseIdDelegate != null && !this.reuseIdDelegate.isNil()) {
            IllegalArgumentException e;
            int[] sr = this.getSectionAndRowIn(position);
            if (sr == null) {
                return null;
            }
            LuaValue[] lr = this.reuseIdDelegate.invoke(UDListViewAdapter.varargsOf(UDListViewAdapter.toLuaInt(sr[0]), UDListViewAdapter.toLuaInt(sr[1])));
            LuaValue v = lr != null && lr.length > 0 ? lr[0] : UDListViewAdapter.Nil();
            String result = AssertUtils.assertString(v, this.reuseIdDelegate, this.getGlobals()) ? v.toJavaString() : v.toString();
            if ("".equals(result) && !Environment.hook(e = new IllegalArgumentException("reuseId  can`t be \u201d\u201c"), this.getGlobals())) {
                throw e;
            }
            if (this.reuseIdCache == null) {
                this.reuseIdCache = new SparseArray();
            }
            this.reuseIdCache.put(position, (Object)result);
            return result;
        }
        return null;
    }

    protected int[] getSectionAndRowIn(int pos) {
        if (this.sections == null) {
            return null;
        }
        int sc = this.sections.length;
        for (int i = 0; i < sc; i += 2) {
            int offset = pos - this.sections[i];
            if (offset < 0 || pos >= this.sections[i + 1]) continue;
            return new int[]{i >> 1, offset};
        }
        return null;
    }

    public int getViewType(int position) {
        String id = this.getReuseId(position);
        return this.idGenerator.getViewTypeForReuseId(id);
    }

    public String getReuseIdByType(int type2) {
        return this.idGenerator.getReuseIdByType(type2);
    }

    private void initSection() {
        if (this.allCount == null) {
            this.allCount = new AtomicInteger();
        }
        this.allCount.set(-1);
        this.sections = this.getSectionInfo(this.allCount);
    }

    private int[] getSectionInfo(AtomicInteger allCountOut) {
        if (this.rowCountDelegate == null || this.rowCountDelegate.isNil()) {
            return null;
        }
        int sectionCount = 0;
        if (this.sectionCountDelegate != null && this.sectionCountDelegate.isFunction()) {
            LuaValue sv = this.sectionCountDelegate.invoke(null)[0];
            if (AssertUtils.assertNumber(sv, this.sectionCountDelegate, this.getGlobals())) {
                sectionCount = sv.toInt();
            }
        } else {
            sectionCount = 1;
        }
        if (sectionCount <= 0) {
            IllegalArgumentException e;
            if (Application.DEBUG && !Environment.hook(e = new IllegalArgumentException("section count must bigger than 0, return " + sectionCount), this.getGlobals())) {
                throw e;
            }
            sectionCount = 1;
        }
        int resultCount = sectionCount << 1;
        int[] result = new int[resultCount];
        int allCount = 0;
        for (int i = 0; i < resultCount; i += 2) {
            LuaValue rc = this.rowCountDelegate.invoke(UDListViewAdapter.varargsOf(UDListViewAdapter.toLuaInt(i >> 1)))[0];
            result[i] = allCount;
            if (AssertUtils.assertNumber(rc, this.rowCountDelegate, this.getGlobals())) {
                allCount += rc.toInt();
            }
            result[i + 1] = allCount;
        }
        if (allCountOut != null) {
            allCountOut.set(allCount);
        }
        return result;
    }

    public void callInitCell(LuaValue cell, int viewType) {
        LuaFunction delegate = null;
        if (this.typeCellDelegate != null) {
            String id = this.getReuseIdByType(viewType);
            delegate = this.typeCellDelegate.get(id);
        }
        if (delegate == null) {
            delegate = this.initCellDelegate;
        }
        if (this.globals.isDestroyed()) {
            return;
        }
        if (!AssertUtils.assertFunction(delegate, "initCell callback must be a function", this.getGlobals())) {
            return;
        }
        delegate.invoke(UDListViewAdapter.varargsOf(cell));
    }

    public void callFillDataCell(LuaValue cell, int position) {
        LuaFunction delegate = null;
        if (this.bindTypeDataDelegate != null) {
            delegate = this.bindTypeDataDelegate.get(this.getReuseId(position));
        }
        if (delegate == null) {
            delegate = this.bindDataDelegate;
        }
        if (delegate != null) {
            int[] sr = this.getSectionAndRowIn(position);
            delegate.invoke(UDListViewAdapter.varargsOf(cell, UDListViewAdapter.toLuaInt(sr[0]), UDListViewAdapter.toLuaInt(sr[1])));
        }
    }

    public View getView(int pos) {
        UDCell layout = new UDCell(this.getGlobals(), this);
        View itemView = (View)layout.getView();
        this.initSection();
        int viewType = this.getViewType(pos);
        this.callInitCell(layout.getCell(), viewType);
        this.initSize(itemView, viewType);
        this.callFillDataCell(layout.getCell(), pos);
        return itemView;
    }

    private void initSize(View itemView, int type2) {
        itemView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
    }

    public int getCount() {
        this.count = this.rowCountDelegate.invoke(UDListViewAdapter.varargsOf(UDListViewAdapter.toLuaInt(1)))[0].toInt();
        return this.count;
    }

    protected static LuaValue toLuaInt(int i) {
        return LuaNumber.valueOf(i + 1);
    }
}

