/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.ud.view;

import com.immomo.mlservics.ErrorUtils;
import com.immomo.mlservics.constants.UDColor;
import com.immomo.mlservics.luaview.LuaLabel;
import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.utils.DimenUtil;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public class UDLabel
extends UDBaseView<LuaLabel> {
    public static final String LUA_CLASS_NAME = "Label";
    public static final String[] methods = new String[]{"text", "textAlign", "fontSize", "textColor", "lines", "breakMode", "setLineSpacing", "setTextFontStyle"};

    protected UDLabel(long L, LuaValue[] v) {
        super(L, v);
    }

    @Override
    protected LuaLabel newView(LuaValue[] params) {
        return new LuaLabel<UDLabel>(this);
    }

    public LuaValue[] text(LuaValue[] var) {
        if (var.length == 1) {
            String text = var[0].isNil() ? "" : var[0].toJavaString();
            ((LuaLabel)this.getView()).setLabelText(text);
            return null;
        }
        return UDLabel.varargsOf(LuaString.valueOf(((LuaLabel)this.getView()).getLabelText()));
    }

    public LuaValue[] textAlign(LuaValue[] var) {
        if (var.length == 1) {
            ((LuaLabel)this.getView()).setTextAlign(var[0].toInt());
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x2000);
            return null;
        }
        return UDLabel.varargsOf(LuaNumber.valueOf(((LuaLabel)this.getView()).getTextAlign()));
    }

    public LuaValue[] fontSize(LuaValue[] var) {
        if (var.length == 1) {
            ((LuaLabel)this.getView()).setTextSize(var[0].toInt());
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x800);
            return null;
        }
        return UDLabel.varargsOf(LuaNumber.valueOf(DimenUtil.pxToSp(((LuaLabel)this.getView()).getFont().getSize())));
    }

    public LuaValue[] textColor(LuaValue[] var) {
        if (var.length == 1 && var.length == 1 && var[0] instanceof UDColor) {
            UDColor color = (UDColor)var[0];
            ((LuaLabel)this.getView()).setTextColor(color.getColor());
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x1000);
            return null;
        }
        return UDLabel.varargsOf(new UDColor(this.getGlobals(), ((LuaLabel)this.getView()).getForeground()));
    }

    public LuaValue[] lines(LuaValue[] var) {
        if (var.length == 1) {
            int i = var[0].toInt();
            if (i == 0) {
                i = Integer.MAX_VALUE;
                ErrorUtils.debugLuaError("\u8b66\u544a\uff1a\u8bbe\u7f6elines\u4e3a0\uff0cbreakMode\u53ea\u80fd\u8868\u73b0\u51faCLIPPING\u6a21\u5f0f", this.globals);
            }
            ((LuaLabel)this.getView()).setLines(i);
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x4000);
            return null;
        }
        return UDLabel.varargsOf(((LuaLabel)this.getView()).getLines() == Integer.MAX_VALUE ? LuaNumber.valueOf(0) : LuaNumber.valueOf(((LuaLabel)this.getView()).getLines()));
    }

    public LuaValue[] setLineSpacing(LuaValue[] spacing) {
        if (spacing.length == 1) {
            ((LuaLabel)this.getView()).setLineSpacing(spacing[0].toFloat());
            return null;
        }
        return UDLabel.varargsOf(LuaNumber.valueOf(((LuaLabel)this.getView()).getLineSpacing()));
    }

    public LuaValue[] setTextFontStyle(LuaValue[] var) {
        if (var.length == 1) {
            ((LuaLabel)this.getView()).setTextFontStyle(var[0].toInt());
        }
        return null;
    }

    public LuaValue[] breakMode(LuaValue[] var) {
        if (var.length == 1) {
            ((LuaLabel)this.getView()).setBreakMode(var[0].toInt());
        }
        return null;
    }

    @Override
    public void applyProperties(String method, LuaValue[] value) {
        super.applyProperties(method, value);
        switch (method) {
            case "fontSize": {
                if ((long)(this.mPrivateFlags & 0x800) != 0L) break;
                this.fontSize(value);
                break;
            }
            case "textColor": {
                if ((long)(this.mPrivateFlags & 0x1000) != 0L) break;
                this.textColor(value);
                break;
            }
            case "textAlign": {
                if ((long)(this.mPrivateFlags & 0x2000) != 0L) break;
                this.textAlign(value);
                break;
            }
            case "lines": {
                if ((long)(this.mPrivateFlags & 0x4000) != 0L) break;
                this.lines(value);
            }
        }
    }
}

