/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.ud.view;

import com.immomo.mlservics.ErrorUtils;
import com.immomo.mlservics.constants.UDColor;
import com.immomo.mlservics.utils.AssertUtils;
import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import org.luaj.vm2.Globals;
import org.luaj.vm2.JavaUserdata;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

public abstract class UDBaseView<V extends IView>
extends JavaUserdata<V> {
    public static final String LUA_CLASS_NAME = "__BaseView";
    public static final String[] methods = new String[]{"width", "height", "setMaxWidth", "setMaxHeight", "setMinWidth", "setMinHeight", "marginLeft", "marginTop", "marginRight", "marginBottom", "priority", "weight", "padding", "setGravity", "alpha", "borderWidth", "borderColor", "hidden", "gone", "bgColor", "bgImage", "cornerRadius", "setCornerRadiusWithDirection", "addCornerMask", "setGradientColorWithDirection", "setShadow", "clipToBounds", "overlay"};
    public UDBaseView overView;
    private static final int PFLAG_Width_IS_SET = 1;
    private static final int PFLAG_Height_IS_SET = 2;
    private static final int PFLAG_BGCOLOR_IS_SET = 4;
    private static final int PFLAG_Gravity_IS_SET = 8;
    private static final int PFLAG_CornerRadius_IS_SET = 16;
    protected static final int PFLAG_PlaceholderColor_IS_SET = 32;
    protected static final int PFLAG_InputMode_IS_SET = 64;
    protected static final int PFLAG_ReturnMode_IS_SET = 128;
    protected static final int PFLAG_SingleLine_IS_SET = 256;
    protected static final int PFLAG_ContentMode_IS_SET = 512;
    protected static final int PFLAG_LazyLoad_IS_SET = 1024;
    protected static final int PFLAG_FontSize_IS_SET = 2048;
    protected static final int PFLAG_TextColor_IS_SET = 4096;
    protected static final int PFLAG_TextAlign_IS_SET = 8192;
    protected static final int PFLAG_Lines_IS_SET = 16384;
    protected byte mPrivateFlags;

    protected UDBaseView(long L, LuaValue[] v) {
        super(L, v);
        this.javaUserdata = this.newView(v);
        this.checkView();
    }

    public UDBaseView(Globals g, V jud) {
        super(g, jud);
        this.checkView();
    }

    protected UDBaseView(Globals g) {
        super(g, null);
        this.javaUserdata = this.newView(UDBaseView.empty());
        this.checkView();
    }

    protected abstract V newView(LuaValue[] var1);

    protected void checkView() {
        if (this.javaUserdata == null) {
            throw new NullPointerException("View is Null");
        }
    }

    public V getView() {
        return (V)((IView)this.javaUserdata);
    }

    public LuaValue[] width(LuaValue[] varargs) {
        if (varargs.length == 1) {
            double src = varargs[0].toDouble();
            this.checkSize(src);
            this.getView().setWidth(src);
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 1);
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getWidth())));
    }

    public LuaValue[] height(LuaValue[] varargs) {
        if (varargs.length == 1) {
            double src = varargs[0].toDouble();
            this.checkSize(src);
            this.getView().setHeight(src);
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 2);
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getHeight())));
    }

    public int getWidth() {
        ViewGroup.LayoutParams params = this.getView().getLayoutParams();
        if (params != null) {
            return params.width >= 0 ? params.width : this.getView().getMeasuredWidth();
        }
        return this.getView().getMeasuredWidth();
    }

    public int getHeight() {
        ViewGroup.LayoutParams params = this.getView().getLayoutParams();
        if (params != null) {
            return params.height >= 0 ? params.height : this.getView().getMeasuredHeight();
        }
        return this.getView().getMeasuredHeight();
    }

    public LuaValue[] setMaxWidth(LuaValue[] pa) {
        this.getView().setMaxWidth(pa[0].toDouble());
        return null;
    }

    public LuaValue[] setMaxHeight(LuaValue[] pa) {
        this.getView().setMaxHeight(pa[0].toDouble());
        return null;
    }

    public LuaValue[] setMinWidth(LuaValue[] p) {
        this.getView().setMinWidth(p[0].toDouble());
        return null;
    }

    @LuaApiUsed
    public LuaValue[] setMinHeight(LuaValue[] p) {
        this.getView().setMinHeight(p[0].toDouble());
        return null;
    }

    public LuaValue[] marginLeft(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setMarginLeft(var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().leftMargin)));
    }

    public LuaValue[] marginTop(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setMarginTop(var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().topMargin)));
    }

    public LuaValue[] marginRight(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setMarginRight(var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().rightMargin)));
    }

    public LuaValue[] marginBottom(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setMarginBottom(var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().bottomMargin)));
    }

    public LuaValue[] priority(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setPriority(var[0].toInt());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().priority)));
    }

    public LuaValue[] weight(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setWeight(var[0].toInt());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getLayoutParams().weight)));
    }

    public LuaValue[] padding(LuaValue[] p) {
        this.getView().setPadding(p[3].toDouble(), p[0].toDouble(), p[1].toDouble(), p[2].toDouble());
        return null;
    }

    public LuaValue[] setGravity(LuaValue[] var) {
        this.getView().setGravity(var[0].toInt());
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 8);
        return null;
    }

    public LuaValue[] alpha(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setAlpha((float)var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(this.getView().getAlpha()));
    }

    public LuaValue[] borderWidth(LuaValue[] var) {
        if (var.length == 1) {
            this.getView().setBorderWidth(var[0].toDouble());
            return null;
        }
        return UDBaseView.varargsOf(LuaNumber.valueOf(DimenUtil.pxToDpi(this.getView().getBorderWidth())));
    }

    public LuaValue[] borderColor(LuaValue[] var) {
        if (var.length == 1 && AssertUtils.assertUserData(var[0], UDColor.class, "borderColor", this.getGlobals())) {
            this.getView().setBorderColor(((UDColor)var[0]).getColor());
            var[0].destroy();
            return null;
        }
        return UDBaseView.varargsOf(new UDColor(this.globals, this.getView().getBorderColor()));
    }

    public LuaValue[] hidden(LuaValue[] var) {
        if (var.length == 1 && var[0].isBoolean()) {
            this.getView().setVisibility(var[0].toBoolean() ? 1 : 0);
            return null;
        }
        return this.getView().getVisibility() != 0 ? UDBaseView.rTrue() : UDBaseView.rFalse();
    }

    public LuaValue[] gone(LuaValue[] var) {
        if (var.length == 1 && var[0].isBoolean()) {
            this.getView().setVisibility(var[0].toBoolean() ? 2 : 0);
            return null;
        }
        return this.getView().getVisibility() != 2 ? UDBaseView.rTrue() : UDBaseView.rFalse();
    }

    public LuaValue[] bgColor(LuaValue[] var) {
        if (var.length == 1 && AssertUtils.assertUserData(var[0], UDColor.class, "bgColor", this.getGlobals())) {
            this.getView().setBgColor(((UDColor)var[0]).getColor());
            this.mPrivateFlags = (byte)(this.mPrivateFlags | 4);
            return null;
        }
        UDColor ret2 = new UDColor(this.getGlobals(), this.getView().getBgColor());
        return UDBaseView.varargsOf(ret2);
    }

    public LuaValue[] bgImage(LuaValue[] var) {
        if (var.length == 1) {
            String url = var[0].toJavaString();
            this.getView().setBgImage(url);
        }
        return null;
    }

    public LuaValue[] setCornerRadiusWithDirection(LuaValue[] var) {
        int d = 15;
        if (var.length > 1) {
            d = var[1].toInt();
        }
        this.getView().setCornerRadiusWithDirection(var[0].toDouble(), d);
        return null;
    }

    public LuaValue[] addCornerMask(LuaValue[] var) {
        int d = 15;
        if (var.length > 2) {
            d = var[2].toInt();
        }
        this.getView().addCornerMask(var[0].toDouble(), ((UDColor)var[1]).getColor(), d);
        return null;
    }

    public LuaValue[] cornerRadius(LuaValue[] var) {
        if (var.length == 0) {
            return UDBaseView.rNumber(0.0);
        }
        this.setCornerRadiusWithDirection(var);
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x10);
        return null;
    }

    public LuaValue[] setGradientColorWithDirection(LuaValue[] var) {
        this.getView().setGradientColorWithDirection(((UDColor)var[0]).getColor(), ((UDColor)var[1]).getColor(), var[2].toInt());
        return null;
    }

    public LuaValue[] setShadow(LuaValue[] var) {
        double x = var[0].toDouble();
        double y = var[1].toDouble();
        double r = var[2].toDouble();
        float a = var[3].toFloat();
        this.getView().setShadow(x, y, r, a);
        return null;
    }

    public LuaValue[] clipToBounds(LuaValue[] var) {
        return null;
    }

    public LuaValue[] overlay(LuaValue[] p) {
        this.overView = p.length > 0 ? (UDBaseView)p[0] : null;
        this.getView().overlay(this.overView);
        return null;
    }

    public void measureOverLayout(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.overView != null) {
            V overChild = this.overView.getView();
            ViewGroup.LayoutParams lp = overChild.getLayoutParams();
            if (lp == null) {
                lp = this.getView().getLayoutParams();
            }
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-1, -1);
            }
            lp.width = this.getView().getMeasuredWidth();
            lp.height = this.getView().getMeasuredHeight();
            overChild.setLayoutParams(lp);
            overChild.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void layoutOverLayout(int left, int top, int right, int bottom) {
        if (this.overView != null) {
            this.overView.getView().layout(left, top, right, bottom);
        }
    }

    public void drawOverLayout() {
        if (this.overView != null) {
            this.overView.getView().reDraw();
        }
    }

    protected void checkSize(double src) {
        if (src >= 0.0) {
            return;
        }
        if (src == -1.0 || src == -2.0) {
            return;
        }
        ErrorUtils.debugLuaError("size must be set with positive number, error number: " + src + ".", this.getGlobals());
    }

    public void applyProperties(String method, LuaValue[] value) {
        switch (method) {
            case "width": {
                if ((long)(this.mPrivateFlags & 1) != 0L) break;
                this.width(value);
                break;
            }
            case "height": {
                if ((long)(this.mPrivateFlags & 2) != 0L) break;
                this.height(value);
                break;
            }
            case "setGravity": {
                if ((long)(this.mPrivateFlags & 8) != 0L) break;
                this.setGravity(value);
                break;
            }
            case "bgColor": {
                if ((long)(this.mPrivateFlags & 4) != 0L) break;
                this.bgColor(value);
                break;
            }
            case "borderWidth": {
                if (this.getView().getBorderWidth() != 0) break;
                this.borderWidth(value);
                break;
            }
            case "cornerRadius": {
                if ((long)(this.mPrivateFlags & 0x10) != 0L) break;
                this.cornerRadius(value);
            }
        }
    }
}

