/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.ud.view;

import com.immomo.mlservics.utils.DimenUtil;

public class Size {
    public static final float MATCH_PARENT = Float.MIN_VALUE;
    public static final float WRAP_CONTENT = 2.8E-45f;
    private float width;
    private float height;

    public Size() {
    }

    public Size(float w, float h) {
        this.width = w;
        this.height = h;
    }

    public Size(Size src) {
        this.setSize(src);
    }

    public void setSize(Size src) {
        this.width = src.width;
        this.height = src.height;
    }

    public float getWidth() {
        return (int)this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return (int)this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public int getWidthPx() {
        if (this.isMatchParent(this.width)) {
            return -1;
        }
        if (this.isWrapContent(this.width)) {
            return -2;
        }
        return DimenUtil.dpiToPx(this.width);
    }

    public int getHeightPx() {
        if (this.isMatchParent(this.height)) {
            return -1;
        }
        if (this.isWrapContent(this.height)) {
            return -2;
        }
        return DimenUtil.dpiToPx(this.height);
    }

    private boolean isMatchParent(float s) {
        return s == Float.MIN_VALUE;
    }

    private boolean isWrapContent(float s) {
        return s == 2.8E-45f;
    }

    public String toString() {
        return "Size{width=" + this.width + ", height=" + this.height + '}';
    }
}

