/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics.constants;

import com.immomo.mlservics.ErrorUtils;
import com.immomo.mlservics.utils.ColorUtils;
import java.awt.Color;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;

public class UDColor
extends LuaUserdata {
    public static final String LUA_CLASS_NAME = "Color";
    public static final String[] methods = new String[]{"hex", "alpha", "red", "green", "blue", "setHexA", "setRGBA", "clear", "setAColor", "setColor"};
    private Color color;

    public UDColor(Globals g, Color color) {
        super(g, color);
    }

    protected UDColor(long L, LuaValue[] v) {
        super(L, v);
        this.init(v);
    }

    public int dealColorVal(int val) {
        if (val > 255) {
            return 255;
        }
        if (val < 0) {
            return 0;
        }
        return val;
    }

    private void init(LuaValue[] initParams) {
        if (initParams != null) {
            if (initParams.length == 4) {
                this.color = new Color(this.dealColorVal(initParams[0].toInt()), this.dealColorVal(initParams[1].toInt()), this.dealColorVal(initParams[2].toInt()), (int)(this.dealAlphaVal(initParams[3].toDouble()) * 255.0));
            } else if (initParams.length == 3) {
                this.color = new Color(this.dealColorVal(initParams[0].toInt()), this.dealColorVal(initParams[1].toInt()), this.dealColorVal(initParams[2].toInt()), 255);
            } else if (initParams.length != 0) {
                ErrorUtils.debugIllegalStateError("Color only zero or three or four parameters can be used for constructor method");
            }
        }
    }

    public LuaValue[] hex(LuaValue[] p) {
        if (p.length == 1) {
            try {
                this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.getAlpha());
            }
            catch (Exception e) {
                ErrorUtils.debugIllegalStateError("Color hex style is wrong");
            }
            return null;
        }
        return UDColor.rNumber(this.color.getRGB());
    }

    public LuaValue[] alpha(LuaValue[] p) {
        if (p.length == 1) {
            this.setAlpha((int)(this.dealAlphaVal(p[0].toDouble()) * 255.0));
            return null;
        }
        return UDColor.rNumber((float)this.getAlpha() / 255.0f);
    }

    public LuaValue[] red(LuaValue[] p) {
        if (p.length == 1) {
            this.color = new Color(p[0].toInt(), this.color.getGreen(), this.color.getBlue(), this.getAlpha());
        }
        return UDColor.rNumber(this.color.getRed());
    }

    public LuaValue[] green(LuaValue[] p) {
        if (p.length == 1) {
            this.color = new Color(this.color.getRed(), p[0].toInt(), this.color.getBlue(), this.getAlpha());
        }
        return UDColor.rNumber(this.color.getGreen());
    }

    public LuaValue[] blue(LuaValue[] p) {
        if (p.length == 1) {
            this.color = new Color(this.color.getRed(), this.color.getGreen(), p[0].toInt());
        }
        return UDColor.rNumber(this.color.getBlue());
    }

    public LuaValue[] setHexA(LuaValue[] p) {
        if (p.length == 2) {
            this.color = new Color(p[0].toInt());
            this.setAlpha((int)(this.dealAlphaVal(p[1].toDouble()) * 255.0));
        }
        return null;
    }

    public LuaValue[] setRGBA(LuaValue[] p) {
        if (p.length == 4) {
            this.color = new Color(this.dealColorVal(p[0].toInt()), this.dealColorVal(p[1].toInt()), this.dealColorVal(p[2].toInt()), (int)this.dealAlphaVal(p[3].toDouble()) * 255);
        }
        return null;
    }

    public LuaValue[] clear(LuaValue[] p) {
        this.color = new Color(0, 0, 0, 0);
        return null;
    }

    public LuaValue[] setAColor(LuaValue[] p) {
        String colorStr = p[0].toJavaString();
        if (colorStr == null || colorStr.length() == 0) {
            throw new IllegalArgumentException("Unknown color");
        }
        if ((colorStr = colorStr.trim().toLowerCase()).charAt(0) == '#') {
            this.color = ColorUtils.parseColor(colorStr);
        }
        return null;
    }

    public LuaValue[] setColor(LuaValue[] p) {
        String colorStr = p[0].toJavaString();
        this.color = ColorUtils.parseColor(colorStr);
        return null;
    }

    public void setAlpha(int a) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), a);
    }

    public Color getColor() {
        return this.color;
    }

    private int getAlpha() {
        return this.color == null ? 255 : this.color.getAlpha();
    }

    public double dealAlphaVal(double val) {
        if (val > 1.0) {
            return 1.0;
        }
        if (val < 0.0) {
            return 0.0;
        }
        return val;
    }
}

