/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics;

import com.immomo.mlservics.ProGuardError;
import com.immomo.mlservics.RegisterError;
import com.immomo.mlservics.ud.view.UDBaseView;
import com.immomo.mlservics.wrapper.Constant;
import com.immomo.mlservics.wrapper.ConstantClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.SignatureUtils;
import org.luaj.vm2.utils.SizeOfUtils;

public class Register {
    private boolean preInstall = false;
    private final List<StringEnumHolder> seHolders = new ArrayList<StringEnumHolder>(10);
    private final List<NumberEnumHolder> neHolders = new ArrayList<NumberEnumHolder>(10);
    private final HashMap<Class, String> luaClassNameMap = new HashMap();
    private final AllUserdataHolder allUserdataHolder = new AllUserdataHolder();
    private final AllUserdataHolder lvUserdataHolder = new AllUserdataHolder();
    private final List<SHolder> sHolders = new ArrayList<SHolder>(20);
    private final List<SIHolder> siHolders = new ArrayList<SIHolder>(10);

    public void install(Globals g, boolean installView) {
        this.installUD(g, installView);
        this.installStaticBridge(g);
        this.installEnum(g);
    }

    public void preInstall() {
        if (this.preInstall) {
            return;
        }
        this.preInstall = true;
        this.preInstallUD();
        this.preInstallStaticBridge();
    }

    public void clearAll() {
        this.sHolders.clear();
        this.seHolders.clear();
        this.neHolders.clear();
        this.siHolders.clear();
        this.luaClassNameMap.clear();
        this.allUserdataHolder.clear();
        this.lvUserdataHolder.clear();
    }

    public void installEnum(Globals g) {
        for (StringEnumHolder stringEnumHolder : this.seHolders) {
            g.registerStringEnum(stringEnumHolder.luaClassName, stringEnumHolder.keys, stringEnumHolder.values);
        }
        for (NumberEnumHolder numberEnumHolder : this.neHolders) {
            g.registerNumberEnum(numberEnumHolder.luaClassName, numberEnumHolder.keys, numberEnumHolder.values);
        }
    }

    public void registerEnum(Class clz) {
        int len2;
        ConstantClass cc = clz.getAnnotation(ConstantClass.class);
        if (cc == null) {
            throw new RegisterError("register enum failed! class must have a ConstantClass annotation. Class:" + clz.getName());
        }
        Field[] fields = clz.getDeclaredFields();
        int n = len2 = fields == null ? 0 : fields.length;
        if (len2 == 0) {
            return;
        }
        String alias = cc.alias();
        String lcn = Register.isEmpty(alias) ? clz.getSimpleName() : alias;
        String[] keys = new String[len2];
        int nullValue = 0;
        Class<?> c = fields[0].getType();
        if (c.isPrimitive()) {
            double[] values = new double[len2];
            try {
                for (int i = 0; i < len2; ++i) {
                    Field f = fields[i];
                    Constant ca = f.getAnnotation(Constant.class);
                    if (ca == null) {
                        ++nullValue;
                        continue;
                    }
                    values[i - nullValue] = ((Number)f.get(null)).doubleValue();
                    alias = ca.alias();
                    keys[i - nullValue] = Register.isEmpty(alias) ? f.getName() : alias;
                }
            }
            catch (Throwable e) {
                throw new RegisterError("register enum error in " + clz.getName(), e);
            }
            if (nullValue != 0) {
                if (len2 - nullValue <= 0) {
                    return;
                }
                String[] ks = new String[len2 - nullValue];
                double[] vs = new double[len2 - nullValue];
                System.arraycopy(keys, 0, ks, 0, ks.length);
                System.arraycopy(values, 0, vs, 0, vs.length);
                keys = ks;
                values = vs;
            }
            this.registerEnum(lcn, keys, values);
            return;
        }
        if (c.equals(String.class)) {
            String[] values = new String[len2];
            try {
                for (int i = 0; i < len2; ++i) {
                    Field f = fields[i];
                    Constant ca = f.getAnnotation(Constant.class);
                    if (ca == null) {
                        ++nullValue;
                        continue;
                    }
                    values[i - nullValue] = (String)f.get(null);
                    alias = ca.alias();
                    keys[i - nullValue] = Register.isEmpty(alias) ? f.getName() : alias;
                }
            }
            catch (Throwable e) {
                throw new RegisterError("register enum error in " + clz.getName(), e);
            }
            if (nullValue != 0) {
                if (len2 - nullValue <= 0) {
                    return;
                }
                String[] ks = new String[len2 - nullValue];
                String[] vs = new String[len2 - nullValue];
                System.arraycopy(keys, 0, ks, 0, ks.length);
                System.arraycopy(values, 0, vs, 0, vs.length);
                keys = ks;
                values = vs;
            }
            this.registerEnum(lcn, keys, values);
            return;
        }
        throw new RegisterError("constant type must be number type or String, Class: " + clz.getName() + " field[0] class: " + c.getName());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void registerEnum(String luaClassName, String[] keys, String[] values) {
        this.seHolders.add(new StringEnumHolder(luaClassName, keys, values));
    }

    public void registerEnum(String luaClassName, String[] keys, double[] values) {
        this.neHolders.add(new NumberEnumHolder(luaClassName, keys, values));
    }

    private boolean checkClassMethod(Class clz, String mn, Class ... pc) throws NoSuchMethodException {
        Method m = null;
        try {
            m = clz.getMethod(mn, pc);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null) {
            try {
                m = clz.getDeclaredMethod(mn, pc);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null) {
            throw new NoSuchMethodException(clz.getName() + " has no method " + mn);
        }
        return true;
    }

    private void checkClassMethods(Class clz, String[] methods, boolean ud) {
        String name = clz.getSimpleName();
        if (methods == null || methods.length == 0) {
            return;
        }
        String methodName = null;
        try {
            String[] stringArray = methods;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String mn;
                methodName = mn = stringArray[i];
                if (!(ud ? !this.checkClassMethod(clz, mn, LuaValue[].class) : !this.checkClassMethod(clz, mn, Long.TYPE, LuaValue[].class))) continue;
                throw new Exception(name + "." + mn + " has no LuaApiUsed annotation!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new ProGuardError("Throw in debug! No method implement found for " + name + "." + methodName);
        }
        catch (Exception e) {
            throw new ProGuardError("Throw in debug! " + e.getMessage());
        }
    }

    public void installUD(Globals g, boolean installView) {
        this.allUserdataHolder.install(g);
        if (installView) {
            this.lvUserdataHolder.install(g);
        }
    }

    public void preInstallUD() {
        this.allUserdataHolder.preInstall();
        this.lvUserdataHolder.preInstall();
    }

    public void registerUserdata(UDHolder holder) {
        this.checkClassMethods(holder.clz, holder.methods, true);
        if (UDBaseView.class.isAssignableFrom(holder.clz)) {
            this.lvUserdataHolder.add(holder);
        } else {
            SizeOfUtils.sizeof(holder.clz);
            this.allUserdataHolder.add(holder);
        }
    }

    public static UDHolder newUDHolder(String lcn, Class<? extends LuaUserdata> clz, boolean lazy, String ... methods) {
        return new UDHolder(lcn, clz, lazy, methods);
    }

    public void installStaticBridge(Globals g) {
        for (SHolder h : this.sHolders) {
            g.registerStaticBridgeSimple(h.luaClassName, h.clz);
        }
    }

    public void preInstallStaticBridge() {
        for (SHolder h : this.sHolders) {
            Globals.preRegisterStatic(h.clz, h.methods);
        }
    }

    public void registerStaticBridge(SHolder holder) {
        this.checkClassMethods(holder.clz, holder.methods, false);
        this.sHolders.add(holder);
    }

    public static SHolder newSHolder(String lcn, Class clz, String ... methods) {
        return new SHolder(lcn, clz, methods);
    }

    public void createSingleInstance(Globals g) {
        for (SIHolder h : this.siHolders) {
            g.createUserdataAndSet(h.luaKey, h.luaClassName, new LuaValue[0]);
        }
    }

    public void registerSingleInstance(UDHolder holder, String key) {
        this.registerUserdata(holder);
        this.registerSingleInstance(new SIHolder(key, holder.luaClassName));
    }

    public void registerSingleInstance(SIHolder h) {
        this.siHolders.add(h);
    }

    public static SIHolder newSingleInstanceHolder(String luaKey, String luaClassName) {
        return new SIHolder(luaKey, luaClassName);
    }

    public static final class SIHolder {
        public final String luaKey;
        public final String luaClassName;

        private SIHolder(String luaKey, String luaClassName) {
            this.luaKey = luaKey;
            this.luaClassName = luaClassName;
        }
    }

    public static final class SHolder {
        public String luaClassName;
        public Class clz;
        public String[] methods;

        private SHolder(String lcn, Class clz, String[] methods) {
            this.luaClassName = lcn;
            this.clz = clz;
            this.methods = methods;
        }
    }

    public static final class UDHolder {
        public String luaClassName;
        public Class<? extends LuaUserdata> clz;
        public String[] methods;
        public boolean lazy = false;

        private UDHolder(String lcn, Class<? extends LuaUserdata> clz, boolean lazy, String[] methods) {
            this.luaClassName = lcn;
            this.clz = clz;
            this.methods = methods;
            this.lazy = lazy;
        }
    }

    private final class AllUserdataHolder {
        final int INIT = 50;
        final List<String> lcns = new ArrayList<String>(50);
        final List<String> lpcns = new ArrayList<String>(50);
        final List<String> jcns = new ArrayList<String>(50);
        final List<String> methods = new ArrayList<String>(500);
        int[] mc = new int[50];
        boolean[] lazy = new boolean[50];
        int index = 0;

        private AllUserdataHolder() {
        }

        void clear() {
            this.lcns.clear();
            this.lpcns.clear();
            this.jcns.clear();
            this.methods.clear();
            this.mc = new int[50];
            this.lazy = new boolean[50];
            this.index = 0;
        }

        void add(UDHolder h) {
            this.lcns.add(h.luaClassName);
            String parentName = Globals.findLuaParentClass(h.clz, Register.this.luaClassNameMap);
            if (h.luaClassName.equals(parentName)) {
                parentName = null;
            }
            this.lpcns.add(parentName);
            this.jcns.add(SignatureUtils.getClassName(h.clz));
            int m = h.methods != null ? h.methods.length : 0;
            this.mc = this.set(this.mc, this.index, m);
            this.lazy = this.set(this.lazy, this.index, h.lazy);
            ++this.index;
            this.methods.addAll(Arrays.asList(h.methods));
            Register.this.luaClassNameMap.put(h.clz, h.luaClassName);
        }

        void install(Globals g) {
            this.mc = this.get(this.mc, this.index);
            this.lazy = this.get(this.lazy, this.index);
            g.registerAllUserdata(this.lcns.toArray(new String[this.index]), this.lpcns.toArray(new String[this.index]), this.jcns.toArray(new String[this.index]), this.lazy);
            g.putLuaClassName(Register.this.luaClassNameMap);
        }

        void preInstall() {
            this.mc = this.get(this.mc, this.index);
            String[] ams = this.methods.toArray(new String[0]);
            int use = 0;
            for (int i = 0; i < this.index; ++i) {
                String[] ms = new String[this.mc[i]];
                System.arraycopy(ams, use, ms, 0, this.mc[i]);
                Globals.preRegisterUserdata(this.jcns.get(i), ms);
                use += this.mc[i];
            }
        }

        private int[] set(int[] arr, int index, int value) {
            if (arr.length > index) {
                arr[index] = value;
                return arr;
            }
            int[] ret2 = Arrays.copyOf(arr, arr.length + 10);
            ret2[index] = value;
            return ret2;
        }

        private boolean[] set(boolean[] arr, int index, boolean value) {
            if (arr.length > index) {
                arr[index] = value;
                return arr;
            }
            boolean[] ret2 = Arrays.copyOf(arr, arr.length + 10);
            ret2[index] = value;
            return ret2;
        }

        private int[] get(int[] arr, int len2) {
            if (arr.length == len2) {
                return arr;
            }
            return Arrays.copyOf(arr, len2);
        }

        private boolean[] get(boolean[] arr, int len2) {
            if (arr.length == len2) {
                return arr;
            }
            return Arrays.copyOf(arr, len2);
        }
    }

    private static final class NumberEnumHolder
    extends EnumHolder {
        private double[] values;

        NumberEnumHolder(String luaClassName, String[] keys, double[] values) {
            super(luaClassName, keys);
            this.values = values;
        }
    }

    private static final class StringEnumHolder
    extends EnumHolder {
        private String[] values;

        StringEnumHolder(String luaClassName, String[] keys, String[] values) {
            super(luaClassName, keys);
            this.values = values;
        }
    }

    public static class EnumHolder {
        public String luaClassName;
        public String[] keys;

        EnumHolder(String luaClassName, String[] keys) {
            this.luaClassName = luaClassName;
            this.keys = keys;
        }
    }
}

