/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics;

import com.immomo.mlservics.Register;
import com.immomo.mmpaas.utils.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.luaj.vm2.Globals;

public class MMPassBuilder {
    private final List<Register.UDHolder> udVHolders;
    private final List<Register.UDHolder> udCHolders;
    private final List<Class> constantsClass;
    private final Register register;
    private boolean clearAll = false;

    public MMPassBuilder(Register register) {
        this.register = register;
        this.udCHolders = new ArrayList<Register.UDHolder>();
        this.udVHolders = new ArrayList<Register.UDHolder>();
        this.constantsClass = new ArrayList<Class>();
    }

    public MMPassBuilder clearAll() {
        this.udVHolders.clear();
        this.constantsClass.clear();
        this.clearAll = true;
        return this;
    }

    public MMPassBuilder registerVUD(Register.UDHolder ... holder) {
        this.udVHolders.addAll(Arrays.asList(holder));
        return this;
    }

    public MMPassBuilder registerCUD(Register.UDHolder ... holder) {
        this.udCHolders.addAll(Arrays.asList(holder));
        return this;
    }

    public MMPassBuilder registerConstants(Class ... clz) {
        this.constantsClass.addAll(Arrays.asList(clz));
        return this;
    }

    public MMPassBuilder build() {
        if (this.clearAll) {
            this.register.clearAll();
            return this;
        }
        for (Register.UDHolder h : this.udCHolders) {
            this.register.registerUserdata(h);
        }
        for (Register.UDHolder h : this.udVHolders) {
            this.register.registerUserdata(h);
        }
        for (Class c : this.constantsClass) {
            this.register.registerEnum(c);
        }
        this.register.preInstall();
        return this;
    }

    public List<Register.UDHolder> getUdVHolders() {
        return this.udVHolders;
    }

    public Globals createGlobals() {
        if (SwingUtilities.isEventDispatchThread()) {
            Globals g = Globals.createLState(false);
            this.register.install(g, true);
            return g;
        }
        try {
            final Globals[] out = new Globals[1];
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    out[0] = Globals.createLState(false);
                    MMPassBuilder.this.register.install(out[0], true);
                }
            });
            return out[0];
        }
        catch (Exception e) {
            Log.e(e, "init global error", new Object[0]);
            return null;
        }
    }
}

