/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics;

import com.immomo.mlservics.LuaViewManager;
import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.ud.view.UDWindow;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.utils.CurrentPathUtils;
import com.immomo.mmpaas.utils.Log;
import com.immomo.mmpaas.utils.P;
import com.immomo.ui.values.RequireSourceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.exception.InvokeError;

public class LuaInstance {
    public static final int FILE_TYPE_STATE = 1;
    public static final int FILE_TYPE_TABLE = 2;
    public static final int CODE_FILE_NOT_FOUND = -404;
    public static final int LOAD_FAILED = -1;
    public static final int EXE_FAILED = -2;
    public static final int SUCCESS = 0;
    private int fileType;
    private int state;
    private Throwable error;
    private Context context;
    private JComponent container;
    private Globals globals;
    private StateChangeListener stateChangeListener;
    private LuaWindow luaWindow;
    private boolean hasSetFinder = false;

    public LuaWindow getLuaWindow() {
        return this.luaWindow;
    }

    public LuaInstance(Context context2) {
        this.context = context2;
    }

    public void setContainer(JComponent container) {
        this.container = container;
    }

    public void setPath(String path) {
        File target = this.getRealFile(path);
        if (target == null) {
            this.state = -404;
            this.error = new FileNotFoundException(String.format("cannot find %s in (%s, %s)", path, CurrentPathUtils.getCopySourceFile(""), CurrentPathUtils.getPath()));
            this.callStateChanged();
            return;
        }
        SwingUtilities.invokeLater(() -> this.load(target));
    }

    public void setStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    public int getState() {
        return this.state;
    }

    public Throwable getError() {
        return this.error;
    }

    private void load(File target) {
        LuaValue[] result;
        this.fileType = 1;
        this.globals = Application.getApp().createGlobals();
        this.globals.setJavaUserdata(new LuaViewManager(this.context));
        if (!this.hasSetFinder) {
            this.globals.setResourceFinder(RequireSourceUtil.getNormalResourceFinder(target));
            this.globals.addResourceFinder(RequireSourceUtil.getStdLibraryResourceFinder());
        }
        boolean loadresult = false;
        if (Application.getApp().isPlugin()) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VirtualFileManager.constructUrl((String)"file", (String)target.getAbsolutePath()));
            if (virtualFile != null) {
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                loadresult = document == null || !this.globals.loadData(target.getName(), document.getText().getBytes());
            }
        } else {
            boolean bl = loadresult = !this.globals.loadFile(target.getPath(), target.getName());
        }
        if (loadresult) {
            this.state = -1;
            this.error = this.globals.getError();
            this.callStateChanged();
            return;
        }
        this.luaWindow = this.createWindow(this.globals);
        try {
            result = this.globals.callLoadedDataAndGetResult();
        }
        catch (Exception e) {
            this.state = -2;
            this.error = e;
            this.callStateChanged();
            Log.e(e.getMessage(), new Object[0]);
            return;
        }
        if (result == null || result.length != 1 || !result[0].isTable()) {
            this.state = 0;
            this.callStateChanged();
            return;
        }
        this.loadUIGenerator(result);
    }

    public LuaWindow createWindow(Globals globals) {
        LuaWindow window = (LuaWindow)((UDWindow)globals.createUserdataAndSet("window", "__WINDOW", new LuaValue[0])).getView();
        window.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        window.setPhonePanel(this.container);
        this.container.removeAll();
        this.container.add(window);
        return window;
    }

    public void reload(String path) {
        this.container.removeAll();
        try {
            if (this.globals != null) {
                this.globals.destroy();
            }
        }
        catch (Exception e) {
            Log.e(e.getMessage(), new Object[0]);
        }
        this.setPath(path);
    }

    private void loadUIGenerator(LuaValue[] args) {
        LuaValue[] result;
        this.fileType = 2;
        String assets = CurrentPathUtils.getCopySourceFile("");
        this.globals.setBasePath(assets, false);
        File root = new File(assets, P.generator.generatorFun);
        if (!this.globals.loadFile(root.getPath(), root.getName())) {
            this.state = -1;
            this.error = this.globals.getError();
            this.callStateChanged();
            return;
        }
        try {
            result = this.globals.callLoadedDataAndGetResult();
        }
        catch (Exception e) {
            this.state = -2;
            this.error = e;
            this.callStateChanged();
            Log.e(e.getMessage(), new Object[0]);
            return;
        }
        try {
            result[0].toLuaFunction().invoke(args);
        }
        catch (InvokeError e) {
            Log.e(e.getMessage(), new Object[0]);
            this.state = -2;
            this.error = e;
            this.callStateChanged();
            return;
        }
        this.state = 0;
        this.callStateChanged();
    }

    private File getRealFile(String path) {
        File f = new File(path);
        if (f.isFile() && f.canRead()) {
            return f;
        }
        f = new File(CurrentPathUtils.getCopySourceFile(""), path);
        if (f.isFile() && f.canRead()) {
            return f;
        }
        f = new File(CurrentPathUtils.getPath(), path);
        if (f.isFile() && f.canRead()) {
            return f;
        }
        return null;
    }

    private void callStateChanged() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onStateChanged(this.fileType, this.state, this.error);
        }
    }

    public static interface StateChangeListener {
        public void onStateChanged(int var1, int var2, Throwable var3);
    }
}

