/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mlservics;

import com.immomo.mlservics.Environment;
import org.luaj.vm2.Globals;

public class ErrorUtils {
    public static void unsupportError(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public static void debugUnsupportError(String msg) {
        if (Environment.DEBUG) {
            ErrorUtils.unsupportError(msg);
        }
    }

    public static void debugDeprecatedMethod(String s) {
        if (Environment.DEBUG) {
            ErrorUtils.unsupportError("The method '" + s + "' is deprecated!");
        }
    }

    public static void debugIllegalStateError(String msg) {
        if (Environment.DEBUG) {
            throw new IllegalStateException(msg);
        }
    }

    public static void debugDeprecatedSetter(String s, Globals globals) {
        if (Environment.DEBUG) {
            // empty if block
        }
    }

    public static void debugDeprecatedMethodHook(String method, Globals globals) {
        if (Environment.DEBUG) {
            Environment.hook(new UnsupportedOperationException("The method '" + method + "' is deprecated!"), globals);
        }
    }

    public static void debugDeprecatedGetter(String s, Globals globals) {
        if (Environment.DEBUG) {
            // empty if block
        }
    }

    public static void debugLuaError(String msg, Globals g) {
        if (Environment.DEBUG) {
            // empty if block
        }
    }

    public static void debugEnvironmentError(String msg, Globals globals) {
        IllegalStateException e;
        if (Environment.DEBUG && !Environment.hook(e = new IllegalStateException(msg), globals)) {
            throw e;
        }
    }
}

