/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils.git;

import com.immomo.luanative.utils.FileUtils;
import com.immomo.luanative.utils.Log;
import com.immomo.luanative.utils.NotInstalledException;
import com.immomo.luanative.utils.ShellExecutor;
import com.immomo.luanative.utils.git.GitException;
import java.io.File;
import java.io.IOException;

public class GitExecutor {
    private static final String ERROR_PREFIX = "fatal:";

    public static void init() throws Exception {
        String config = "/usr/local/git/etc/gitconfig";
        File file = new File("/usr/local/git/etc/gitconfig");
        if (!file.exists()) {
            throw new NotInstalledException("git");
        }
        File bak = new File("/usr/local/git/etc/gitconfig_bakforln");
        if (bak.exists()) {
            return;
        }
        String userHomePath = System.getProperty("user.home");
        if (userHomePath.endsWith(File.separator)) {
            userHomePath = userHomePath.substring(0, userHomePath.length() - 1);
        }
        FileUtils.copyFile(file, bak);
        byte[] source = FileUtils.readFile(file);
        String s = new String(source);
        if (s.contains("~")) {
            s = s.replaceAll("~", userHomePath);
            FileUtils.writeData(file, s.getBytes());
        }
    }

    public static void checkout(File dir, String branch) throws IOException, GitException {
        String result = ShellExecutor.executeAndGetError("git checkout " + branch, dir);
        if (!GitExecutor.hasError(result)) {
            return;
        }
        result = ShellExecutor.executeAndGetError("git checkout -b " + branch + " origin/" + branch, dir);
        if (GitExecutor.hasError(result)) {
            throw new GitException(result);
        }
    }

    public static void newBranch(File dir, String branch) throws IOException, GitException {
        block3: {
            try {
                GitExecutor.checkout(dir, branch);
            }
            catch (Throwable t) {
                String result = ShellExecutor.executeAndGetError("git checkout -b " + branch, dir);
                if (GitExecutor.hasError(result)) {
                    throw new GitException(result);
                }
                result = ShellExecutor.executeAndGetError("git push --set-upstream origin " + branch, dir);
                if (!GitExecutor.hasError(result)) break block3;
                throw new GitException(result);
            }
        }
    }

    public static void commitAndPush(File dir, String commitMsg) throws IOException, GitException {
        String result = ShellExecutor.executeAndGetError("git add --all", dir);
        if (GitExecutor.hasError(result)) {
            throw new GitException(result);
        }
        result = ShellExecutor.executeAndGetError("git commit -m \"" + commitMsg + "\"", dir);
        if (GitExecutor.hasError(result)) {
            throw new GitException(result);
        }
        result = ShellExecutor.executeAndGetError("git push", dir);
        if (GitExecutor.hasError(result)) {
            throw new GitException(result);
        }
    }

    public static void cloneGit(String gitSite, File dir) throws IOException, GitException {
        String cmd = "git clone " + gitSite + " " + dir.getAbsolutePath();
        String result = ShellExecutor.executeAndGetError(cmd, null);
        Log.d(result, new Object[0]);
        if (GitExecutor.hasError(result)) {
            throw new GitException(result);
        }
    }

    private static boolean hasError(String result) {
        return result != null && (result.contains("error") || result.startsWith(ERROR_PREFIX));
    }
}

