/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils.fep;

import com.immomo.luanative.utils.AssertUtils;
import com.immomo.luanative.utils.FileUtils;
import com.immomo.luanative.utils.Log;
import com.immomo.luanative.utils.ShellException;
import com.immomo.luanative.utils.ShellExecutor;
import com.immomo.luanative.utils.fep.FepConfigs;
import com.immomo.luanative.utils.git.GitExecutor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.concurrent.Callable;

public class FepTask
implements Callable<Void> {
    private static final String LOG = "\u68c0\u67e5fep\u73af\u5883\uff0c\u6267\u884c`npm set registry https://npm.wemomo.com`\uff0c\u518d\u6267\u884c`sudo npm install -g @fes/fep-cli`(\u5b89\u88c5fep)\u6216`sudo npm update -g @fes/fep-cli`(\u66f4\u65b0fep)\n\u68c0\u67e5\u767b\u9646\u8d26\u53f7\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e";
    private final String gitSite;
    private final File sourceDir;
    private final File gitDir;
    private final FepConfigs configs;
    private Callback callback;

    public FepTask(String gitSite, File sourceDir, FepConfigs configs) throws IOException, InterruptedException, ShellException {
        this(gitSite, sourceDir, null, configs);
    }

    public FepTask(String gitSite, File sourceDir, File gitDir, FepConfigs configs) throws IOException, InterruptedException, ShellException {
        AssertUtils.assertNull(gitSite, new String[0]);
        AssertUtils.assertNull(configs, new String[0]);
        AssertUtils.assertExsits(sourceDir, new String[0]);
        configs.packDir = sourceDir.getName();
        configs.check();
        this.gitSite = gitSite;
        this.sourceDir = sourceDir;
        this.configs = configs;
        int idx = gitSite.lastIndexOf(47);
        AssertUtils.assertTrue(idx > 0, new String[0]);
        String name = gitSite.substring(idx + 1);
        idx = name.lastIndexOf(46);
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        if (gitDir == null) {
            String currentPath = this.pwd();
            this.gitDir = new File(currentPath, name);
        } else {
            AssertUtils.assertDir(gitDir, new String[0]);
            this.gitDir = new File(gitDir, name);
        }
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public File getGitDir() {
        return this.gitDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.tryCallback("Clone");
        GitExecutor.cloneGit(this.gitSite, this.gitDir);
        AssertUtils.assertDir(this.gitDir, new String[0]);
        try {
            this.tryCallback("branch");
            GitExecutor.newBranch(this.gitDir, this.configs.versionX);
            this.tryCallback("move");
            this.removeAllSrcFiles(this.gitDir);
            File dest = new File(this.gitDir, this.sourceDir.getName());
            AssertUtils.assertTrue(FileUtils.moveFile(this.sourceDir, dest), new String[0]);
            this.tryCallback("config");
            this.setFepConfigs(this.gitDir);
            this.tryCallback("push");
            GitExecutor.commitAndPush(this.gitDir, this.configs.commitMsg);
            this.tryCallback("fep");
            try {
                String s = ShellExecutor.execute(new String[]{"fep login " + this.configs.mmid + " " + this.configs.psw, "echo y", "fep prepub --default"}, this.gitDir);
                Log.d(s, new Object[0]);
            }
            catch (ShellException | IOException e) {
                String msg = "fep error: " + e.getMessage() + " \n" + LOG;
                throw new Exception(msg);
            }
        }
        finally {
            FileUtils.deleteFile(this.gitDir);
        }
        return null;
    }

    private String pwd() throws IOException, ShellException, InterruptedException {
        return ShellExecutor.execute("pwd", null);
    }

    private void removeAllSrcFiles(File root) throws IOException {
        File[] children = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().startsWith(".");
            }
        });
        if (children == null || children.length == 0) {
            return;
        }
        for (File child : children) {
            FileUtils.deleteFile(child);
        }
        File ignore = new File(root, ".gitignore");
        if (!ignore.isFile()) {
            ignore.createNewFile();
            FileUtils.writeData(ignore, ".fes".getBytes());
        }
    }

    private void setFepConfigs(File root) throws IOException {
        File config = new File(root, ".fes" + File.separator + "fep" + File.separator + "config.json");
        if (!config.isFile()) {
            AssertUtils.assertParent(config, new String[0]);
            config.createNewFile();
        }
        AssertUtils.assertFile(config, new String[0]);
        FileUtils.writeData(config, this.configs.toJsonString().getBytes());
    }

    private void tryCallback(String task) {
        if (this.callback != null) {
            this.callback.before(task);
        }
    }

    public static interface Callback {
        public void before(String var1);
    }
}

