/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils;

import com.immomo.luanative.utils.AssertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeZip(File files, File dest, boolean containRoot) throws IOException {
        AssertUtils.assertExsits(files, new String[0]);
        if (dest.exists() && !dest.delete()) {
            throw new FileAlreadyExistsException(dest.getAbsolutePath() + " exists and cannot be deleted");
        }
        if (!dest.createNewFile()) {
            throw new IOException("cannot create file " + dest.getAbsolutePath());
        }
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(dest));){
            if (containRoot || files.isFile()) {
                ZipUtils.addZipEntry(files, os, files.getName());
            } else {
                File[] children = files.listFiles();
                if (children == null || children.length == 0) {
                    return;
                }
                for (File child : children) {
                    ZipUtils.addZipEntry(child, os, child.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addZipEntry(File f, ZipOutputStream os, String name) throws IOException {
        byte[] buf = new byte[2048];
        if (f.isFile()) {
            os.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = new FileInputStream(f);){
                int len2;
                while ((len2 = in.read(buf)) != -1) {
                    os.write(buf, 0, len2);
                }
                os.closeEntry();
            }
        } else if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children == null || children.length == 0) {
                os.putNextEntry(new ZipEntry(name + File.separator));
                os.closeEntry();
            } else {
                for (File child : children) {
                    ZipUtils.addZipEntry(child, os, name + File.separator + child.getName());
                }
            }
        } else {
            throw new FileNotFoundException(f.getAbsolutePath() + " not found");
        }
    }
}

