/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils;

import com.immomo.luanative.utils.IOUtil;
import com.immomo.luanative.utils.ShellException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ShellExecutor {
    private static String[] shellEnv;

    public static void setEnvironment(Map<String, String> env) {
        if (env == null || env.isEmpty()) {
            shellEnv = null;
            return;
        }
        int len2 = env.size();
        shellEnv = new String[len2];
        int index = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            ShellExecutor.shellEnv[index++] = e.getKey() + "=" + e.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execute(String cmd, File dir) throws IOException, ShellException, InterruptedException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd, shellEnv, dir);
            int v = p.waitFor();
            InputStream err = p.getErrorStream();
            byte[] data = IOUtil.toBytes(err);
            String msg = null;
            if (data != null && !(msg = new String(data).trim()).isEmpty()) {
                throw new ShellException(v, msg);
            }
            InputStream is = p.getInputStream();
            data = IOUtil.toBytes(is);
            if (data == null) {
                String string = null;
                return string;
            }
            String string = msg = new String(data).trim();
            return string;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execute(String[] cmds, File dir) throws IOException, InterruptedException, ShellException {
        Process p = null;
        int len2 = cmds.length;
        String[] rcmds = new String[3];
        rcmds[0] = "/bin/sh";
        rcmds[1] = "-c";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len2; ++i) {
            sb.append(cmds[i]);
            if (i == len2 - 1) continue;
            sb.append(" | ");
        }
        rcmds[2] = sb.toString();
        try {
            p = Runtime.getRuntime().exec(rcmds, shellEnv, dir);
            int v = p.waitFor();
            if (v != 0) {
                InputStream err = p.getErrorStream();
                byte[] data = IOUtil.toBytes(err);
                String msg = null;
                if (data == null) {
                    data = IOUtil.toBytes(p.getInputStream());
                }
                if (data != null && !(msg = new String(data).trim()).isEmpty()) {
                    throw new ShellException(v, msg);
                }
                throw new ShellException(v, "unknown");
            }
            byte[] data = IOUtil.toBytes(p.getInputStream());
            if (data == null) {
                String string = null;
                return string;
            }
            String string = new String(data).trim();
            return string;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeAndGetError(String cmd, File dir) throws IOException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd, shellEnv, dir);
            InputStream err = p.getErrorStream();
            byte[] data = IOUtil.toBytes(err);
            String msg = null;
            if (data != null && !(msg = new String(data).trim()).isEmpty()) {
                String string = msg;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }
}

