/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils;

import com.immomo.luanative.utils.AssertUtils;
import com.immomo.luanative.utils.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtils {
    public static void deleteFile(File f) {
        if (f.isFile()) {
            f.delete();
        } else if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children != null && children.length != 0) {
                for (File child : children) {
                    FileUtils.deleteFile(child);
                }
            }
            f.delete();
        }
    }

    public static byte[] readFile(File f) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(f);
        return IOUtil.toBytes(inputStream);
    }

    public static boolean moveFile(File src, File dest) throws FileNotFoundException {
        if (src.isFile()) {
            AssertUtils.assertParent(dest, new String[0]);
            return src.renameTo(dest);
        }
        if (src.isDirectory()) {
            File[] children = src.listFiles();
            if (children != null && children.length != 0) {
                for (File child : children) {
                    if (FileUtils.moveFile(child, new File(dest, child.getName()))) continue;
                    return false;
                }
            }
            src.delete();
            return true;
        }
        return false;
    }

    public static void copyFile(File src, File dest) throws IOException {
        if (src.isFile()) {
            AssertUtils.assertParent(dest, new String[0]);
            FileUtils.fastCopy(src, dest);
        } else if (src.isDirectory()) {
            File[] children = src.listFiles();
            if (children == null || children.length == 0) {
                return;
            }
            for (File child : children) {
                FileUtils.copyFile(child, new File(dest, child.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fastCopy(File from, File to) throws IOException {
        FileInputStream inputStream = null;
        FileChannel inChannel = null;
        FileOutputStream outputStream = null;
        FileChannel outChannel = null;
        try {
            inputStream = new FileInputStream(from);
            inChannel = inputStream.getChannel();
            outputStream = new FileOutputStream(to);
            outChannel = outputStream.getChannel();
            outChannel.transferFrom(inChannel, 0L, from.length());
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(inChannel);
            IOUtil.closeQuietly(outputStream);
            IOUtil.closeQuietly(outChannel);
            throw throwable;
        }
        IOUtil.closeQuietly(inputStream);
        IOUtil.closeQuietly(inChannel);
        IOUtil.closeQuietly(outputStream);
        IOUtil.closeQuietly(outChannel);
    }

    public static void writeData(File file, byte[] data) throws IOException {
        try (FileOutputStream os = null;){
            os = new FileOutputStream(file);
            os.write(data);
            os.flush();
        }
    }
}

