/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils;

import com.immomo.luanative.utils.AssertUtils;
import com.immomo.luanative.utils.CompileError;
import com.immomo.luanative.utils.Log;
import com.immomo.luanative.utils.ShellException;
import com.immomo.luanative.utils.ShellExecutor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class Compiler {
    public static final int iOS_x32 = 0;
    public static final int iOS_x64 = 1;
    public static final int Android_x32 = 2;
    public static final int Android_x64 = 3;
    public static final String[] luacs = new String[]{"iOS_x32", "iOS_x64", "Android_x32", "Android_x64"};
    private static String currentPath = null;

    public static void setPath(String path) {
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        currentPath = path;
    }

    public static void setLuac(int type2, String name) {
        Compiler.checkType(type2);
        Compiler.luacs[type2] = name;
    }

    public static void compile(File src, File dest, int type2) throws CompileError, IOException, ShellException, InterruptedException {
        Compiler.checkType(type2);
        AssertUtils.assertFile(src, new String[0]);
        AssertUtils.assertParent(dest, new String[0]);
        if (currentPath == null && (currentPath = ShellExecutor.execute("pwd", null)) == null) {
            throw new NullPointerException("currentPath is null");
        }
        String cmd = currentPath + File.separator + luacs[type2] + " -o " + dest.getAbsoluteFile() + " " + src.getAbsoluteFile();
        String result = ShellExecutor.executeAndGetError(cmd, null);
        if (result != null) {
            int index = result.indexOf(58);
            if (index > 0) {
                result = result.substring(index + 1);
            }
            throw new CompileError(result);
        }
        AssertUtils.assertFile(dest, new String[0]);
    }

    public static void compileDir(File dir, File dest, String suffix, int type2) throws IOException, CompileError, ShellException, InterruptedException {
        Compiler.compileDir(dir, dest, new SuffixFileFilter(suffix), type2);
    }

    public static void compileDir(File dir, File dest, FileFilter fileFilter, int type2) throws CompileError, IOException, ShellException, InterruptedException {
        AssertUtils.assertDir(dir, new String[0]);
        File[] children = dir.listFiles(fileFilter);
        if (children == null) {
            return;
        }
        for (File child : children) {
            File childDest = new File(dest, child.getName());
            if (child.isFile()) {
                Log.d("compiling file %s   ======>   %s", child.getAbsolutePath(), childDest.getAbsolutePath());
                Compiler.compile(child, childDest, type2);
                continue;
            }
            Compiler.compileDir(child, childDest, fileFilter, type2);
        }
    }

    private static void checkType(int type2) {
        AssertUtils.assertTrue(type2 >= 0 && type2 < luacs.length, "type is invalid");
    }

    private static final class SuffixFileFilter
    implements FileFilter {
        private final String suffix;

        SuffixFileFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File pathname) {
            if (this.suffix == null || this.suffix.isEmpty()) {
                return true;
            }
            return pathname.getName().endsWith(this.suffix) || pathname.isDirectory();
        }
    }
}

