/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.utils;

import java.io.File;
import java.io.FileNotFoundException;

public class AssertUtils {
    public static void assertTrue(boolean b, String ... msg) {
        if (!b) {
            throw new AssertionError((Object)AssertUtils.getErrorMsg(msg));
        }
    }

    public static void assertNull(Object o, String ... msg) {
        if (o == null) {
            throw new NullPointerException(AssertUtils.getErrorMsg(msg));
        }
    }

    public static void assertZero(Number n, String ... msg) {
        if (n.longValue() == 0L) {
            throw new NullPointerException(AssertUtils.getErrorMsg(msg));
        }
    }

    public static void assertFile(File f, String ... msg) throws FileNotFoundException {
        if (!f.isFile()) {
            throw new FileNotFoundException(AssertUtils.getErrorMsg(msg) + f.getAbsolutePath());
        }
    }

    public static void assertParent(File f, String ... msg) throws FileNotFoundException {
        File p = f.getParentFile();
        if (!p.isDirectory() && !p.mkdirs()) {
            throw new FileNotFoundException(AssertUtils.getErrorMsg(msg) + f.getAbsolutePath());
        }
    }

    public static void assertDir(File f, String ... msg) throws FileNotFoundException {
        if (!f.isDirectory()) {
            throw new FileNotFoundException(AssertUtils.getErrorMsg(msg) + f.getAbsolutePath());
        }
    }

    public static void assertExsits(File f, String ... msg) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(AssertUtils.getErrorMsg(msg) + f.getAbsolutePath());
        }
    }

    private static String getErrorMsg(String ... msg) {
        return "assert failed" + (msg != null && msg.length > 0 ? msg[0] : "");
    }
}

