/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util.search;

import com.immomo.luanative.project.toolwindow.views.iConsoleView;
import com.immomo.luanative.util.LuaNativeUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsoleSearchUtil {
    private List<Integer> searchedPositionList;
    private int currentIndex = 0;
    private iConsoleView consoleView;
    private String searchKey;
    private StyledDocument doc;
    private static final int logHeadrLength = 30;

    public ConsoleSearchUtil(iConsoleView consoleView) {
        this.consoleView = consoleView;
    }

    public void search(StyledDocument doc, String searchKey) {
        this.searchedPositionList = this.search(doc, searchKey, -1);
        this.currentIndex = 0;
        this.doc = doc;
        this.searchKey = searchKey;
    }

    public void search(StyledDocument doc) {
        if (this.searchKey == null || this.searchKey.length() <= 0) {
            return;
        }
        this.searchedPositionList = this.search(doc, this.searchKey, -1);
        this.currentIndex = 0;
        this.doc = doc;
    }

    public void scrollToNext(String key) {
        if (this.searchedPositionList != null && this.searchedPositionList.size() > 0) {
            if (this.currentIndex >= this.searchedPositionList.size()) {
                this.currentIndex = 0;
            }
            Integer position = this.searchedPositionList.get(this.currentIndex);
            this.search(this.doc, this.searchKey, position);
            this.consoleView.scrollToPosition(key, position);
            ++this.currentIndex;
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getCurrentCount() {
        if (this.searchedPositionList == null) {
            return 0;
        }
        return this.searchedPositionList.size();
    }

    private List<Integer> search(StyledDocument doc, String searchKey, int position) {
        if (searchKey.length() <= 0) {
            return null;
        }
        String patternKey = LuaNativeUtil.escapeSpecialWord(searchKey);
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Element root = doc.getDefaultRootElement();
        SimpleAttributeSet searched = new SimpleAttributeSet();
        StyleConstants.setBackground(searched, Color.gray);
        SimpleAttributeSet searchSelected = new SimpleAttributeSet();
        StyleConstants.setBackground(searchSelected, Color.orange);
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element seg = root.getElement(i);
            try {
                String line = doc.getText(seg.getStartOffset(), seg.getEndOffset() - seg.getStartOffset());
                Pattern p = Pattern.compile(patternKey);
                Matcher m = p.matcher(line);
                while (m.find()) {
                    if (m.start() <= 30) continue;
                    positions.add(seg.getStartOffset() + m.start());
                    if (position == seg.getStartOffset() + m.start()) {
                        doc.setCharacterAttributes(seg.getStartOffset() + m.start(), searchKey.length(), searchSelected, true);
                        continue;
                    }
                    doc.setCharacterAttributes(seg.getStartOffset() + m.start(), searchKey.length(), searched, true);
                }
                continue;
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
        return positions;
    }
}

