/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util.document;

import com.immomo.luanative.codec.protobuf.PBErrorCommand;
import com.immomo.luanative.codec.protobuf.PBLogCommand;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LuaNativeDocumentUtil {
    private static final Color logColor = new Color(187, 187, 187);
    private static final Color errorColor = new Color(190, 50, 12);
    private static final Color linkColor = new Color(0, 116, 201);
    private static String rexFile = "\"/*([a-zA-Z0-9\u4e00-\u9fa5_]+/)*[a-zA-Z0-9\u4e00-\u9fa5_]+.lua\"";
    private static String rexLine = ":[0-9]+";
    private static Pattern pFile = Pattern.compile(rexFile);
    private static Pattern pLine = Pattern.compile(rexLine);

    public static void addLog(StyledDocument styledDocument, PBLogCommand.pblogcommand cmd) {
        SimpleDateFormat format0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        long timestamp = cmd.getBasecommand().getTimestamp();
        String time = format0.format(new Date(timestamp));
        String info = null;
        info = "[LOG] " + time + "  " + cmd.getLog();
        if (info != null && !info.endsWith("\n")) {
            info = info + "\n";
        }
        LuaNativeDocumentUtil.addConsoleInfo(styledDocument, info, false);
    }

    public static void addError(StyledDocument styledDocument, PBErrorCommand.pberrorcommand cmd) {
        SimpleDateFormat format0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        long timestamp = cmd.getBasecommand().getTimestamp();
        String time = format0.format(new Date(timestamp));
        String info = null;
        info = "[ERROR] " + time + "  " + cmd.getError();
        if (info != null && !info.endsWith("\n")) {
            info = info + "\n";
        }
        LuaNativeDocumentUtil.addConsoleInfo(styledDocument, info, true);
    }

    public static void addConsoleInfo(StyledDocument styledDocument, String info, boolean isError) {
        int start = 0;
        if (isError) {
            Matcher pFMatch = pFile.matcher(info);
            while (pFMatch.find()) {
                String lineStr;
                int lineStart;
                String luaFile = pFMatch.group();
                String luaLine = "";
                if (luaFile.contains("DebuggerToolTip")) continue;
                int cEnd = pFMatch.start();
                String cString = info.substring(start, cEnd);
                LuaNativeDocumentUtil.setStyleDocumentString(styledDocument, LuaNativeDocumentUtil.getCommonAttribute(true, false), cString);
                SimpleAttributeSet attributeSet = LuaNativeDocumentUtil.getCommonAttribute(true, true);
                attributeSet.addAttribute("file", luaFile.replace("\"", ""));
                start = lineStart = pFMatch.end();
                int lineEnd = lineStart + 10;
                if (lineEnd > info.length()) {
                    lineEnd = info.length();
                }
                if ((lineStr = info.substring(lineStart, lineEnd)) != null) {
                    Matcher pLMatch = pLine.matcher(lineStr);
                    if (pLMatch.find()) {
                        luaLine = pLMatch.group();
                    }
                    attributeSet.addAttribute("line", luaLine.replace(":", ""));
                }
                LuaNativeDocumentUtil.setStyleDocumentString(styledDocument, attributeSet, luaFile);
            }
        }
        if (start == 0) {
            LuaNativeDocumentUtil.setStyleDocumentString(styledDocument, LuaNativeDocumentUtil.getCommonAttribute(isError, false), info);
        } else {
            int cEnd = info.length();
            String cString = info.substring(start, cEnd);
            LuaNativeDocumentUtil.setStyleDocumentString(styledDocument, LuaNativeDocumentUtil.getCommonAttribute(isError, false), cString);
        }
    }

    private static SimpleAttributeSet getCommonAttribute(boolean isError, boolean isLink) {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(attributeSet, 15);
        if (isError) {
            StyleConstants.setForeground(attributeSet, errorColor);
            StyleConstants.setBold(attributeSet, true);
        } else {
            StyleConstants.setForeground(attributeSet, logColor);
        }
        if (isLink) {
            StyleConstants.setUnderline(attributeSet, true);
            StyleConstants.setForeground(attributeSet, linkColor);
        }
        return attributeSet;
    }

    private static void setStyleDocumentString(StyledDocument styledDocument, SimpleAttributeSet attributeSet, String string) {
        try {
            styledDocument.insertString(styledDocument.getLength(), string, attributeSet);
        }
        catch (BadLocationException ee) {
            ee.printStackTrace();
        }
    }
}

