/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util.consolefilter;

import com.immomo.luanative.util.consolefilter.iConsoleFilter;
import com.immomo.luanative.util.consolefilter.impl.ErrorConsoleFilter;
import com.immomo.luanative.util.consolefilter.impl.KeyConsoleFilter;
import com.immomo.luanative.util.consolefilter.impl.LogConsoleFilter;
import com.immomo.luanative.util.consolefilter.impl.VerboseConsoleFilter;

public class ConsoleFilterFactory {
    public static final int CONSOLE_FILTER_LOG = 1;
    public static final int CONSOLE_FILTER_ERROR = 2;
    public static final int CONSOLE_FILTER_VERBOSE = 3;
    public static iConsoleFilter logFilter = new LogConsoleFilter();
    public static iConsoleFilter errorFilter = new ErrorConsoleFilter();
    public static iConsoleFilter verboseConsoleFilter = new VerboseConsoleFilter();
    public static iConsoleFilter keyFilter = new KeyConsoleFilter();

    public static iConsoleFilter getFilterChain(int type2, String config) {
        iConsoleFilter filter = ConsoleFilterFactory.getInstance(type2);
        if (filter != null && config != null) {
            iConsoleFilter keyFilter = ConsoleFilterFactory.getInstance(config);
            filter.setNextFilter(keyFilter);
        }
        return filter;
    }

    public static iConsoleFilter getInstance(String config) {
        keyFilter.setFilterConfig(config);
        keyFilter.setNextFilter(null);
        return keyFilter;
    }

    public static iConsoleFilter getInstance(int type2) {
        iConsoleFilter filter = null;
        switch (type2) {
            case 1: {
                filter = logFilter;
                break;
            }
            case 2: {
                filter = errorFilter;
                break;
            }
            case 3: {
                filter = verboseConsoleFilter;
            }
        }
        if (filter != null) {
            filter.setNextFilter(null);
        }
        return filter;
    }
}

