/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.luanative.util.adb;

import com.immomo.luanative.util.adb.iAdbListener;
import com.intellij.util.ReflectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AdbUtil {
    private static String userHomePath = System.getProperty("user.home");
    private static String myBinDir = userHomePath + "/bin";
    private static String adbPath = myBinDir + "/adb";

    public static void findDeives(iAdbListener listener) throws IOException {
        String adb = AdbUtil.findAdb();
        String str = null;
        Process process2 = Runtime.getRuntime().exec(adb + " devices -l");
        InputStream in = process2.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in));
        while ((str = read.readLine()) != null) {
            if (str.startsWith("List of devices attached") || listener == null) continue;
            listener.onListDevice(str);
        }
        read.close();
        read = null;
    }

    public static void doPortForward(int src_port, int dst_port) throws IOException {
        String adb = AdbUtil.findAdb();
        String cmd = adb + " forward tcp:" + src_port + " tcp:" + dst_port;
        Process process2 = Runtime.getRuntime().exec(cmd);
        InputStream in = process2.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in));
        String ret2 = read.readLine();
        if (ret2 != null && Integer.valueOf(ret2) != dst_port) {
            throw new IOException("adb " + dst_port + "\u7aef\u53e3\u8f6c\u53d1\u5931\u8d25," + ret2);
        }
        read.close();
    }

    public static boolean checkPortForward(int src_port, int dst_port) throws IOException {
        String adb = AdbUtil.findAdb();
        String cmd = adb + " forward --list";
        Process process2 = Runtime.getRuntime().exec(cmd);
        InputStream in = process2.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in));
        String ret2 = null;
        while ((ret2 = read.readLine()) != null) {
            String[] substr;
            if (!ret2.contains("tcp:") || !ret2.contains("tcp:") || (substr = ret2.split(" +")).length != 3) continue;
            String srcStr = substr[1].replace("tcp:", "");
            if (srcStr == null) {
                return false;
            }
            String dstStr = substr[2].replace("tcp:", "");
            if (dstStr == null) {
                return false;
            }
            int src = Integer.valueOf(srcStr);
            int dst = Integer.valueOf(dstStr);
            return dst == src_port && src == src_port;
        }
        return false;
    }

    public static void removePortForward(int dst_port) throws IOException {
        String adb = AdbUtil.findAdb();
        String cmd = adb + " forward --remove tcp:" + dst_port;
        Runtime.getRuntime().exec(cmd);
    }

    private static String findAdb() throws IOException {
        File retFile = new File(adbPath);
        if (retFile.exists()) {
            return adbPath;
        }
        File dirFile = new File(myBinDir);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        InputStream in = ReflectionUtil.getGrandCallerClass().getResourceAsStream("/mybin/adb");
        FileOutputStream out = new FileOutputStream(retFile);
        byte[] bf = new byte[0x100000];
        int readSize = 0;
        while ((readSize = in.read(bf)) > 0) {
            out.write(bf, 0, readSize);
        }
        Runtime.getRuntime().exec("chmod a+x " + adbPath);
        return adbPath;
    }
}

